//web socket setup
var socket = io.connect('http://localhost:3000')

onSocketNotification = function(data) {
	console.log(data);
};

//console log received data received from socket with "data"
// socket.on("data", (data) =>{
// 	range = data.split("\t")[0].split(" ")[1]; //parse out the range value from the string sent over socket
// 	console.log(range);
// 	rangeInt = parseInt(range); // convert from string to int
// 	sensorHeight = rangeInt/1000;
// 	animate(); // update plane position
// });

socket.on("waveHeight", (wave) =>{
	console.log("From Client: Recieved new wave height value of: "+wave+"ft.")
	setWaveHeight(wave);
})
var sensorHeight = 0; 

const SEPARATION = 50, AMOUNTX = 4, AMOUNTY = 4;
let container, stats;
let camera, scene, renderer;
let particles, particle, count = 0;

var level = 15;
//wave level - high, medium, lola
function setWaveHeight(wave){
	if (wave < 3){
		level = 5;
	}
	if (wave > 3 && wave < 5){
		level = 15;
	}
	if (wave >= 5){
		level = 40;
	}
}


function init() {
  container = document.getElementById('waveDisplay');
  document.body.appendChild(container);
  camera = new THREE.PerspectiveCamera(60, window.innerWidth / window.innerHeight, 0.1, 10000 );
  camera.position.z = 300; // Good var to change
  scene = new THREE.Scene();
  particles = new Array();
  var geometry = new THREE.CircleGeometry( 5, 32 );
  var material = new THREE.MeshBasicMaterial( { 
	  color: 0xffffff
	  
	 } );
  

  var i = 0;
  for ( var ix = 0; ix < AMOUNTX; ix ++ ) {
    for ( var iy = 0; iy < AMOUNTY; iy ++ ) {
      particle = particles[ i ++ ] = new THREE.Mesh( geometry, material );
      particle.position.x = ix * SEPARATION - ( ( AMOUNTX * SEPARATION ) / 2 ) + 20;
      particle.position.z = iy * SEPARATION - ( ( AMOUNTY * SEPARATION ) / 2 );
      particle.scale.x = particle.scale.y = 1;
      scene.add(particle);

      if (i > 0) {
        geometry.vertices.push( particle.position );
      }
    }
  }

  renderer = new THREE.WebGLRenderer();
  renderer.setPixelRatio(window.devicePixelRatio);
  renderer.setSize(window.innerWidth, window.innerHeight);
  container.appendChild(renderer.domElement);
  window.addEventListener( 'resize', onWindowResize, false );
}

function selectLocation(location){
	console.log("From Client: Sending request to server for wave height at: "+location);
	socket.emit("getLocationData", location);
}

function onWindowResize() {
  windowHalfX = window.innerWidth / 2;
  windowHalfY = window.innerHeight / 2;
  camera.aspect = window.innerWidth / window.innerHeight;
  camera.updateProjectionMatrix();
  renderer.setSize( window.innerWidth, window.innerHeight );
}


function animate() {
  requestAnimationFrame( animate );
  render();
}

function render() {
  renderer.setClearColor( 0x000000, 1);
  camera.lookAt( scene.position );
  var i = 0;
  for (var ix = 0; ix < AMOUNTX; ix++) {
    for (var iy = 0; iy < AMOUNTY; iy++) {
      particle = particles[i++];
      particle.position.y = (Math.sin((ix + count) * 0.7) * level) + (Math.sin((iy + count) * 0.7) * level);
    }
  }
  renderer.render(scene, camera);
  count += 0.01;
}

init();
animate();