#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_ADDR 0x3C

Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);

const int buttonPin_1 = 1;
const int buttonPin_2 = 2;


int mode = 0;
int num_pages = 6;
bool lastButtonState_1 = LOW;
bool lastButtonState_2 = LOW;


void drawMode(int m) {
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0, 20);

  if (m==0){
    display.println("Starting");
    display.println("Oscilli-");
    display.println("synth");
    display.display();
    delay(1000);
    display.println("");
    display.println("Buttons:");
    display.println("");
    display.println("top");
    display.println("= next");
    display.println("bottom");
    display.println("= back");
    display.display();
  } else if (m==1){
    display.println("Have fun!");
    display.display();
  } else if (m==2){
    display.println("Exercise 1");
    display.println("Twist RV1,");
    display.println("then RV2.");
    display.println("");
    display.println("What changed?");
    display.display();
  } else if (m==3){
    display.println("Exercise 2");
    display.println("Twist the potentiometer");
    display.println("on the filter");
    display.println("");
    display.println("What changed?");
    display.display();
  } else if (m==4) {
    display.println("Exercise 3");
    display.println("Use an oscilliscope");
    display.println("to probe the signals");
    display.display();
  } else if (m==5) {
    display.println("Exercise 4");
    display.println("Ask a question!");
    display.display();
  } else if (m==6) {
    display.println("Thanks for");
    display.println("playing!");
    display.display();
    m==0;
  }
}


void setup() {
  pinMode(buttonPin_1, INPUT_PULLDOWN);  // important!
  pinMode(buttonPin_2, INPUT_PULLDOWN);  // important!


  Wire.begin();

  if (!display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR)) {
    while (1); // halt if OLED not found
  }

  display.setRotation(1);
  display.clearDisplay();
  drawMode(0);
}

void loop() {
  bool buttonState_1 = digitalRead(buttonPin_1); // active high
  bool buttonState_2 = digitalRead(buttonPin_2); // active high


  // Detect button press (edge-triggered)
  if (buttonState_1 && !lastButtonState_1) {
    mode++;
    if (mode > num_pages) mode = 1;
    drawMode(mode);
  }
  // Detect button press (edge-triggered)
  if (buttonState_2 && !lastButtonState_2) {
    mode--;
    if (mode < 0) mode = 1;
    drawMode(mode);
  }

  lastButtonState_1 = buttonState_1;
  lastButtonState_2 = buttonState_2;
  delay(20); // debounce
}
