//
// PWM sine wave with serial-controlled frequency
// For XIAO RP2040 + TB67H451
//

#define sample_frequency 44100
#define sample_period_us (1000000.0 / sample_frequency)
#define sample_scale 0.75
#define pwm_frequency 50000
#define pwm_range 65535

uint32_t tstart = 0;
float pitch = 440.0;     // default note (A4)
String inputString = "";
bool stringComplete = false;

void setup() {
  Serial.begin(115200);
  analogWriteFreq(pwm_frequency);
  analogWriteRange(pwm_range);
  inputString.reserve(32);
}

void loop() {
  handleSerial();

  uint32_t now = micros();

  // Output sample
  if ((now - tstart) >= sample_period_us) {
    tstart = now;

    float s = sin(2.0 * PI * pitch * now / 1e6);
    int duty = (int)(s * pwm_range);

    if (duty > 0) {
      analogWrite(D0, 0);
      analogWrite(D1, duty * sample_scale);
    } else {
      analogWrite(D0, -duty * sample_scale);
      analogWrite(D1, 0);
    }
  }
}

//
// SERIAL INPUT HANDLER
//
void handleSerial() {
  while (Serial.available()) {
    char c = Serial.read();

    if (c == '\n' || c == '\r') {
      if (inputString.length() > 0) {
        float newPitch = inputString.toFloat();

        if (newPitch > 0) {
          pitch = newPitch;
          Serial.print("Pitch set to: ");
          Serial.println(pitch);
        } else {
          Serial.println("Invalid pitch");
        }

        inputString = "";
      }
    } else {
      inputString += c;
    }
  }
}
