import time
time.sleep(0.1) # Wait for USB to become ready

from machine import Pin

# LED on GP0
led = Pin(0, Pin.OUT)

# Button on GP6, using internal pull-up
button = Pin(6, Pin.IN, Pin.PULL_UP)

print("Press the button to turn the LED on!")

while True:
    if button.value() == 0:   # 0 means button is pressed (active low)
        led.value(1)         # turn LED on
    else:
        led.value(0)         # turn LED off
