#include <WiFi.h>
#include <WiFiUdp.h>
#include <Wire.h>
#include "nvs_flash.h"

WiFiUDP udp;

// IMU I2C address
#define address 0x6B

// WiFi credentials
const char* ssid = "MIT";
const char* password = "zeky[4rm}H";

// UDP target
const char* udp_host = "10.29.253.197";
const int udp_port = 5005;

// ------------------ I2C functions ------------------
void I2C_write_reg(uint8_t addr,uint8_t reg,uint8_t value) {
  Wire.beginTransmission(addr);
  Wire.write(reg);
  Wire.write(value);
  if (Wire.endTransmission() != 0)
    Serial.println("I2C_write_reg failure");
}

uint8_t I2C_read_reg(uint8_t addr,uint8_t reg) {
  Wire.beginTransmission(addr);
  Wire.write(reg);
  if (Wire.endTransmission() != 0)
    Serial.println("I2C_read_reg failure");
  Wire.requestFrom(addr,1);
  return Wire.read();
}

void npy_half_to_float(uint16_t h,float *f) {
  union { float ret; uint32_t retbits; } conv;
  uint16_t h_exp,h_sig;
  uint32_t f_sgn,f_exp,f_sig;
  h_exp = (h & 0x7c00u);
  f_sgn = ((uint32_t)h & 0x8000u) << 16;
  switch (h_exp) {
    case 0x0000u:
      h_sig = (h & 0x03ffu);
      if (h_sig == 0) { *f = f_sgn; return; }
      h_sig <<= 1;
      while ((h_sig & 0x0400u) == 0) { h_sig <<= 1; h_exp++; }
      f_exp = ((uint32_t)(127-15-h_exp)) << 23;
      f_sig = ((uint32_t)(h_sig & 0x03ffu)) << 13;
      *f = f_sgn + f_exp + f_sig;
      return;
    case 0x7c00u:
      *f = f_sgn+0x7f800000u+(((uint32_t)(h & 0x03ffu)) << 13);
      return;
    default:
      *f = f_sgn+(((uint32_t)(h & 0x7fffu)+0x1c000u) << 13);
      return;
  }
}

void sflp2q(float *qx,float *qy,float *qz,float *qw,uint16_t x,uint16_t y,uint16_t z) {
  float sumsq = 0;
  npy_half_to_float(x,qx);
  npy_half_to_float(y,qy);
  npy_half_to_float(z,qz);
  sumsq = (*qx)*(*qx)+(*qy)*(*qy)+(*qz)*(*qz);
  if (sumsq > 1.0f) {
    float n = sqrtf(sumsq);
    *qx /= n; *qy /= n; *qz /= n;
    sumsq = 1.0f;
  }
  *qw = sqrtf(1.0f-sumsq);
}

void IMU_read_int(uint8_t *tag,int16_t *x,int16_t *y,int16_t *z) {
  uint8_t xlo,xhi,ylo,yhi,zlo,zhi;
  *tag = I2C_read_reg(address,0x78) >> 3;
  xlo = I2C_read_reg(address,0x79); xhi = I2C_read_reg(address,0x7A);
  *x = (xhi << 8) | xlo;
  ylo = I2C_read_reg(address,0x7B); yhi = I2C_read_reg(address,0x7C);
  *y = (yhi << 8) | ylo;
  zlo = I2C_read_reg(address,0x7D); zhi = I2C_read_reg(address,0x7E);
  *z = (zhi << 8) | zlo;
}

void IMU_read_quaternion(uint8_t *tag,float *qx,float *qy,float *qz,float *qw) {
  uint8_t xlo,xhi,ylo,yhi,zlo,zhi;
  uint16_t ix,iy,iz;
  *tag = I2C_read_reg(address,0x78) >> 3;
  xlo = I2C_read_reg(address,0x79); xhi = I2C_read_reg(address,0x7A); ix = (xhi << 8) | xlo;
  ylo = I2C_read_reg(address,0x7B); yhi = I2C_read_reg(address,0x7C); iy = (yhi << 8) | ylo;
  zlo = I2C_read_reg(address,0x7D); zhi = I2C_read_reg(address,0x7E); iz = (zhi << 8) | zlo;
  sflp2q(qx,qy,qz,qw,ix,iy,iz);
}

// ------------------ Setup ------------------
void setup() {
  Serial.begin(115200);
  delay(1000);

  nvs_flash_erase();
  nvs_flash_init();

  WiFi.mode(WIFI_STA);
  WiFi.setAutoReconnect(true);
  WiFi.persistent(true);
  WiFi.begin(ssid,password);

  Serial.print("Connecting to WiFi");
  while (WiFi.status() != WL_CONNECTED) {
    delay(200);
    Serial.print(".");
  }

  Serial.println("\nWiFi connected!");
  Serial.print("IP: ");
  Serial.println(WiFi.localIP());

  udp.begin(udp_port);

  Wire.begin();
  Wire.setClock(1000000);

  // IMU init (unchanged)
  I2C_write_reg(address,0x10,0x06);
  I2C_write_reg(address,0x11,0x06);
  I2C_write_reg(address,0x12,0x44);
  I2C_write_reg(address,0x13,0x00);
  I2C_write_reg(address,0x14,0x00);
  I2C_write_reg(address,0x15,0x03);
  I2C_write_reg(address,0x16,0x00);
  I2C_write_reg(address,0x17,0x00);
  I2C_write_reg(address,0x18,0x00);
  I2C_write_reg(address,0x19,0x00);
  I2C_write_reg(address,0x01,0x80);
  I2C_write_reg(address,0x04,0b00000010);
  I2C_write_reg(address,0x44,0b00010010);
  I2C_write_reg(address,0x01,0x00);
  I2C_write_reg(address,0x05,0);
  I2C_write_reg(address,0x07,0);
  I2C_write_reg(address,0x08,0);
  I2C_write_reg(address,0x09,0b01100110);
  I2C_write_reg(address,0x0A,0b00000110);
  I2C_write_reg(address,0x5E,0b01011011);
}

// ------------------ Main Loop ------------------
void loop() {

  // ===== WIFI CHECK (ADDED) =====
  if (WiFi.status() != WL_CONNECTED) {
    Serial.println("WiFi disconnected, reconnecting...");
    WiFi.reconnect();

    unsigned long start = millis();
    while (WiFi.status() != WL_CONNECTED && millis() - start < 5000) {
      delay(200);
      Serial.print(".");
    }

    if (WiFi.status() != WL_CONNECTED) {
      Serial.println("\nReconnect failed, skipping loop");
      delay(100);
      return;
    }

    Serial.println("\nReconnected!");
    Serial.print("IP: ");
    Serial.println(WiFi.localIP());
  }
  // =============================

  uint8_t tag;
  int16_t x,y,z;
  float qx,qy,qz,qw;

  while(true){
    IMU_read_int(&tag,&x,&y,&z);
    if(tag==2) break;
  }
  char accel_packet[64];
  int len = snprintf(accel_packet,sizeof(accel_packet),"ACCEL,%d,%d,%d",x,y,z);
  udp.beginPacket(udp_host,udp_port);
  udp.write((uint8_t*)accel_packet,len);
  udp.endPacket();

  while(true){
    IMU_read_int(&tag,&x,&y,&z);
    if(tag==1) break;
  }
  char gyro_packet[64];
  len = snprintf(gyro_packet,sizeof(gyro_packet),"GYRO,%d,%d,%d",x,y,z);
  udp.beginPacket(udp_host,udp_port);
  udp.write((uint8_t*)gyro_packet,len);
  udp.endPacket();

  while(true){
    IMU_read_int(&tag,&x,&y,&z);
    if(tag==0x17) break;
  }
  char grav_packet[64];
  len = snprintf(grav_packet,sizeof(grav_packet),"GRAV,%d,%d,%d",x,y,z);
  udp.beginPacket(udp_host,udp_port);
  udp.write((uint8_t*)grav_packet,len);
  udp.endPacket();

  while(true){
    IMU_read_quaternion(&tag,&qx,&qy,&qz,&qw);
    if(tag==0x13) break;
  }
  char quat_packet[128];
  len = snprintf(quat_packet,sizeof(quat_packet),
                 "QUAT,%.6f,%.6f,%.6f,%.6f",qw,qx,qy,qz);
  udp.beginPacket(udp_host,udp_port);
  udp.write((uint8_t*)quat_packet,len);
  udp.endPacket();

  delay(5);
}



// #include <WiFi.h>
// #include <WiFiUdp.h>
// #include <Wire.h>
// #include "nvs_flash.h"

// WiFiUDP udp;

// // IMU I2C address
// #define address 0x6B

// // WiFi credentials
// const char* ssid = "MIT";
// const char* password = "zeky[4rm}H";

// // UDP target
// const char* udp_host = "10.29.253.197";   // Your PC/server IP
// const int udp_port = 5005;

// // ------------------ I2C functions (from sample code) ------------------
// void I2C_write_reg(uint8_t addr,uint8_t reg,uint8_t value) {
//   Wire.beginTransmission(addr);
//   Wire.write(reg);
//   Wire.write(value);
//   if (Wire.endTransmission() != 0)
//     Serial.println("I2C_write_reg failure");
// }

// uint8_t I2C_read_reg(uint8_t addr,uint8_t reg) {
//   Wire.beginTransmission(addr);
//   Wire.write(reg);
//   if (Wire.endTransmission() != 0)
//     Serial.println("I2C_read_reg failure");
//   Wire.requestFrom(addr,1);
//   return Wire.read();
// }

// void npy_half_to_float(uint16_t h,float *f) {
//   union { float ret; uint32_t retbits; } conv;
//   uint16_t h_exp,h_sig;
//   uint32_t f_sgn,f_exp,f_sig;
//   h_exp = (h & 0x7c00u);
//   f_sgn = ((uint32_t)h & 0x8000u) << 16;
//   switch (h_exp) {
//     case 0x0000u:
//       h_sig = (h & 0x03ffu);
//       if (h_sig == 0) { *f = f_sgn; return; }
//       h_sig <<= 1;
//       while ((h_sig & 0x0400u) == 0) { h_sig <<= 1; h_exp++; }
//       f_exp = ((uint32_t)(127-15-h_exp)) << 23;
//       f_sig = ((uint32_t)(h_sig & 0x03ffu)) << 13;
//       *f = f_sgn + f_exp + f_sig;
//       return;
//     case 0x7c00u:
//       *f = f_sgn+0x7f800000u+(((uint32_t)(h & 0x03ffu)) << 13);
//       return;
//     default:
//       *f = f_sgn+(((uint32_t)(h & 0x7fffu)+0x1c000u) << 13);
//       return;
//   }
// }

// void sflp2q(float *qx,float *qy,float *qz,float *qw,uint16_t x,uint16_t y,uint16_t z) {
//   float sumsq = 0;
//   npy_half_to_float(x,qx);
//   npy_half_to_float(y,qy);
//   npy_half_to_float(z,qz);
//   sumsq = (*qx)*(*qx)+(*qy)*(*qy)+(*qz)*(*qz);
//   if (sumsq > 1.0f) {
//     float n = sqrtf(sumsq);
//     *qx /= n; *qy /= n; *qz /= n;
//     sumsq = 1.0f;
//   }
//   *qw = sqrtf(1.0f-sumsq);
// }

// void IMU_read_int(uint8_t *tag,int16_t *x,int16_t *y,int16_t *z) {
//   uint8_t xlo,xhi,ylo,yhi,zlo,zhi;
//   *tag = I2C_read_reg(address,0x78) >> 3;
//   xlo = I2C_read_reg(address,0x79); xhi = I2C_read_reg(address,0x7A);
//   *x = (xhi << 8) | xlo;
//   ylo = I2C_read_reg(address,0x7B); yhi = I2C_read_reg(address,0x7C);
//   *y = (yhi << 8) | ylo;
//   zlo = I2C_read_reg(address,0x7D); zhi = I2C_read_reg(address,0x7E);
//   *z = (zhi << 8) | zlo;
// }

// void IMU_read_quaternion(uint8_t *tag,float *qx,float *qy,float *qz,float *qw) {
//   uint8_t xlo,xhi,ylo,yhi,zlo,zhi;
//   uint16_t ix,iy,iz;
//   *tag = I2C_read_reg(address,0x78) >> 3;
//   xlo = I2C_read_reg(address,0x79); xhi = I2C_read_reg(address,0x7A); ix = (xhi << 8) | xlo;
//   ylo = I2C_read_reg(address,0x7B); yhi = I2C_read_reg(address,0x7C); iy = (yhi << 8) | ylo;
//   zlo = I2C_read_reg(address,0x7D); zhi = I2C_read_reg(address,0x7E); iz = (zhi << 8) | zlo;
//   sflp2q(qx,qy,qz,qw,ix,iy,iz);
// }

// // ------------------ Setup ------------------
// void setup() {
//   Serial.begin(115200);
//   delay(1000);
//   nvs_flash_erase();
//   nvs_flash_init();

//   // WiFi
//   WiFi.mode(WIFI_STA);
//   WiFi.begin(ssid,password);
//   Serial.print("Connecting to WiFi");
//   while (WiFi.status()!=WL_CONNECTED) { delay(200); Serial.print("."); }
//   Serial.println("\nWiFi connected!");
//   Serial.print("IP: "); Serial.println(WiFi.localIP());

//   // I2C
//   Wire.begin(); Wire.setClock(1000000);

//   // Initialize IMU (same as your sample)
//   I2C_write_reg(address,0x10,0x06);
//   I2C_write_reg(address,0x11,0x06);
//   I2C_write_reg(address,0x12,0x44);
//   I2C_write_reg(address,0x13,0x00);
//   I2C_write_reg(address,0x14,0x00);
//   I2C_write_reg(address,0x15,0x03);
//   I2C_write_reg(address,0x16,0x00);
//   I2C_write_reg(address,0x17,0x00);
//   I2C_write_reg(address,0x18,0x00);
//   I2C_write_reg(address,0x19,0x00);
//   I2C_write_reg(address,0x01,0x80);
//   I2C_write_reg(address,0x04,0b00000010);
//   I2C_write_reg(address,0x44,0b00010010);
//   I2C_write_reg(address,0x01,0x00);
//   I2C_write_reg(address,0x05,0);
//   I2C_write_reg(address,0x07,0);
//   I2C_write_reg(address,0x08,0);
//   I2C_write_reg(address,0x09,0b01100110);
//   I2C_write_reg(address,0x0A,0b00000110);
//   I2C_write_reg(address,0x5E,0b01011011);
// }

// // ------------------ Main Loop ------------------
// // ... your existing includes and definitions ...

// void loop() {
//   uint8_t tag;
//   int16_t x,y,z;
//   float qx,qy,qz,qw;

//   // ------------------ ACCEL ------------------
//   while(true){
//     IMU_read_int(&tag,&x,&y,&z);
//     if(tag==2) break;
//   }
//   char accel_packet[64];
//   int len = snprintf(accel_packet,sizeof(accel_packet),"ACCEL,%d,%d,%d",x,y,z);
//   Serial.printf("Sending: %s\n", accel_packet);  // DEBUG
//   udp.beginPacket(udp_host,udp_port);
//   udp.write((uint8_t*)accel_packet,len);
//   udp.endPacket();

//   // ------------------ GYRO ------------------
//   while(true){
//     IMU_read_int(&tag,&x,&y,&z);
//     if(tag==1) break;
//   }
//   char gyro_packet[64];
//   len = snprintf(gyro_packet,sizeof(gyro_packet),"GYRO,%d,%d,%d",x,y,z);
//   Serial.printf("Sending: %s\n", gyro_packet);  // DEBUG
//   udp.beginPacket(udp_host,udp_port);
//   udp.write((uint8_t*)gyro_packet,len);
//   udp.endPacket();

//   // ------------------ GRAVITY ------------------
//   while(true){
//     IMU_read_int(&tag,&x,&y,&z);
//     if(tag==0x17) break;
//   }
//   char grav_packet[64];
//   len = snprintf(grav_packet,sizeof(grav_packet),"GRAV,%d,%d,%d",x,y,z);
//   Serial.printf("Sending: %s\n", grav_packet);  // DEBUG
//   udp.beginPacket(udp_host,udp_port);
//   udp.write((uint8_t*)grav_packet,len);
//   udp.endPacket();

//   // ------------------ QUATERNION ------------------
//   while(true){
//     IMU_read_quaternion(&tag,&qx,&qy,&qz,&qw);
//     if(tag==0x13) break;
//   }
//   char quat_packet[128];
//   len = snprintf(quat_packet,sizeof(quat_packet),"QUAT,%.6f,%.6f,%.6f,%.6f",qw,qx,qy,qz);
//   // Serial.printf("Sending: %s\n", quat_packet);  // DEBUG
//   udp.beginPacket(udp_host,udp_port);
//   udp.write((uint8_t*)quat_packet,len);
//   udp.endPacket();

//   delay(5); // ~200 Hz
// }

