#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <math.h>

// --- OLED setup ---
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1 // not used
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// --- Thermistor setup ---
const int THERMISTOR_PIN = A0;  // analog input (A0 = D0 on XIAO)
const float BETA = 3950;        // Beta coefficient
// if using 10k thermistor, with 10k resistor voltage divider

void setup() {
  Serial.begin(9600);

  // Initialize OLED
  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // 0x3C is default I2C address
    Serial.println(F("SSD1306 allocation failed"));
    for (;;); // stop if display fails
  }

  display.clearDisplay();
  display.setTextColor(SSD1306_WHITE);
  display.setTextSize(1);
  display.setCursor(0, 0);
  display.println("Thermistor Sensor");
  display.display();
  delay(1000);
}

void loop() {
  int analogValue = analogRead(THERMISTOR_PIN);
  // Note: XIAO ESP32S3 ADC range is 12-bit (0–4095)
  // If you're adapting code from 10-bit (0–1023), adjust accordingly.
  float celsius = 1 / (log(1 / (4095.0 / analogValue - 1)) / BETA + 1.0 / 298.15) - 273.15;

  Serial.print("Temperature: ");
  Serial.print(celsius);
  Serial.println(" ℃");

  // --- Display on OLED ---
  display.clearDisplay();
  display.setTextSize(2);
  display.setCursor(0, 10);
  display.print(celsius, 1);
  display.println(" C");
  display.display();

  delay(1000);
}
