#include <SPI.h>
#include <MFRC522.h>

// Match this to the wiring above:
#define SS_PIN   5   // RC522 SDA / SS
#define RST_PIN  43   // RC522 RST
#define SCK_PIN  7
#define MOSI_PIN 9
#define MISO_PIN 8

MFRC522 rfid(SS_PIN, RST_PIN);

void setup() {
  Serial.begin(115200);
  while (!Serial) { ; }

  // Use custom SPI pins for XIAO ESP32-S3
  SPI.begin(SCK_PIN, MISO_PIN, MOSI_PIN, SS_PIN);

  rfid.PCD_Init();
  Serial.println("RC522 reader started. Scan a tag/card...");
}

void loop() {
  // Look for new cards
  if (!rfid.PICC_IsNewCardPresent()) return;
  if (!rfid.PICC_ReadCardSerial())   return;

  Serial.print("Card UID:");
  for (byte i = 0; i < rfid.uid.size; i++) {
    Serial.print(" ");
    Serial.print(rfid.uid.uidByte[i] < 0x10 ? "0" : "");
    Serial.print(rfid.uid.uidByte[i], HEX);
  }
  Serial.println();

  rfid.PICC_HaltA();
  rfid.PCD_StopCrypto1();
}