/*
 * Copyright (c) 2024 EdgeImpulse Inc.
 *
 * Generated by Edge Impulse and licensed under the applicable Edge Impulse
 * Terms of Service. Community and Professional Terms of Service
 * (https://edgeimpulse.com/legal/terms-of-service) or Enterprise Terms of
 * Service (https://edgeimpulse.com/legal/enterprise-terms-of-service),
 * according to your product plan subscription (the “License”).
 *
 * This software, documentation and other associated files (collectively referred
 * to as the “Software”) is a single SDK variation generated by the Edge Impulse
 * platform and requires an active paid Edge Impulse subscription to use this
 * Software for any purpose.
 *
 * You may NOT use this Software unless you have an active Edge Impulse subscription
 * that meets the eligibility requirements for the applicable License, subject to
 * your full and continued compliance with the terms and conditions of the License,
 * including without limitation any usage restrictions under the applicable License.
 *
 * If you do not have an active Edge Impulse product plan subscription, or if use
 * of this Software exceeds the usage limitations of your Edge Impulse product plan
 * subscription, you are not permitted to use this Software and must immediately
 * delete and erase all copies of this Software within your control or possession.
 * Edge Impulse reserves all rights and remedies available to enforce its rights.
 *
 * Unless required by applicable law or agreed to in writing, the Software is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing
 * permissions, disclaimers and limitations under the License.
 */
#ifndef __EI_DSP_HANDLE__H__
#define __EI_DSP_HANDLE__H__

#include "edge-impulse-sdk/dsp/config.hpp"
#include "edge-impulse-sdk/dsp/numpy_types.h"
#include "edge-impulse-sdk/classifier/ei_classifier_types.h"

class DspHandle {
public:
    /**
     * @brief Override and call ei_printf to print debug information, especially the current state
     *
     * @return int
     */
    virtual int print() = 0;

    /**
     * @brief Override and convert raw data into processed features. Any state should live inside your custom class.
     * Provide a constructor to initialize your state.
     *
     * @param signal Callback object to get raw data from
     * @param output_matrix Output matrix to write features to
     * @param config Configuration object, generated by Studio based on your DSP block parameters
     * @param frequency Sampling frequency, as set in your project
     * @param result Result object to write HR to. NULLABLE!
     * @return int 0 on success, anything else for failure
     */
    virtual int extract(
        ei::signal_t *signal,
        ei::matrix_t *output_matrix,
        void *config,
        const float frequency,
        ei_impulse_result_t *result) = 0; // result* is a hack.  I want to pass full context everywhere but custom DSP. TODO

    // Must declare so user can override
    /**
     * @brief If you call new or ei_malloc anywhere in your class, you must override this function and delete your objects
     *
     */
    virtual ~DspHandle() {};
};

#endif //!__EI_DSP_HANDLE__H__