/*
 * Copyright (c) 2025 EdgeImpulse Inc.
 *
 * Generated by Edge Impulse and licensed under the applicable Edge Impulse
 * Terms of Service. Community and Professional Terms of Service
 * (https://edgeimpulse.com/legal/terms-of-service) or Enterprise Terms of
 * Service (https://edgeimpulse.com/legal/enterprise-terms-of-service),
 * according to your product plan subscription (the “License”).
 *
 * This software, documentation and other associated files (collectively referred
 * to as the “Software”) is a single SDK variation generated by the Edge Impulse
 * platform and requires an active paid Edge Impulse subscription to use this
 * Software for any purpose.
 *
 * You may NOT use this Software unless you have an active Edge Impulse subscription
 * that meets the eligibility requirements for the applicable License, subject to
 * your full and continued compliance with the terms and conditions of the License,
 * including without limitation any usage restrictions under the applicable License.
 *
 * If you do not have an active Edge Impulse product plan subscription, or if use
 * of this Software exceeds the usage limitations of your Edge Impulse product plan
 * subscription, you are not permitted to use this Software and must immediately
 * delete and erase all copies of this Software within your control or possession.
 * Edge Impulse reserves all rights and remedies available to enforce its rights.
 *
 * Unless required by applicable law or agreed to in writing, the Software is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing
 * permissions, disclaimers and limitations under the License.
 */

#ifndef _EI_CLASSIFIER_MODEL_VARIABLES_H_
#define _EI_CLASSIFIER_MODEL_VARIABLES_H_

/**
 * @file
 *  Auto-generated complete impulse definitions. The ei_impulse_handle_t should
 *  be passed to ei_run_classifier() function to use this specific impulse.
 *  This file should only be included in ei_run_classifier.h file.
 */

#include <stdint.h>
#include "model_metadata.h"
#include "tflite-model/tflite_learn_828368_19_compiled.h"
#include "edge-impulse-sdk/classifier/ei_model_types.h"
#include "edge-impulse-sdk/classifier/inferencing_engines/engines.h"
#include "edge-impulse-sdk/classifier/postprocessing/ei_postprocessing_common.h"

const char* ei_classifier_inferencing_categories_828368_1[] = { "face" };

EI_CLASSIFIER_DSP_AXES_INDEX_TYPE ei_dsp_config_828368_17_axes[] = { 0 };
const uint32_t ei_dsp_config_828368_17_axes_size = 1;
ei_dsp_config_image_t ei_dsp_config_828368_17 = {
    17, // uint32_t blockId
    1, // int implementationVersion
    1, // int length of axes
    NULL, // named axes
    0, // size of the named axes array
    "RGB" // select channels
};

const uint8_t ei_dsp_blocks_828368_1_size = 1;
ei_model_dsp_t ei_dsp_blocks_828368_1[ei_dsp_blocks_828368_1_size] = {
    { // DSP block 17
        17,
        27648, // output size
        &extract_image_features, // DSP function pointer
        (void*)&ei_dsp_config_828368_17, // pointer to config struct
        ei_dsp_config_828368_17_axes, // array of offsets into the input stream, one for each axis
        ei_dsp_config_828368_17_axes_size, // number of axes
        1, // version
        nullptr, // factory function
        nullptr, // data normalization config
    }
};
const ei_config_tflite_eon_graph_t ei_config_graph_828368_19 = {
    .implementation_version = 1,
    .model_init = &tflite_learn_828368_19_init,
    .model_invoke = &tflite_learn_828368_19_invoke,
    .model_reset = &tflite_learn_828368_19_reset,
    .model_input = &tflite_learn_828368_19_input,
    .model_output = &tflite_learn_828368_19_output,
};

const uint8_t ei_output_tensors_indices_828368_19[1] = { 0 };
const uint8_t ei_output_tensors_size_828368_19 = 1;
ei_learning_block_config_tflite_graph_t ei_learning_block_config_828368_19 = {
    .implementation_version = 1,
    .block_id = 19,
    .output_tensors_indices = ei_output_tensors_indices_828368_19,
    .output_tensors_size = ei_output_tensors_size_828368_19,
    .quantized = 1,
    .compiled = 1,
    .graph_config = (void*)&ei_config_graph_828368_19,
    .dequantize_output = 0,
};

const uint8_t ei_learning_blocks_828368_1_size = 1;
const uint32_t ei_learning_block_828368_19_inputs[1] = { 17 };
const uint8_t ei_learning_block_828368_19_inputs_size = 1;
const ei_learning_block_t ei_learning_blocks_828368_1[ei_learning_blocks_828368_1_size] = {
    {
        19,
        &run_nn_inference,
        (void*)&ei_learning_block_config_828368_19,
        EI_CLASSIFIER_IMAGE_SCALING_NONE,
        ei_learning_block_828368_19_inputs,
        ei_learning_block_828368_19_inputs_size,
    },
};

ei_fill_result_fomo_i8_config_t ei_fill_result_fomo_i8_config_828368_19 = {
    .threshold = 0.5,
    .out_width = 12,
    .out_height = 12,
    .object_detection_count = 10,
    .zero_point = -128,
    .scale = 0.00390625
};

const size_t ei_postprocessing_blocks_828368_1_size = 1;
const ei_postprocessing_block_t ei_postprocessing_blocks_828368_1[ei_postprocessing_blocks_828368_1_size] = {
    {
        .block_id = 19,
        .type = EI_CLASSIFIER_MODE_OBJECT_DETECTION,
        .init_fn = NULL,
        .deinit_fn = NULL,
        .postprocess_fn = &process_fomo_i8,
        .display_fn = NULL,
        .config = (void*)&ei_fill_result_fomo_i8_config_828368_19,
        .input_block_id = 19
    },
};

const uint8_t freeform_outputs_828368_1_size = 0;

uint32_t *freeform_outputs_828368_1 = nullptr;

const ei_impulse_t impulse_828368_1 = {
    .project_id = 828368,
    .project_owner = "sdajani",
    .project_name = "Face detection - FOMO",
    .impulse_id = 1,
    .impulse_name = "Image data, Image, Object Detection (Images)",
    .deploy_version = 90,

    .nn_input_frame_size = 27648,
    .raw_sample_count = 9216,
    .raw_samples_per_frame = 1,
    .dsp_input_frame_size = 9216 * 1,
    .input_width = 96,
    .input_height = 96,
    .input_frames = 1,
    .interval_ms = 1,
    .frequency = 0,

    .dsp_blocks_size = ei_dsp_blocks_828368_1_size,
    .dsp_blocks = ei_dsp_blocks_828368_1,

    .learning_blocks_size = ei_learning_blocks_828368_1_size,
    .learning_blocks = ei_learning_blocks_828368_1,

    .postprocessing_blocks_size = ei_postprocessing_blocks_828368_1_size,
    .postprocessing_blocks = ei_postprocessing_blocks_828368_1,

    .output_tensors_size = 1,

    .inferencing_engine = EI_CLASSIFIER_TFLITE,

    .sensor = EI_CLASSIFIER_SENSOR_CAMERA,
    .fusion_string = "image",
    .slice_size = (9216/4),
    .slices_per_model_window = 4,

    .has_anomaly = EI_ANOMALY_TYPE_UNKNOWN,
    .label_count = 1,
    .categories = ei_classifier_inferencing_categories_828368_1,
    .results_type = EI_CLASSIFIER_TYPE_OBJECT_DETECTION,
    .freeform_outputs_size = freeform_outputs_828368_1_size,
    .freeform_outputs = freeform_outputs_828368_1
};

ei_impulse_handle_t impulse_handle_828368_1 = ei_impulse_handle_t( &impulse_828368_1 );

ei_impulse_handle_t& ei_default_impulse = impulse_handle_828368_1;
constexpr auto& ei_classifier_inferencing_categories = ei_classifier_inferencing_categories_828368_1;
const auto ei_dsp_blocks_size = ei_dsp_blocks_828368_1_size;
ei_model_dsp_t *ei_dsp_blocks = ei_dsp_blocks_828368_1;
#endif // _EI_CLASSIFIER_MODEL_VARIABLES_H_
