/*
 * Copyright (c) 2025 EdgeImpulse Inc.
 *
 * Generated by Edge Impulse and licensed under the applicable Edge Impulse
 * Terms of Service. Community and Professional Terms of Service
 * (https://edgeimpulse.com/legal/terms-of-service) or Enterprise Terms of
 * Service (https://edgeimpulse.com/legal/enterprise-terms-of-service),
 * according to your product plan subscription (the “License”).
 *
 * This software, documentation and other associated files (collectively referred
 * to as the “Software”) is a single SDK variation generated by the Edge Impulse
 * platform and requires an active paid Edge Impulse subscription to use this
 * Software for any purpose.
 *
 * You may NOT use this Software unless you have an active Edge Impulse subscription
 * that meets the eligibility requirements for the applicable License, subject to
 * your full and continued compliance with the terms and conditions of the License,
 * including without limitation any usage restrictions under the applicable License.
 *
 * If you do not have an active Edge Impulse product plan subscription, or if use
 * of this Software exceeds the usage limitations of your Edge Impulse product plan
 * subscription, you are not permitted to use this Software and must immediately
 * delete and erase all copies of this Software within your control or possession.
 * Edge Impulse reserves all rights and remedies available to enforce its rights.
 *
 * Unless required by applicable law or agreed to in writing, the Software is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing
 * permissions, disclaimers and limitations under the License.
 */
// Generated on: 15.11.2025 23:30:47

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#define STRINGIZE(x) #x
#define STRINGIZE_VALUE_OF(x) STRINGIZE(x)

#if defined (__GNUC__)  /* GNU compiler */
#define ALIGN(X) __attribute__((aligned(X)))
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (_MSC_VER)
#define ALIGN(X) __declspec(align(X))
#elif defined (__TASKING__) /* TASKING Compiler */
#define ALIGN(X) __align(X)
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (__ARMCC_VERSION) /* Arm Compiler */
#define ALIGN(X) __ALIGNED(x)
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (__ICCARM__) /* IAR Compiler */
#define ALIGN(x) __attribute__((aligned(x)))
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (__clang__) /* LLVM/Clang Compiler */
#define ALIGN(X) __ALIGNED(x)
#define DEFINE_SECTION(x) __attribute__((section(x)))
#endif

#if defined(EI_MODEL_SECTION) && (defined(__GNUC__) || defined(__clang__))
#define MODEL_SECTION(X) __attribute__((section(STRINGIZE_VALUE_OF(X))))
#else
#define MODEL_SECTION(X)
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#ifndef CONFIG_IDF_TARGET_ESP32S3
#define EI_MAX_SCRATCH_BUFFER_COUNT 14
#else
#define EI_MAX_SCRATCH_BUFFER_COUNT 28
#endif // CONFIG_IDF_TARGET_ESP32S3
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX) || defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
constexpr int kTensorArenaSize = 242640;
#else
constexpr int kTensorArenaSize = 241616;
#endif

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
#if defined (EI_TENSOR_ARENA_LOCATION)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) DEFINE_SECTION(STRINGIZE_VALUE_OF(EI_TENSOR_ARENA_LOCATION));
#else
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#endif
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};

enum used_operators_e {
  OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_PAD, OP_ADD, OP_SOFTMAX,  OP_LAST
};

struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
  TfLiteQuantization quantization;
};

typedef struct {
  TfLiteTensor tensor;
  int16_t index;
} TfLiteTensorWithIndex;

typedef struct {
  TfLiteEvalTensor tensor;
  int16_t index;
} TfLiteEvalTensorWithIndex;

TfLiteContext ctx{};
static const int MAX_TFL_TENSOR_COUNT = 4;
static TfLiteTensorWithIndex tflTensors[MAX_TFL_TENSOR_COUNT];
static const int MAX_TFL_EVAL_COUNT = 4;
static TfLiteEvalTensorWithIndex tflEvalTensors[MAX_TFL_EVAL_COUNT];
TfLiteRegistration registrations[OP_LAST];

namespace g0 {
const TfArray<4, int> tensor_dimension0 = { 4, { 1,96,96,3 } };
const TfArray<1, float> quant0_scale = { 1, { 0.0039215688593685627, } };
const TfArray<1, int> quant0_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant0 = { (TfLiteFloatArray*)&quant0_scale, (TfLiteIntArray*)&quant0_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data1[4*2] = { 
  0, 0, 
  0, 1, 
  0, 1, 
  0, 0, 
};
const TfArray<2, int> tensor_dimension1 = { 2, { 4,2 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data2[16*3*3*3] = { 
  /* [0][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [1][0][][] */ 48,-1,32, -3,-19,18, -127,-117,-69, 
  /* [1][1][][] */ 3,-3,0, -20,6,-2, 4,-25,9, 
  /* [1][2][][] */ -2,19,-1, -2,11,1, 44,-11,17, 
  /* [2][0][][] */ 34,7,-2, 67,118,2, 45,-28,7, 
  /* [2][1][][] */ 10,23,0, 59,127,-29, 28,3,-7, 
  /* [2][2][][] */ 45,-54,19, 70,-34,-21, 39,-44,13, 
  /* [3][0][][] */ 1,26,-5, 28,88,13, -2,10,0, 
  /* [3][1][][] */ 17,31,-2, 67,127,25, -16,-15,6, 
  /* [3][2][][] */ -1,-3,-5, 26,31,10, -6,-2,5, 
  /* [4][0][][] */ 32,72,-6, 10,87,-5, -28,10,-7, 
  /* [4][1][][] */ 33,81,45, 23,127,36, 14,53,-14, 
  /* [4][2][][] */ 37,76,35, 31,119,20, -38,24,22, 
  /* [5][0][][] */ 9,7,-120, -1,8,-102, -6,31,-28, 
  /* [5][1][][] */ 7,-32,-127, 2,-38,-114, -2,12,-32, 
  /* [5][2][][] */ -3,14,-20, 2,0,-21, -3,9,-22, 
  /* [6][0][][] */ 20,-63,40, 42,-87,45, 6,-21,13, 
  /* [6][1][][] */ 31,-96,67, 58,-127,77, 4,-28,21, 
  /* [6][2][][] */ 16,-33,18, 10,-43,31, -14,8,4, 
  /* [7][0][][] */ -38,10,-2, -107,-46,-4, -23,22,-1, 
  /* [7][1][][] */ -18,-12,-5, -127,-100,-13, -5,-7,4, 
  /* [7][2][][] */ -24,30,-16, -14,9,-8, -24,24,-6, 
  /* [8][0][][] */ 123,127,115, 122,127,114, 121,125,113, 
  /* [8][1][][] */ 123,126,114, 120,124,112, 121,124,112, 
  /* [8][2][][] */ 121,124,114, 120,125,113, 121,124,112, 
  /* [9][0][][] */ -21,-11,4, -9,-10,-1, 7,4,-8, 
  /* [9][1][][] */ 102,110,-19, 78,127,10, -10,19,27, 
  /* [9][2][][] */ -32,-34,6, -2,-38,-8, 10,3,-21, 
  /* [10][0][][] */ -24,-82,-18, 35,95,20, -8,-13,-3, 
  /* [10][1][][] */ -58,-102,-13, 79,127,14, -16,-27,-1, 
  /* [10][2][][] */ -31,-19,2, 37,23,-11, -8,-1,6, 
  /* [11][0][][] */ -2,-2,19, 16,-17,24, 27,-61,-20, 
  /* [11][1][][] */ -32,-18,1, -25,-38,-16, 6,-26,-22, 
  /* [11][2][][] */ 13,-14,-47, 119,127,74, -12,33,-18, 
  /* [12][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [13][0][][] */ -51,-97,-17, -61,-111,-25, -9,-17,-5, 
  /* [13][1][][] */ 61,114,15, 58,127,25, 8,16,11, 
  /* [13][2][][] */ -8,-19,3, 1,-18,-2, 0,4,-4, 
  /* [14][0][][] */ 50,-3,-32, 81,-23,-45, 36,-6,-14, 
  /* [14][1][][] */ 90,-14,-68, 127,-37,-82, 61,-15,-31, 
  /* [14][2][][] */ 56,-8,-41, 75,-19,-47, 28,-5,-13, 
  /* [15][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
};
const TfArray<4, int> tensor_dimension2 = { 4, { 16,3,3,3 } };
const TfArray<16, float> quant2_scale = { 16, { 3.3410194077987398e-07, 0.049722969532012939, 0.035441633313894272, 0.010523922741413116, 0.002804578049108386, 0.041341520845890045, 0.012286859564483166, 0.047407533973455429, 0.00093332130927592516, 0.012560060247778893, 0.02070046029984951, 0.0076571260578930378, 2.9411381774480105e-07, 0.017128633335232735, 0.0072517725639045238, 3.1706054670621597e-08, } };
const TfArray<16, int> quant2_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant2 = { (TfLiteFloatArray*)&quant2_scale, (TfLiteIntArray*)&quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data3[16] = { -1073741824, 9553, -121170, 25363, 305830, 6208, 66705, 5755, -230610, 40052, 36927, 167749, -1073741824, 56852, 73781, -1073741824, };
const TfArray<1, int> tensor_dimension3 = { 1, { 16 } };
const TfArray<16, float> quant3_scale = { 16, { 1.3102037232926023e-09, 0.00019499205518513918, 0.00013898681208956987, 4.1270286601502448e-05, 1.0998345715051983e-05, 0.00016212361515499651, 4.8183766921283677e-05, 0.00018591190746519715, 3.6600838484446285e-06, 4.9255140766035765e-05, 8.1178281106986105e-05, 3.0027946195332333e-05, 1.1533876076441629e-09, 6.7171116825193167e-05, 2.8438325898605399e-05, 1.243374708748135e-10, } };
const TfLiteAffineQuantization quant3 = { (TfLiteFloatArray*)&quant3_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data4[1*3*3*16] = { 
  /* [0][0][][] */ -108,18,-83,-127,39,-67,80,-76,-90,-3,-8,29,-127,5,54,-73, 51,25,-127,127,127,-127,127,-127,-85,127,-127,50,-105,5,127,-25, 24,-24,90,-2,-72,68,-94,77,-95,-27,4,-15,61,1,-101,-29, 
  /* [0][1][][] */ -127,127,-23,13,-44,16,-28,13,-28,0,3,-108,-49,8,-30,-14, -78,-42,-58,-15,-8,-25,8,-28,-108,-89,21,-13,-104,-127,1,23, 14,1,64,2,3,34,-25,32,-127,6,-2,2,-21,12,-4,43, 
  /* [0][2][][] */ -115,-73,68,2,-6,40,-39,51,-76,0,0,4,40,2,-27,23, 23,-4,31,-2,-27,41,-34,19,-125,-13,0,83,-58,0,-28,-111, 21,-7,19,0,4,15,9,21,-115,4,-1,-127,107,3,17,-127, 
};
const TfArray<4, int> tensor_dimension4 = { 4, { 1,3,3,16 } };
const TfArray<16, float> quant4_scale = { 16, { 0.079427838325500488, 0.0047207134775817394, 0.010199355892837048, 0.011691858060657978, 0.0064243674278259277, 0.0061756344512104988, 0.016318412497639656, 0.0080247120931744576, 0.00077725201845169067, 0.011594507843255997, 0.0082067493349313736, 0.030981924384832382, 0.030907778069376945, 0.010691385716199875, 0.0075310575775802135, 0.16606816649436951, } };
const TfLiteAffineQuantization quant4 = { (TfLiteFloatArray*)&quant4_scale, (TfLiteIntArray*)&g0::quant2_zero, 3 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data5[16] = { -161, 23770, 16822, 12664, 12087, 22845, 12859, 20701, -14143, 6725, 30071, 14431, -445, 25986, 11598, -107, };
const TfArray<16, float> quant5_scale = { 16, { 0.0018688903655856848, 0.00011107561294920743, 0.00023998484539333731, 0.00027510256040841341, 0.00015116158465389162, 0.00014530905173160136, 0.00038396264426410198, 0.00018881676078308374, 1.828828317229636e-05, 0.00027281194343231618, 0.00019309998606331646, 0.00072898645885288715, 0.00072724185883998871, 0.00025156201445497572, 0.0001772013638401404, 0.003907486330717802, } };
const TfLiteAffineQuantization quant5 = { (TfLiteFloatArray*)&quant5_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data6[8*1*1*16] = { 
  /* [0][0][][] */ 0,-15,-1,-4,127,-1,-4,-4,1,-125,-88,-5,0,124,-6,0, 
  /* [1][0][][] */ 0,-24,4,92,69,11,25,1,1,-10,127,-47,0,29,-15,0, 
  /* [2][0][][] */ 0,0,-2,-14,-61,1,13,-4,1,2,-19,-2,0,127,-9,0, 
  /* [3][0][][] */ 0,-3,-23,-127,81,20,69,9,1,61,-1,35,0,0,9,0, 
  /* [4][0][][] */ 0,45,-32,33,-59,28,127,7,-1,-66,19,-15,0,-11,2,0, 
  /* [5][0][][] */ 0,-19,-15,-1,-20,-24,-7,11,0,11,-5,-44,0,-4,127,0, 
  /* [6][0][][] */ 0,20,6,8,48,-21,-20,-9,0,-107,115,64,0,127,59,0, 
  /* [7][0][][] */ 0,19,-12,127,10,1,22,14,1,72,-49,76,0,-7,47,0, 
};
const TfArray<4, int> tensor_dimension6 = { 4, { 8,1,1,16 } };
const TfArray<8, float> quant6_scale = { 8, { 0.097886912524700165, 0.094099201261997223, 0.0995650514960289, 0.047118961811065674, 0.049913536757230759, 0.083391323685646057, 0.06199100986123085, 0.04017345979809761, } };
const TfArray<8, int> quant6_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant6 = { (TfLiteFloatArray*)&quant6_scale, (TfLiteIntArray*)&quant6_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data7[8] = { 206, -42938, -5496, -10485, -27168, -1950, -27748, -31962, };
const TfArray<1, int> tensor_dimension7 = { 1, { 8 } };
const TfArray<8, float> quant7_scale = { 8, { 0.002303221495822072, 0.0022140988148748875, 0.0023427072446793318, 0.0011086814338341355, 0.0011744361836463213, 0.001962148817256093, 0.0014586120378226042, 0.00094525789609178901, } };
const TfLiteAffineQuantization quant7 = { (TfLiteFloatArray*)&quant7_scale, (TfLiteIntArray*)&g0::quant6_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data8[48*1*1*8] = { 
  /* [0][0][][] */ 11,-127,41,-37,21,-21,-43,23, 
  /* [1][0][][] */ 62,67,-30,-88,13,-21,-74,127, 
  /* [2][0][][] */ 31,16,-37,127,57,111,36,92, 
  /* [3][0][][] */ 69,62,-80,127,-94,-7,1,19, 
  /* [4][0][][] */ -35,-101,72,13,-3,23,-39,-127, 
  /* [5][0][][] */ 14,6,-33,47,-1,-28,38,127, 
  /* [6][0][][] */ 42,-11,-127,-89,85,16,50,-32, 
  /* [7][0][][] */ 127,19,22,-25,26,-9,82,-64, 
  /* [8][0][][] */ 27,-113,4,111,-7,12,2,-127, 
  /* [9][0][][] */ 99,-127,7,-8,-11,11,-124,86, 
  /* [10][0][][] */ -127,-37,-116,22,-18,16,-94,54, 
  /* [11][0][][] */ -27,-38,-1,-96,-127,-26,52,-14, 
  /* [12][0][][] */ 14,8,-32,69,-83,-26,59,127, 
  /* [13][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [14][0][][] */ -6,-25,-5,17,50,127,43,42, 
  /* [15][0][][] */ 47,0,14,-127,66,49,-61,80, 
  /* [16][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [17][0][][] */ 17,30,127,19,-22,-8,19,29, 
  /* [18][0][][] */ 81,-127,19,35,-13,16,-109,-3, 
  /* [19][0][][] */ -127,-12,33,72,-57,-62,-111,74, 
  /* [20][0][][] */ 26,27,-38,100,-25,-127,0,48, 
  /* [21][0][][] */ 55,13,127,18,-14,-20,81,17, 
  /* [22][0][][] */ -72,-18,-127,4,1,7,-99,8, 
  /* [23][0][][] */ -109,127,-27,-30,12,-14,125,-87, 
  /* [24][0][][] */ 6,-54,-51,81,-10,-68,101,127, 
  /* [25][0][][] */ 11,48,39,40,127,114,-76,-60, 
  /* [26][0][][] */ -85,-33,-127,2,6,19,-96,-3, 
  /* [27][0][][] */ -2,-13,-26,13,-44,127,67,56, 
  /* [28][0][][] */ 1,-18,-26,37,26,127,58,68, 
  /* [29][0][][] */ 79,30,127,-4,-21,-9,78,-13, 
  /* [30][0][][] */ -77,127,-25,-36,9,-10,107,-44, 
  /* [31][0][][] */ -43,-96,-28,9,36,-73,127,120, 
  /* [32][0][][] */ 5,12,-47,111,6,98,71,127, 
  /* [33][0][][] */ 2,59,-14,-108,11,-15,-10,127, 
  /* [34][0][][] */ -20,77,-6,-87,29,-15,26,127, 
  /* [35][0][][] */ 127,14,-7,-42,24,33,90,-49, 
  /* [36][0][][] */ -127,-7,35,77,-21,20,-124,88, 
  /* [37][0][][] */ -6,-33,-15,40,46,127,61,73, 
  /* [38][0][][] */ 12,18,5,75,127,-15,-27,25, 
  /* [39][0][][] */ -6,32,35,-127,30,-2,-37,120, 
  /* [40][0][][] */ 92,26,127,7,-8,-4,82,-2, 
  /* [41][0][][] */ -6,-28,-32,96,61,127,73,105, 
  /* [42][0][][] */ -81,-3,127,23,-36,16,-38,57, 
  /* [43][0][][] */ -6,-55,9,100,-19,3,16,-127, 
  /* [44][0][][] */ 43,-10,-61,-127,43,-34,-1,-104, 
  /* [45][0][][] */ -90,127,-9,-61,19,-5,78,-58, 
  /* [46][0][][] */ -127,-26,38,28,-31,30,-91,39, 
  /* [47][0][][] */ 98,19,117,-2,30,-25,127,-16, 
};
const TfArray<4, int> tensor_dimension8 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant8_scale = { 48, { 0.0012602191418409348, 0.00090849294792860746, 0.00067148281959816813, 0.00061538536101579666, 0.00057519756956025958, 0.00063142081489786506, 0.00076285412069410086, 0.0027483103331178427, 0.00074444321217015386, 0.0052055916748940945, 0.0013221452245488763, 0.0039090830832719803, 0.00034623831743374467, 3.937008052901092e-09, 0.0020011970773339272, 0.00029060165979899466, 3.937008052901092e-09, 0.013088400475680828, 0.00094522727886214852, 0.00067589385434985161, 0.00065380579326301813, 0.0094430334866046906, 0.00072602822910994291, 0.0030320147052407265, 0.00194709119386971, 0.0011518067913129926, 0.004671179223805666, 0.0038702634628862143, 0.00051637814613059163, 0.0035787301603704691, 0.0025557863991707563, 0.00028308204491622746, 0.00043517109588719904, 0.018228117376565933, 0.00092962698545306921, 0.0011776738101616502, 0.0075925718992948532, 0.00053868396207690239, 0.0058202082291245461, 0.00051821325905621052, 0.0026671541854739189, 0.00034357956610620022, 0.00095317920204252005, 0.017285123467445374, 0.00076828262535855174, 0.0010498802876099944, 0.00055613461881875992, 0.0004472177242860198, } };
const TfArray<48, int> quant8_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant8 = { (TfLiteFloatArray*)&quant8_scale, (TfLiteIntArray*)&quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data9[48] = { 3193, 48, 9007, 5750, 6648, 6200, 9602, -59, 50, -274, 2124, 395, 12092, -78610648, 2514, 21798, -63458592, -100, -442, 10830, 3065, -14, -29, 402, 3693, -888, 62, 593, 4281, 1563, 2194, 15752, 3250, 341, 311, -2003, 388, 4678, -113, 12867, 2042, 12358, -227, -85, 12510, 164, 9645, 3694, };
const TfArray<1, int> tensor_dimension9 = { 1, { 48 } };
const TfArray<48, float> quant9_scale = { 48, { 0.00066039763623848557, 0.00047608115710318089, 0.00035187980392947793, 0.000322482839692384, 0.00030142307514324784, 0.00033088595955632627, 0.00039976145490072668, 0.0014402079395949841, 0.00039011353510431945, 0.0027279069181531668, 0.00069284898927435279, 0.0020484921988099813, 0.00018144064233638346, 2.0631258923486939e-09, 0.0010486951796337962, 0.00015228513802867383, 2.0631258923486939e-09, 0.0068587665446102619, 0.00049533118726685643, 0.00035419134655967355, 0.00034261643304489553, 0.0049484702758491039, 0.00038046346162445843, 0.0015888786874711514, 0.0010203418787568808, 0.00060358585324138403, 0.0024478565901517868, 0.0020281495526432991, 0.00027059967396780849, 0.001875376095995307, 0.0013393189292401075, 0.00014834461035206914, 0.0002280444314237684, 0.0095521528273820877, 0.00048715612501837313, 0.00061714107869192958, 0.003978765569627285, 0.00028228870360180736, 0.0030499869026243687, 0.00027156135183759034, 0.0013976793270558119, 0.00018004735466092825, 0.00049949827371165156, 0.0090579921379685402, 0.00040260617970488966, 0.00055017293198034167, 0.00029143341816961765, 0.00023435727052856237, } };
const TfLiteAffineQuantization quant9 = { (TfLiteFloatArray*)&quant9_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data10[1*3*3*48] = { 
  /* [0][0][][] */ -42,-21,-8,-16,7,-39,-79,-66,-26,-50,9,67,34,-71,114,-43,-113,-86,36,-6,-2,-72,-111,-78,-34,-127,-65,-23,71,16,97,26,-127,-86,-9,52,19,47,-127,78,-76,-14,105,-109,-3,-35,-87,108, 76,14,-28,-29,58,-127,-127,-80,60,-78,-114,110,37,-82,0,62,-52,-114,59,6,9,-113,-127,-68,-4,-127,-121,-39,-54,22,-57,54,28,-127,63,81,13,71,-91,127,-127,7,124,-127,2,-23,-127,94, -32,44,6,-4,-65,-107,-59,-17,86,-8,-127,39,8,-71,-100,-11,-127,-26,28,11,-15,-78,-36,-23,-10,-33,-59,-12,-11,18,-24,8,107,-86,70,30,15,34,-6,16,-79,3,7,-78,-17,5,-55,15, 
  /* [0][1][][] */ -86,-127,-44,-44,-11,54,100,-105,-25,-107,-21,112,91,-64,27,-97,-121,-94,88,-76,43,-89,-102,-127,42,-122,-78,-40,127,-60,127,84,-43,-81,-16,85,-35,-77,-107,89,42,58,105,-111,-92,-118,81,120, 127,-83,-127,-127,127,40,94,-127,100,-127,-114,127,127,-14,-6,127,-60,-127,127,-127,127,-127,-118,-118,127,-102,-127,-127,-119,-127,-71,127,29,-111,127,127,-68,-127,-96,90,61,127,127,-115,-113,-127,123,127, -53,32,-61,-85,-121,-22,31,-38,127,-21,-77,35,57,-70,-25,-44,-37,-30,55,-71,58,-83,-38,-25,49,-8,-46,-59,16,-89,-36,19,31,-99,117,23,-35,-63,0,-14,36,53,10,-73,-58,-38,64,35, 
  /* [0][2][][] */ -60,-108,-33,-32,-1,34,-5,-33,-37,-59,-15,58,76,-127,-127,-64,-43,-17,64,76,51,-36,-13,-60,31,-57,-12,-59,74,29,78,62,109,-26,-39,-12,-95,34,-17,30,9,38,17,-57,95,-78,4,31, 88,-73,-87,-83,81,18,6,-46,47,-72,-31,55,81,-26,16,92,-24,-30,76,117,78,-56,-18,-55,91,-71,-20,-98,-52,40,-46,111,-18,-48,66,4,-127,49,-14,-2,11,33,17,-65,127,-100,-12,40, -28,29,-41,-35,-81,-18,22,-12,58,-6,-12,33,30,-43,111,-29,-93,-5,31,59,72,-30,-1,-3,42,-1,-5,-61,-14,29,-20,39,-91,-42,66,2,-19,20,28,-39,7,35,-5,-14,62,-35,-5,18, 
};
const TfArray<4, int> tensor_dimension10 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant10_scale = { 48, { 0.0033489295747131109, 0.0027989745140075684, 0.006555803120136261, 0.0045540505088865757, 0.0055265338160097599, 0.006982448510825634, 0.0051357951015233994, 0.0026237072888761759, 0.0032415681052953005, 0.0013804913032799959, 0.0037059951573610306, 0.0010512359440326691, 0.007833113893866539, 0.23551659286022186, 0.0028960425406694412, 0.010092531330883503, 0.1168077290058136, 0.00089926872169598937, 0.0049236509948968887, 0.0068530780263245106, 0.004659656435251236, 0.0060658711008727551, 0.0055092093534767628, 0.0017621021252125502, 0.0037459947634488344, 0.0041214218363165855, 0.0014877483481541276, 0.0017577519174665213, 0.013137290254235268, 0.0021223428193479776, 0.0020298436284065247, 0.0096064601093530655, 0.008433077484369278, 0.00040297352825291455, 0.0036529679782688618, 0.0098509630188345909, 0.00066587328910827637, 0.017670249566435814, 0.0014363719383254647, 0.0037785123568028212, 0.002552517456933856, 0.009670487605035305, 0.0046101748012006283, 0.00043090761755593121, 0.0069895260967314243, 0.004548252560198307, 0.008234185166656971, 0.0059929313138127327, } };
const TfLiteAffineQuantization quant10 = { (TfLiteFloatArray*)&quant10_scale, (TfLiteIntArray*)&g0::quant8_zero, 3 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data11[48] = { 75618, 60928, 62557, 42185, 355, 13400, 3144, 28087, 29323, 29565, 29487, 11406, -46178, -127, 37765, 1035, -204, 38387, 1310, 1824, -15094, 7296, 45667, 33144, -18668, 28399, 42209, 19912, -2508, 14821, -7955, -50319, 12375, 109279, 27980, 1294, 58214, 379, 139872, -25629, 13745, -28306, 1593, 97863, -706, 56359, 1947, -22296, };
const TfArray<48, float> quant11_scale = { 48, { 7.8798344475217164e-05, 6.5858228481374681e-05, 0.00015425420133396983, 0.00010715413372963667, 0.00013003608910366893, 0.00016429291281383485, 0.00012084223999409005, 6.1734288465231657e-05, 7.6272190199233592e-05, 3.2482148526469246e-05, 8.7199885456357151e-05, 2.473496351740323e-05, 0.00018430856289342046, 0.005541567225009203, 6.8142180680297315e-05, 0.00023747133673168719, 0.0027484172023832798, 2.1159265088499524e-05, 0.0001158506129286252, 0.00016124889953061938, 0.00010963897511828691, 0.00014272637781687081, 0.00012962846085429192, 4.1461225919192657e-05, 8.814105240162462e-05, 9.6974632469937205e-05, 3.5005843528779224e-05, 4.1358867747476324e-05, 0.00030911271460354328, 4.9937480071093887e-05, 4.7761026507942006e-05, 0.00022603436082135886, 0.00019842536130454391, 9.4817305580363609e-06, 8.5952189692761749e-05, 0.00023178737319540232, 1.5667606930946931e-05, 0.00041577059892006218, 3.3796986826928332e-05, 8.8906177552416921e-05, 6.0059235693188384e-05, 0.00022754089150112122, 0.00010847470548469573, 1.0139003279618919e-05, 0.00016445944493170828, 0.00010701770952437073, 0.00019374553812667727, 0.00014101015403866768, } };
const TfLiteAffineQuantization quant11 = { (TfLiteFloatArray*)&quant11_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data12[8*1*1*48] = { 
  /* [0][0][][] */ -14,3,12,-86,9,28,3,9,1,10,-2,-7,94,0,1,1,0,-5,-10,-2,77,-1,2,8,30,38,16,12,3,2,0,-127,9,8,-2,0,-25,0,-19,33,7,-27,-10,8,1,1,3,2, 
  /* [1][0][][] */ -37,-6,-8,-5,43,27,-29,76,19,7,-30,-22,11,0,19,31,0,48,16,-55,-1,27,127,21,-25,-6,56,-3,22,-2,15,-12,16,-7,-10,-19,7,-51,11,5,-9,-4,-79,-8,-33,10,-43,-93, 
  /* [2][0][][] */ -60,12,1,11,46,-6,30,23,-12,55,12,-1,7,0,10,53,0,14,-127,21,3,18,6,-15,-30,3,38,6,9,30,24,7,3,-12,-6,-12,9,4,6,6,37,-9,-32,6,25,-58,27,17, 
  /* [3][0][][] */ 1,-1,4,9,-9,24,-1,-7,64,15,0,0,27,0,-26,-6,0,0,-8,3,-1,1,4,-15,-13,0,-9,-3,-9,-3,-3,-7,-48,43,-60,-1,4,2,7,-127,2,0,2,-52,0,3,3,8, 
  /* [4][0][][] */ 0,-1,81,36,6,-20,-1,-3,1,-3,-7,-2,-80,0,-11,1,0,15,6,0,63,8,-2,-5,-18,34,-8,39,-6,-1,4,97,4,1,-1,-1,21,-7,-4,-16,0,-127,2,6,-1,-3,-1,-2, 
  /* [5][0][][] */ -9,43,1,-8,1,46,23,11,-21,29,8,49,26,0,-127,-2,0,7,-35,21,-10,5,-12,39,-19,-1,27,-4,-10,24,22,-18,50,28,-37,-4,1,13,-46,18,23,-10,-8,27,19,56,24,24, 
  /* [6][0][][] */ -19,-52,8,8,37,-44,-19,11,25,-25,-8,86,-2,0,-127,39,0,-12,47,-20,0,1,26,-37,32,1,1,-7,50,-14,-10,-2,92,-32,25,1,-3,-9,-72,-27,-16,-15,-4,-27,-23,-84,-23,-28, 
  /* [7][0][][] */ -111,-27,-9,8,127,22,65,27,12,12,27,-30,-23,0,87,109,0,16,1,59,-9,-1,-30,50,22,11,51,8,51,57,60,-4,-14,-11,-22,-21,8,25,27,38,73,0,-35,-5,58,4,61,80, 
};
const TfArray<4, int> tensor_dimension12 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant12_scale = { 8, { 0.062442414462566376, 0.027036521583795547, 0.058702860027551651, 0.048940930515527725, 0.043085936456918716, 0.049496125429868698, 0.034657381474971771, 0.036057528108358383, } };
const TfLiteAffineQuantization quant12 = { (TfLiteFloatArray*)&quant12_scale, (TfLiteIntArray*)&g0::quant6_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data13[8] = { -4689, -26136, 23273, 20842, 2110, 2083, 37314, 6881, };
const TfArray<8, float> quant13_scale = { 8, { 0.0014692333061248064, 0.00063615344697609544, 0.0013812438119202852, 0.0011515513760969043, 0.0010137867648154497, 0.0011646146886050701, 0.00081546779256314039, 0.00084841245552524924, } };
const TfLiteAffineQuantization quant13 = { (TfLiteFloatArray*)&quant13_scale, (TfLiteIntArray*)&g0::quant6_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data14[48*1*1*8] = { 
  /* [0][0][][] */ 113,51,-10,-14,127,32,-57,-55, 
  /* [1][0][][] */ -3,-5,0,127,13,-15,-2,28, 
  /* [2][0][][] */ 26,-127,-18,41,-9,-62,78,14, 
  /* [3][0][][] */ 127,-30,1,11,-1,-39,21,8, 
  /* [4][0][][] */ 13,-56,127,-13,-15,-51,6,-90, 
  /* [5][0][][] */ 70,-9,-3,7,127,4,-18,7, 
  /* [6][0][][] */ -11,81,-20,127,12,55,-55,-55, 
  /* [7][0][][] */ -9,127,-4,1,-8,-7,3,-6, 
  /* [8][0][][] */ 127,40,-12,4,-53,-27,0,-23, 
  /* [9][0][][] */ -127,21,15,18,69,6,3,-3, 
  /* [10][0][][] */ -70,-8,13,127,57,34,-25,-6, 
  /* [11][0][][] */ -127,3,20,-63,54,17,-31,-68, 
  /* [12][0][][] */ 127,32,10,5,-35,-5,1,-45, 
  /* [13][0][][] */ -12,80,-127,-11,3,99,-67,71, 
  /* [14][0][][] */ -60,-31,-23,127,33,4,-21,-30, 
  /* [15][0][][] */ -10,127,4,-5,-3,-16,7,-56, 
  /* [16][0][][] */ -15,-113,-20,-1,11,-105,127,-38, 
  /* [17][0][][] */ 9,127,0,-18,0,69,-78,-11, 
  /* [18][0][][] */ -6,35,-127,-1,10,53,-29,61, 
  /* [19][0][][] */ -60,21,8,12,-127,10,15,24, 
  /* [20][0][][] */ -127,-22,-8,-2,114,-46,67,-10, 
  /* [21][0][][] */ -63,-5,-8,3,-127,1,14,-4, 
  /* [22][0][][] */ -121,-42,-14,-1,127,-12,54,49, 
  /* [23][0][][] */ -19,-28,-9,-11,-9,82,-127,-83, 
  /* [24][0][][] */ -8,44,-127,0,13,53,-22,79, 
  /* [25][0][][] */ 111,-29,-8,127,-69,-15,7,-65, 
  /* [26][0][][] */ 8,-17,-3,-1,-7,109,127,-29, 
  /* [27][0][][] */ 66,2,-11,13,127,27,44,-31, 
  /* [28][0][][] */ 5,127,-57,8,13,98,-42,110, 
  /* [29][0][][] */ -13,6,-4,-6,-6,77,-127,-72, 
  /* [30][0][][] */ 4,0,2,-127,-8,-2,-3,-16, 
  /* [31][0][][] */ -63,12,3,8,-127,8,21,-8, 
  /* [32][0][][] */ 2,30,7,-127,-3,18,-82,-77, 
  /* [33][0][][] */ -57,-6,-4,10,-127,45,51,-9, 
  /* [34][0][][] */ -127,66,12,17,64,-20,-4,-3, 
  /* [35][0][][] */ -40,127,-12,-7,42,-92,101,-22, 
  /* [36][0][][] */ -3,28,4,-20,-17,95,-127,-18, 
  /* [37][0][][] */ 32,-82,-14,36,32,-127,97,-16, 
  /* [38][0][][] */ 5,-127,1,1,-4,36,-24,67, 
  /* [39][0][][] */ -2,-127,-16,-8,-4,-15,-45,-92, 
  /* [40][0][][] */ 127,49,1,-26,-65,75,-126,-105, 
  /* [41][0][][] */ 9,-121,30,-7,2,88,-65,127, 
  /* [42][0][][] */ 61,-8,13,-127,-70,-8,26,-40, 
  /* [43][0][][] */ -101,-25,19,-127,82,21,-40,-26, 
  /* [44][0][][] */ 10,-47,-11,25,-33,109,127,-6, 
  /* [45][0][][] */ -127,-54,-10,3,13,13,13,-17, 
  /* [46][0][][] */ 19,71,127,-10,-15,21,1,25, 
  /* [47][0][][] */ 4,4,3,127,4,-4,-4,1, 
};
const TfArray<48, float> quant14_scale = { 48, { 0.00011171495862072334, 0.00076279527274891734, 0.00062329979846253991, 0.0011540880659595132, 0.0036759721115231514, 0.0013747194316238165, 0.0026597424875944853, 0.0027689221315085888, 0.0014715046854689717, 0.0013479463523253798, 0.0016738199628889561, 0.0010649533942341805, 0.0012953929835930467, 0.0015325503190979362, 0.0012995869619771838, 0.0042794249020516872, 0.00082602596376091242, 0.00098837667610496283, 0.005251430906355381, 0.0003056330606341362, 0.00053304416360333562, 0.00092656718334183097, 0.00091230554971843958, 0.0024939433205872774, 0.00092525052605196834, 0.00049861363368108869, 0.00036780801019631326, 0.00092245894484221935, 0.0020832538139075041, 0.0027544819749891758, 0.0013234206708148122, 0.0011004186235368252, 0.0026338882744312286, 0.00062948523554950953, 0.00084661721484735608, 0.00054531078785657883, 0.001349138910882175, 0.00074737274553626776, 0.00028165680123493075, 0.0058402614668011665, 0.0014007347635924816, 0.0024130465462803841, 0.0010332330130040646, 0.00082254747394472361, 0.00058670219732448459, 0.0011375478934496641, 0.0019338687416166067, 0.0025138913188129663, } };
const TfLiteAffineQuantization quant14 = { (TfLiteFloatArray*)&quant14_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data15[48] = { 95276, 7191, 6052, 6774, 1500, 8927, -1758, -235, 999, 2490, 3277, 404, 1802, -732, 850, -2060, 4783, 10430, -233, 21428, 5499, 2646, 10609, -536, 3151, 5823, 26867, 9799, -58, -2314, 123, 1701, -1831, 8411, 2970, 8472, 6586, 4532, 20193, 1887, -997, 2817, 1051, 4531, 4872, 2326, -1469, 2568, };
const TfArray<48, float> quant15_scale = { 48, { 4.5866592699894682e-05, 0.00031317936372943223, 0.00025590698351152241, 0.00047383169294334948, 0.0015092367539182305, 0.00056441588094457984, 0.0010920052882283926, 0.0011368310078978539, 0.0006041527958586812, 0.000553423713427037, 0.00068721699062734842, 0.00043723583803512156, 0.00053184700664132833, 0.00062921619974076748, 0.00053356890566647053, 0.0017569952178746462, 0.00033913986408151686, 0.00040579590131528676, 0.0021560697350651026, 0.00012548317317850888, 0.00021885090973228216, 0.00038041890366002917, 0.00037456350401043892, 0.0010239335242658854, 0.00037987830000929534, 0.00020471483003348112, 0.00015101021563168615, 0.00037873219116590917, 0.00085531745571643114, 0.0011309023248031735, 0.00054335425375029445, 0.00045179674634709954, 0.0010813904227688909, 0.00025844652554951608, 0.00034759397385641932, 0.00022388719662558287, 0.00055391335627064109, 0.00030684738885611296, 0.00011563928273972124, 0.002397824777290225, 0.0005750969285145402, 0.00099071988370269537, 0.00042421248508617282, 0.00033771171001717448, 0.00024088118516374379, 0.00046704083797521889, 0.0007939847419038415, 0.001032123458571732, } };
const TfLiteAffineQuantization quant15 = { (TfLiteFloatArray*)&quant15_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data16[1*3*3*48] = { 
  /* [0][0][][] */ 5,-2,21,110,4,82,-1,28,16,8,9,8,-8,-9,-45,8,-2,8,-23,-114,-7,-22,127,-9,-3,6,-5,10,-5,5,17,100,20,29,39,-27,1,35,-1,3,18,-66,-9,-9,17,3,-6,-10, 127,9,16,-127,28,90,11,11,124,127,8,44,-50,-24,6,7,127,-57,-59,-56,-102,25,-109,14,16,71,-31,-84,23,22,9,-120,5,-60,127,10,-40,-46,-4,118,-79,-97,-30,3,-34,-7,-127,24, -32,-3,8,15,0,66,5,17,29,9,-14,32,-14,-3,16,3,-102,28,-2,79,-33,-13,-18,-7,-4,-59,-3,30,-16,6,4,-20,8,-23,17,-18,-1,48,40,-11,50,37,-16,12,-42,4,0,-6, 
  /* [0][1][][] */ 125,7,1,-98,14,-28,35,-17,9,9,-13,54,-7,-1,16,-33,0,-50,-60,-86,9,-74,-124,-18,5,98,-14,-127,-9,33,13,-105,17,-52,-2,127,-3,59,-40,43,-62,-127,38,-90,-44,-14,-12,-6, 25,-127,-127,115,-127,-127,-127,-127,-127,-95,127,-127,127,127,34,-127,-82,127,127,-106,127,127,112,127,127,-127,-127,29,-127,-127,92,127,-127,127,-29,-41,127,-127,127,127,127,-81,127,127,127,-120,102,107, 53,6,49,-14,6,-63,44,18,-23,15,-106,-7,0,-40,127,3,63,-66,-70,87,13,-46,11,-33,1,6,-38,70,20,40,1,4,32,-43,9,67,-5,65,67,-8,-81,8,-86,-32,28,-16,-10,4, 
  /* [0][2][][] */ -53,-7,26,-17,7,34,-37,22,8,-23,10,33,6,-5,-38,16,4,22,-15,106,6,-31,-15,-12,-3,22,0,52,-10,3,46,-30,-18,-43,-32,-39,-1,31,9,-21,10,-5,41,-39,-36,18,-10,17, 68,125,76,21,17,-20,123,35,19,-2,42,27,-5,-1,-91,23,-58,-56,-37,124,-36,49,12,20,32,-63,-40,31,76,0,127,22,85,-26,7,-35,-25,-17,-11,120,-27,-13,-41,43,21,-31,8,-127, -42,-4,7,-4,5,-6,-61,7,-18,-10,-41,-39,19,-9,-9,10,33,24,-9,-127,23,-10,5,-9,-6,11,-10,-54,-15,8,6,9,-21,87,-36,-22,-4,37,25,-60,5,8,-38,6,-41,127,-4,-4, 
};
const TfArray<48, float> quant16_scale = { 48, { 0.013122133910655975, 0.011282862164080143, 0.0076648746617138386, 0.0087214056402444839, 0.0052671371959149837, 0.0040404000319540501, 0.023326145485043526, 0.0057845893315970898, 0.0047621657140552998, 0.0060528423637151718, 0.0033028956968337297, 0.0073815798386931419, 0.010005469433963299, 0.0073756608180701733, 0.0035730996169149876, 0.0088366847485303879, 0.0076534105464816093, 0.0084770731627941132, 0.0028131238650530577, 0.0065155993215739727, 0.0085847703740000725, 0.007927771657705307, 0.0062719513662159443, 0.0053075738251209259, 0.006804758682847023, 0.0052353674545884132, 0.024104602634906769, 0.0040383310988545418, 0.0083545949310064316, 0.026481853798031807, 0.0044073131866753101, 0.0073070172220468521, 0.025066465139389038, 0.0065405438654124737, 0.0079641863703727722, 0.0064493659883737564, 0.013743044808506966, 0.0056492788717150688, 0.011236995458602905, 0.00082598166773095727, 0.0043306061998009682, 0.0023416443727910519, 0.0052299448288977146, 0.0060063856653869152, 0.0066648274660110474, 0.0043692369945347309, 0.0076437080278992653, 0.0040852399542927742, } };
const TfLiteAffineQuantization quant16 = { (TfLiteFloatArray*)&quant16_scale, (TfLiteIntArray*)&g0::quant8_zero, 3 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data17[48] = { -52850, -249, 8920, -211, 5403, -5587, 2132, 25732, 1933, 33701, -1108, 24567, -7100, -1100, 29970, 7841, 146, 19784, 35217, 11001, 422, -573, 192, 16853, -8094, 29183, 45825, 34886, 3640, 1228, -1712, 518, 1492, 18497, -6930, 16028, -11368, 18813, -22677, 133963, 31200, 21414, 13138, -1178, 14422, 2736, 1551, 296, };
const TfArray<48, float> quant17_scale = { 48, { 0.00030875610536895692, 0.0002654791169334203, 0.00018034999084193259, 0.00020520955149549991, 0.00012393263750709593, 9.5068236987572163e-05, 0.00054885051213204861, 0.00013610799214802682, 0.00011205096234334633, 0.00014241982717067003, 7.7715194493066519e-05, 0.00017368423868902028, 0.0002354228199692443, 0.00017354496230836958, 8.4072933532297611e-05, 0.00020792199939023703, 0.00018008025654125959, 0.00019946055545005947, 6.6191154473926872e-05, 0.00015330822498071939, 0.00020199459686409682, 0.00018653580627869815, 0.00014757532335352153, 0.00012488408538047224, 0.00016011197294574231, 0.00012318512017372996, 0.00056716712424531579, 9.5019553555175662e-05, 0.00019657870871014893, 0.00062310247449204326, 0.00010370148811489344, 0.00017192981613334268, 0.00058979919413104653, 0.00015389514737762511, 0.00018739262304734439, 0.00015174978761933744, 0.00032336576259694993, 0.0001329242077190429, 0.0002643998886924237, 1.9434863133938052e-05, 0.00010189662134507671, 5.5097516451496631e-05, 0.00012305752898100764, 0.0001413267309544608, 0.00015681947115808725, 0.00010280557762598619, 0.00017985195154324174, 9.6123294497374445e-05, } };
const TfLiteAffineQuantization quant17 = { (TfLiteFloatArray*)&quant17_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data18[8*1*1*48] = { 
  /* [0][0][][] */ -42,-16,-39,5,-4,-25,3,-1,-108,127,-45,106,91,7,64,-23,3,-31,13,8,-11,-11,-25,-22,16,-81,13,51,-15,17,8,-41,-1,-75,111,17,7,-7,-5,-21,101,1,41,-30,-21,10,-25,-20, 
  /* [1][0][][] */ 7,40,127,3,-3,-17,0,-73,31,0,20,9,-18,10,-2,-121,8,-58,3,9,-25,44,24,-38,-14,-16,17,-5,6,-11,11,1,-6,15,20,24,-7,-32,66,-61,7,40,-7,16,-11,10,20,3, 
  /* [2][0][][] */ 8,-50,17,-43,32,30,-11,-30,3,0,-7,16,-12,57,8,-3,-36,127,-24,-28,-15,24,-40,-8,119,2,2,-11,-29,-9,5,-38,-10,-2,6,14,-6,-1,-13,6,10,-20,-18,2,3,24,-25,-42, 
  /* [3][0][][] */ -1,-91,-7,5,3,-7,-12,-1,-11,-6,24,23,15,-10,46,-5,-13,-26,4,21,-16,20,-23,6,4,51,0,10,-11,-2,127,-1,15,5,-5,-1,-24,-21,-9,5,-8,7,-9,30,-7,4,-1,32, 
  /* [4][0][][] */ -100,1,-9,-8,1,-41,4,12,41,-46,22,-21,-42,1,-15,-15,3,3,1,31,15,-29,14,7,-5,53,10,111,0,-4,-7,-35,-6,-127,-26,7,8,-3,8,-5,-47,-3,-17,18,-50,-7,4,-2, 
  /* [5][0][][] */ -18,28,16,2,-44,9,-3,45,14,-4,6,7,-15,-43,-1,30,-1,-80,20,11,37,-43,6,44,10,8,-62,-38,-33,-27,22,-11,-3,-59,2,-54,63,10,-38,15,23,-38,0,6,127,-5,-40,-5, 
  /* [6][0][][] */ -23,-32,-19,-5,37,-32,3,-14,-5,-6,35,-23,-14,41,-5,-58,4,3,-2,-22,-41,48,-8,-80,1,-5,-48,-70,26,37,-23,-1,5,-63,-9,56,-63,-47,12,-57,-13,14,6,37,127,-33,34,14, 
  /* [7][0][][] */ 15,29,-80,23,-25,13,4,60,-7,-1,66,-37,10,-30,-7,-7,-26,-127,38,-43,58,32,17,-53,18,-19,24,14,-25,32,-15,1,-2,30,-10,-33,-9,-57,-45,-69,-17,-30,39,66,-30,-24,-8,0, 
};
const TfArray<8, float> quant18_scale = { 8, { 0.020542211830615997, 0.034469682723283768, 0.062596604228019714, 0.065542541444301605, 0.029217738658189774, 0.025728804990649223, 0.03190695121884346, 0.038859408348798752, } };
const TfLiteAffineQuantization quant18 = { (TfLiteFloatArray*)&quant18_scale, (TfLiteIntArray*)&g0::quant6_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data19[8] = { -37075, 24325, -13555, -10320, 22133, -4156, 34549, 45691, };
const TfArray<8, float> quant19_scale = { 8, { 0.00048334617167711258, 0.00081105140270665288, 0.001472861273214221, 0.0015421775169670582, 0.00068747618934139609, 0.00060538365505635738, 0.00075075181666761637, 0.00091433903435245156, } };
const TfLiteAffineQuantization quant19 = { (TfLiteFloatArray*)&quant19_scale, (TfLiteIntArray*)&g0::quant6_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data20[48*1*1*8] = { 
  /* [0][0][][] */ -127,2,-4,70,-38,42,22,-23, 
  /* [1][0][][] */ 38,79,72,2,-6,-29,110,127, 
  /* [2][0][][] */ -25,-1,3,-12,-127,-12,9,-11, 
  /* [3][0][][] */ 94,-6,-20,-127,-114,16,29,-20, 
  /* [4][0][][] */ -127,49,-9,-9,90,-14,40,22, 
  /* [5][0][][] */ -104,-29,22,-13,-127,12,5,84, 
  /* [6][0][][] */ -23,-127,32,-23,17,-1,-13,34, 
  /* [7][0][][] */ -61,-6,18,99,127,-28,-31,14, 
  /* [8][0][][] */ 58,1,5,-127,9,-9,-44,-33, 
  /* [9][0][][] */ -12,-127,-3,10,4,80,-56,86, 
  /* [10][0][][] */ -99,-3,-1,35,-127,82,51,-12, 
  /* [11][0][][] */ 112,16,39,5,-56,-43,-35,-127, 
  /* [12][0][][] */ -4,14,43,-15,9,-71,127,60, 
  /* [13][0][][] */ 64,-21,-7,-5,108,127,103,-38, 
  /* [14][0][][] */ 118,54,3,10,-127,-20,-38,-17, 
  /* [15][0][][] */ -15,-127,14,-10,4,6,-11,24, 
  /* [16][0][][] */ -49,-18,-2,-4,-127,-3,15,3, 
  /* [17][0][][] */ -29,89,-119,-3,4,-127,85,-88, 
  /* [18][0][][] */ 127,-26,-48,12,-55,30,11,96, 
  /* [19][0][][] */ 127,-42,-6,-13,50,9,37,-5, 
  /* [20][0][][] */ 116,29,-5,127,1,36,2,-67, 
  /* [21][0][][] */ 11,49,-48,8,-27,86,-127,-101, 
  /* [22][0][][] */ -127,6,28,-4,-39,4,-56,-20, 
  /* [23][0][][] */ -39,-57,-6,28,-127,59,78,-17, 
  /* [24][0][][] */ 127,6,-1,-4,-106,-12,-3,15, 
  /* [25][0][][] */ 20,-14,-2,-22,127,46,49,-30, 
  /* [26][0][][] */ 3,-91,-3,-33,12,-127,87,-42, 
  /* [27][0][][] */ -18,-127,23,-13,-1,-54,29,-9, 
  /* [28][0][][] */ -115,49,-38,6,-26,-44,127,95, 
  /* [29][0][][] */ -10,48,16,4,-9,47,-113,-127, 
  /* [30][0][][] */ 127,-22,-4,6,-88,-8,-19,-25, 
  /* [31][0][][] */ -18,-42,89,-15,16,-127,120,96, 
  /* [32][0][][] */ -64,33,3,3,-127,-91,-90,44, 
  /* [33][0][][] */ -28,12,6,29,-127,-65,-50,25, 
  /* [34][0][][] */ 6,-127,56,-9,1,94,-79,55, 
  /* [35][0][][] */ -24,-51,-127,-11,-3,-73,50,-52, 
  /* [36][0][][] */ 4,127,51,10,-18,5,-20,-38, 
  /* [37][0][][] */ -127,30,23,-15,52,-39,2,-95, 
  /* [38][0][][] */ -127,-16,-43,-15,40,24,26,111, 
  /* [39][0][][] */ 3,-27,94,8,17,-90,127,95, 
  /* [40][0][][] */ -25,-21,-5,-47,-127,100,107,-31, 
  /* [41][0][][] */ -127,53,3,-51,-99,-96,-101,56, 
  /* [42][0][][] */ -47,-127,-102,4,-14,64,-106,-80, 
  /* [43][0][][] */ -74,2,-10,-127,101,54,71,1, 
  /* [44][0][][] */ 127,-5,23,-104,26,-26,-20,40, 
  /* [45][0][][] */ -10,-127,-4,-3,-13,-74,87,5, 
  /* [46][0][][] */ 103,-6,0,-23,127,-24,-36,5, 
  /* [47][0][][] */ 127,-2,-3,112,2,23,0,-30, 
};
const TfArray<48, float> quant20_scale = { 48, { 0.00076275307219475508, 0.0015326482243835926, 0.0004998835502192378, 0.00051557936239987612, 0.00037131842691451311, 0.00055348151363432407, 0.00079742609523236752, 0.00039458106039091945, 0.00072094856295734644, 0.001399150351062417, 0.0019465327495709062, 0.00050370325334370136, 0.00074803823372349143, 0.0014229682274162769, 0.00023059117665980011, 0.00080086220987141132, 0.00049210572615265846, 0.00070807599695399404, 0.00044933933531865478, 0.00057086377637460828, 0.00063599442364647985, 0.00041822364437393844, 0.00073758978396654129, 0.00031089480035007, 0.00049421750009059906, 0.00053910166025161743, 0.0032204922754317522, 0.00077232380863279104, 0.00035484877298586071, 0.00077014882117509842, 0.00047810428077355027, 0.0003502876206766814, 0.0014850768493488431, 0.00045642175246030092, 0.001385337789542973, 0.00086243642726913095, 0.0013400648022070527, 0.00070621137274429202, 0.0004153937625233084, 0.00062986928969621658, 0.00032902666134759784, 0.00049711775500327349, 0.00062309997156262398, 0.00042201406904496253, 0.0035259420983493328, 0.00073253893060609698, 0.00068866007495671511, 0.0021858722902834415, } };
const TfLiteAffineQuantization quant20 = { (TfLiteFloatArray*)&quant20_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data21[48] = { 607, 875, 2080, 612, 11246, 13887, 2627, -207, -767, -570, 972, 1155, 3171, 965, 29404, 2899, 2107, -1000, -358, 3084, -1712, 11450, 9518, 9537, 6012, 372, 4070, 4600, 9184, -552, 10381, 6402, 444, -140, 5048, 3904, -1996, 202, -708, 5495, 798, -497, -770, -70, 1062, 3556, 640, 1038, };
const TfArray<48, float> quant21_scale = { 48, { 0.00040306570008397102, 0.00080990552669391036, 0.00026415614411234856, 0.00027245035744272172, 0.00019621777755673975, 0.00029247920610941947, 0.00042138813296332955, 0.00020851058070547879, 0.00038097469951026142, 0.00073936051921918988, 0.0010286166798323393, 0.00026617461116984487, 0.00039528985507786274, 0.00075194670353084803, 0.00012185252853669226, 0.00042320389184169471, 0.00026004607207141817, 0.00037417237763293087, 0.00023744678765069693, 0.00030166460783220828, 0.00033608192461542785, 0.0002210041566286236, 0.00038976850919425488, 0.00016428780509158969, 0.00026116200024262071, 0.00028488037060014904, 0.0017018219223245978, 0.00040812318911775947, 0.00018751464085653424, 0.0004069738497491926, 0.00025264720898121595, 0.00018510436348151416, 0.00078476709313690662, 0.0002411893947282806, 0.00073206145316362381, 0.00045574188698083162, 0.0007081376388669014, 0.00037318706745281816, 0.00021950874361209571, 0.00033284520031884313, 0.00017386932449880987, 0.0002626946079544723, 0.00032926804851740599, 0.00022300715500023216, 0.0018632324645295739, 0.00038709945511072874, 0.00036391231697052717, 0.0011550921481102705, } };
const TfLiteAffineQuantization quant21 = { (TfLiteFloatArray*)&quant21_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data22[1*3*3*48] = { 
  /* [0][0][][] */ 67,-95,98,70,54,-35,106,-65,61,-88,-82,47,53,-43,-71,-89,102,79,49,77,68,-73,-85,50,-33,-41,-62,-63,-66,62,-63,-113,-14,43,69,64,-66,52,-49,-24,51,-73,57,62,-93,12,76,-36, 80,-98,127,85,-77,-68,-55,-85,98,-99,-65,73,81,-106,-95,93,-38,96,82,127,87,-113,54,71,-52,-77,-66,-80,57,80,-31,-127,-88,80,81,83,-84,81,-82,-18,76,-94,82,88,-74,-127,94,-99, 34,-47,71,39,18,-41,-47,-40,43,-32,3,35,32,-78,-55,-1,-58,39,34,70,33,-54,31,25,-28,-47,-41,-24,32,30,89,-91,-86,46,36,34,-30,38,-37,-12,40,-41,34,42,-5,-10,35,-72, 
  /* [0][1][][] */ 93,-112,-39,95,57,-83,127,-89,90,-111,-74,83,83,-109,-13,-127,127,109,74,-38,84,107,-127,72,74,-75,-93,-100,-127,88,-71,-9,-86,71,106,96,-86,79,-81,88,83,-101,87,89,-90,107,94,-92, 127,-127,-65,127,-127,-127,-90,-127,127,-127,-127,127,127,-127,-21,98,-65,127,127,-50,127,127,70,127,127,-127,-127,-127,53,127,-28,17,-127,127,127,127,-127,127,-127,127,127,-127,127,127,-127,-11,127,-127, 62,-76,-33,69,38,-62,-48,-64,57,-42,-62,58,49,-53,-16,11,-65,53,58,-30,57,64,51,65,67,-64,-61,-46,37,55,127,14,-61,69,50,49,-50,59,-59,56,59,-58,53,60,-62,-68,58,-55, 
  /* [0][2][][] */ 45,-53,-46,52,28,-53,62,-42,43,-71,-5,41,56,-73,82,-80,73,52,33,-31,27,-12,-77,29,-23,-44,-52,-49,-73,32,-42,90,-74,37,49,43,-25,38,-42,-85,47,-51,43,46,-25,16,40,-74, 72,-73,-47,83,-56,-63,-72,-68,52,-77,-66,61,74,-47,127,33,-47,61,61,-43,57,-18,41,65,-46,-65,-82,-60,32,60,-24,116,-55,64,58,58,-48,61,-66,-105,67,-68,65,62,-87,50,62,-54, 42,-42,-27,48,30,-20,-17,-34,17,-27,-54,27,32,2,67,24,-38,25,27,-34,29,0,40,42,-24,-27,-52,-24,34,35,62,65,1,33,16,22,-24,31,-29,-55,29,-33,28,28,-62,8,31,-6, 
};
const TfArray<48, float> quant22_scale = { 48, { 0.0030831324402242899, 0.0016447097295895219, 0.0073944679461419582, 0.0024440560955554247, 0.005234133917838335, 0.0026003895327448845, 0.0057337810285389423, 0.0057864985428750515, 0.0033849121537059546, 0.0017787819961085916, 0.0019551534205675125, 0.0044310498051345348, 0.0020258987788110971, 0.0017097044037654996, 0.0066752685233950615, 0.0073637166060507298, 0.0067531624808907509, 0.0028549209237098694, 0.0056346100755035877, 0.006793665699660778, 0.0038975821807980537, 0.0072811571881175041, 0.0041140499524772167, 0.0052800094708800316, 0.0034972256980836391, 0.0046030553057789803, 0.00092346052406355739, 0.0027806805446743965, 0.0047532143071293831, 0.0038997686933726072, 0.0046787927858531475, 0.006609767209738493, 0.0020063319243490696, 0.0057020229287445545, 0.0010745386825874448, 0.002148584695532918, 0.0046432483941316605, 0.0038628655020147562, 0.0056832232512533665, 0.0037129335105419159, 0.0046839779242873192, 0.0038918778300285339, 0.0029643378220498562, 0.0040495749562978745, 0.0014076789375394583, 0.0062279202975332737, 0.004317321814596653, 0.0014819003408774734, } };
const TfLiteAffineQuantization quant22 = { (TfLiteFloatArray*)&quant22_scale, (TfLiteIntArray*)&g0::quant8_zero, 3 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data23[48] = { 3371, 41009, -1264, 37472, 4192, 128923, -3232, 43058, 2414, 33243, 25464, -424, -3252, 29947, -850, -1852, -704, -276, 1232, -1831, -173, -3389, -832, -19221, -5584, 41668, 123899, 105620, 2775, 4635, -2468, 1300, 24668, 196, 53850, 4223, 53667, 1648, 44696, 2245, 1063, 64052, -821, 2663, 52009, -830, 1659, 51599, };
const TfArray<48, float> quant23_scale = { 48, { 7.25442951079458e-05, 3.8699054130120203e-05, 0.00017398748605046421, 5.7507204473949969e-05, 0.00012315608910284936, 6.1185637605376542e-05, 0.00013491249410435557, 0.00013615291391033679, 7.964499673107639e-05, 4.1853694710880518e-05, 4.6003609895706177e-05, 0.00010425999789731577, 4.7668207116657868e-05, 4.0228340367320925e-05, 0.00015706515114288777, 0.00017326392116956413, 0.00015889795031398535, 6.7174609284847975e-05, 0.00013257906539365649, 0.00015985095524229109, 9.170782141154632e-05, 0.00017132134234998375, 9.6801173640415072e-05, 0.00012423552107065916, 8.2287668192293495e-05, 0.00010830718383658677, 2.1728483261540532e-05, 6.5427775552961975e-05, 0.00011184033792233095, 9.1759262431878597e-05, 0.00011008924775524065, 0.00015552394324913621, 4.720780998468399e-05, 0.00013416525325737894, 2.5283263312303461e-05, 5.0554936024127528e-05, 0.00010925290553132072, 9.0890956926159561e-05, 0.00013372290413826704, 8.7363143393304199e-05, 0.00011021125101251528, 9.1573594545479864e-05, 6.9749126851093024e-05, 9.52841219259426e-05, 3.3121857995865867e-05, 0.00014653929974883795, 0.00010158404620597139, 3.4868244256358594e-05, } };
const TfLiteAffineQuantization quant23 = { (TfLiteFloatArray*)&quant23_scale, (TfLiteIntArray*)&g0::quant8_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data24[16*1*1*48] = { 
  /* [0][0][][] */ -10,-3,-27,2,21,-3,1,99,-63,18,38,-9,20,-14,-15,21,16,-4,-12,-4,64,1,19,127,-20,83,-9,-15,23,-20,22,-36,-18,48,17,-38,18,46,13,-12,-104,-30,18,42,37,14,-119,-59, 
  /* [1][0][][] */ -30,-2,17,9,-31,10,-2,58,-57,-32,6,-42,-27,-12,2,-2,-32,114,-15,19,4,10,-23,-10,28,-36,11,22,-29,-78,-43,23,-16,-5,34,1,-1,-38,10,18,-17,-29,127,5,14,-8,15,-13, 
  /* [2][0][][] */ -22,-10,-11,-39,-6,-64,1,-18,0,14,12,20,17,7,-12,1,-6,-21,-28,-18,-9,-2,1,-127,-16,71,-11,6,-1,-17,1,-4,-5,47,10,-6,19,12,26,-2,-41,7,-20,-7,-4,-7,14,11, 
  /* [3][0][][] */ -6,33,2,-30,0,0,7,-3,-17,-2,-5,40,-127,8,-12,-1,1,8,-18,0,-27,1,8,17,-12,-9,0,25,-5,20,5,23,1,0,15,23,-9,26,40,8,11,5,24,-30,8,0,3,15, 
  /* [4][0][][] */ 28,-32,8,10,20,29,21,-17,-26,4,-12,-14,-1,16,-3,14,19,-13,-78,10,-6,6,15,68,-3,-26,2,47,6,-70,24,6,13,-33,31,-127,9,35,5,12,-21,23,4,-26,-14,-16,11,8, 
  /* [5][0][][] */ 31,-1,-24,61,0,-7,9,27,6,-2,48,9,5,55,1,-2,-24,24,30,6,11,6,1,-24,-1,-49,-5,-21,0,-13,6,6,72,-127,0,35,-15,-12,15,3,-88,51,17,-5,-6,-4,-97,-8, 
  /* [6][0][][] */ 23,0,4,4,-13,-3,2,-12,-1,7,1,5,-19,7,3,3,-1,-11,127,10,5,8,13,-37,5,0,27,-11,-11,-1,-7,13,3,-12,29,-39,-1,-42,73,18,-1,-5,-4,6,-9,0,9,-8, 
  /* [7][0][][] */ -49,-18,-23,33,-13,84,-7,50,2,32,0,127,83,-1,-5,-9,-4,-17,-10,-24,-40,-2,-22,67,1,-45,-50,-29,-6,-11,-15,-12,9,-5,-27,4,3,-56,102,4,22,35,-67,-59,18,-9,14,7, 
  /* [8][0][][] */ -43,-53,1,11,0,-2,1,30,0,-77,10,44,52,9,15,11,-17,67,-24,3,-52,30,-9,-4,10,-2,-4,44,-4,115,-12,26,1,15,-19,-126,-127,71,30,30,35,-14,114,-19,14,23,23,31, 
  /* [9][0][][] */ -28,10,6,19,17,-35,-6,-4,51,-37,-2,55,-63,-3,10,-8,-10,12,-42,-26,54,-2,-6,-21,-9,16,50,-25,5,15,6,-1,-9,16,80,-108,-4,-127,-89,10,-42,30,57,5,0,12,-24,-41, 
  /* [10][0][][] */ -18,-11,-31,-127,39,87,7,-10,-9,33,32,4,48,-45,-25,23,30,-34,48,-26,27,-22,36,44,-43,-106,7,-27,50,27,41,-35,-19,-77,19,-10,9,-38,6,-29,-39,-62,-15,12,18,7,16,-33, 
  /* [11][0][][] */ 2,63,-22,70,39,-69,-79,-26,8,69,-6,-2,-15,73,0,-86,24,53,3,-6,-68,-101,-2,0,18,-50,12,-18,57,-53,28,-95,65,-27,-41,-91,102,24,2,-127,-1,72,103,-71,-8,-68,43,34, 
  /* [12][0][][] */ 126,-5,-23,16,0,19,5,98,15,-9,-66,-26,-3,15,-8,-2,-2,4,-3,-3,2,-1,-4,20,-2,15,-2,10,-7,11,0,-8,0,-66,-10,5,-18,-19,-29,-6,-10,-78,3,-127,-58,1,79,-15, 
  /* [13][0][][] */ 10,0,2,6,7,-12,4,2,-1,10,2,21,-2,3,2,1,7,2,10,3,13,-11,10,-1,4,0,19,127,9,-10,5,0,2,4,-40,20,10,-7,7,-17,-10,-7,-1,5,0,-3,-10,-13, 
  /* [14][0][][] */ 63,-22,41,-62,55,24,42,-96,-51,-57,-13,127,-70,-9,71,18,52,18,-50,63,23,15,69,-12,20,64,-29,-117,28,-35,55,39,-12,74,-121,-54,-36,38,87,2,-33,10,52,-5,-5,-1,7,-29, 
  /* [15][0][][] */ -4,-58,-64,-37,55,29,82,-59,-8,20,-16,-47,97,8,-104,66,61,58,80,-85,-109,-14,55,-19,-97,36,25,52,58,42,53,-45,29,56,96,127,-20,-110,-13,-39,100,67,121,-50,-1,-34,-3,84, 
};
const TfArray<4, int> tensor_dimension24 = { 4, { 16,1,1,48 } };
const TfArray<16, float> quant24_scale = { 16, { 0.030068244785070419, 0.039750128984451294, 0.041415438055992126, 0.046173863112926483, 0.037094760686159134, 0.04796949028968811, 0.037050116807222366, 0.025238124653697014, 0.026636561378836632, 0.024362027645111084, 0.035130694508552551, 0.024270161986351013, 0.039578888565301895, 0.054145567119121552, 0.025576585903763771, 0.024983076378703117, } };
const TfLiteAffineQuantization quant24 = { (TfLiteFloatArray*)&quant24_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data25[16] = { -33638, -590, 3372, -9379, -1363, -7351, -11585, -43788, 6548, 25042, 35086, -9531, -155, -21218, 36536, -42190, };
const TfArray<16, float> quant25_scale = { 16, { 0.00070748809957876801, 0.00093529716832563281, 0.00097448093583807349, 0.0010864438954740763, 0.0008728179382160306, 0.0011286939261481166, 0.00087176746455952525, 0.00059383822372183204, 0.00062674260698258877, 0.00057322421343997121, 0.0008266046061180532, 0.0005710626719519496, 0.00093126797582954168, 0.0012740134261548519, 0.00060180202126502991, 0.00058783713029697537, } };
const TfLiteAffineQuantization quant25 = { (TfLiteFloatArray*)&quant25_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data26[96*1*1*16] = { 
  /* [0][0][][] */ 18,-41,94,127,86,-12,36,-42,95,-3,-56,-69,37,59,-6,-87, 
  /* [1][0][][] */ 22,47,13,16,77,2,10,29,53,56,-16,127,-9,-14,65,-64, 
  /* [2][0][][] */ 6,-36,-11,-29,-86,51,-38,103,-65,-127,21,71,-29,-81,72,-90, 
  /* [3][0][][] */ 127,120,-1,20,-115,-20,-59,-15,-17,-11,106,-72,-44,88,-30,-28, 
  /* [4][0][][] */ -17,-12,33,20,-21,55,-14,58,-65,-28,-13,12,24,-127,29,28, 
  /* [5][0][][] */ 89,-71,-31,8,-10,-95,-28,3,-31,2,-127,-8,36,-13,2,36, 
  /* [6][0][][] */ -126,-51,-9,127,-45,-4,-53,21,-127,-90,-100,-31,19,50,1,85, 
  /* [7][0][][] */ -12,8,-51,49,34,-127,-26,35,11,-30,19,-12,-15,23,-44,1, 
  /* [8][0][][] */ 32,-45,-15,-2,8,15,-72,-79,-19,17,-86,5,-127,3,1,15, 
  /* [9][0][][] */ 25,-40,49,125,-8,49,-26,-78,127,-109,16,-6,-13,75,-109,27, 
  /* [10][0][][] */ -61,-64,-18,-49,127,74,12,58,95,-82,-44,17,106,-107,-75,88, 
  /* [11][0][][] */ 48,-12,-127,17,38,4,-29,16,-35,-31,-9,-17,1,24,-33,7, 
  /* [12][0][][] */ 97,-29,0,-7,-9,-48,-55,-42,39,-16,-127,-32,-40,-31,1,58, 
  /* [13][0][][] */ 13,-45,21,-73,56,4,-88,-127,-8,-51,38,-4,5,-62,5,5, 
  /* [14][0][][] */ -66,30,-112,-34,67,-127,47,-62,46,36,-20,-117,30,107,18,15, 
  /* [15][0][][] */ 50,-28,72,44,45,-70,-46,-8,19,-71,-70,2,-127,-62,-14,53, 
  /* [16][0][][] */ -80,94,6,-1,-4,69,34,59,-50,37,127,-8,-34,5,-9,-61, 
  /* [17][0][][] */ 0,-18,-45,-54,-35,15,35,101,-25,127,-19,18,-4,95,69,14, 
  /* [18][0][][] */ -5,127,-54,0,21,18,47,-78,25,114,-70,94,2,-49,32,-103, 
  /* [19][0][][] */ 2,-19,34,2,13,50,-19,15,20,-4,-37,-14,-127,3,-10,37, 
  /* [20][0][][] */ 97,-53,4,-127,-28,13,36,-117,-84,47,-126,-67,12,-21,38,4, 
  /* [21][0][][] */ 81,44,127,50,-56,37,36,-5,-20,61,-45,-29,-10,58,5,-2, 
  /* [22][0][][] */ 24,22,8,14,-14,1,37,127,7,2,-3,35,7,14,37,9, 
  /* [23][0][][] */ -22,39,-97,27,-4,-127,27,48,12,-10,-18,6,-75,9,-7,43, 
  /* [24][0][][] */ 40,-47,-10,-68,48,-5,-32,-14,25,16,44,86,-42,96,127,41, 
  /* [25][0][][] */ -127,-107,-34,10,15,13,6,-33,-39,-7,-78,13,9,45,14,50, 
  /* [26][0][][] */ 18,-13,28,1,-18,-14,-38,51,-69,-46,-25,7,22,-127,45,3, 
  /* [27][0][][] */ -99,55,-28,25,38,-17,13,27,31,-34,127,19,-32,20,-12,-39, 
  /* [28][0][][] */ -35,-2,16,41,-9,12,15,80,24,27,-23,-10,-127,-20,-14,34, 
  /* [29][0][][] */ -16,66,37,-25,40,-3,19,-23,-127,27,-27,3,4,31,-89,5, 
  /* [30][0][][] */ -12,10,-127,-22,20,-49,15,19,-15,4,-20,-26,-45,-37,15,10, 
  /* [31][0][][] */ 127,-20,-101,36,43,-19,-53,41,-16,4,-104,-37,34,-14,-48,26, 
  /* [32][0][][] */ -103,29,28,35,23,71,24,36,51,-14,127,-16,-57,36,-5,-28, 
  /* [33][0][][] */ 7,-9,127,-26,-56,24,17,-42,18,17,-18,22,-2,17,26,8, 
  /* [34][0][][] */ 5,-56,-36,-127,42,-4,-31,-12,19,-101,-56,-89,-10,27,61,55, 
  /* [35][0][][] */ -4,-37,47,37,53,-17,12,-7,-105,26,-1,28,-8,127,-43,-32, 
  /* [36][0][][] */ -98,22,-24,0,-13,39,38,100,15,24,127,3,19,27,-14,-21, 
  /* [37][0][][] */ -41,23,127,-12,-67,-41,44,-48,18,23,-8,10,-10,-56,77,-5, 
  /* [38][0][][] */ 7,-10,-13,25,32,-47,-74,29,-29,-34,72,4,127,34,-11,12, 
  /* [39][0][][] */ -45,-33,31,-88,-95,-127,51,107,-47,2,-8,-98,-12,53,108,103, 
  /* [40][0][][] */ 97,-25,-21,-22,6,64,-21,-12,-11,-22,26,-5,127,9,-31,-30, 
  /* [41][0][][] */ 11,-22,-33,-127,22,-2,-45,-59,6,-49,23,-32,-8,1,-18,41, 
  /* [42][0][][] */ 61,68,15,121,-112,5,-127,-13,-99,-73,49,-69,-48,105,-45,20, 
  /* [43][0][][] */ 24,108,-38,127,17,34,52,-56,-50,82,11,31,32,-36,44,24, 
  /* [44][0][][] */ 6,-17,-127,28,49,99,-32,78,-32,-13,47,-37,10,-51,-64,-9, 
  /* [45][0][][] */ 17,23,-37,-127,-30,17,60,14,-1,26,-32,23,42,-97,52,-43, 
  /* [46][0][][] */ -1,34,52,-7,21,33,-38,51,27,-36,-21,8,11,127,52,-21, 
  /* [47][0][][] */ 0,-28,25,-56,-42,33,-73,58,-8,-37,27,36,1,-127,45,12, 
  /* [48][0][][] */ 6,8,7,-127,0,-22,6,7,7,-13,8,-21,14,24,-15,53, 
  /* [49][0][][] */ 42,-45,2,127,89,26,9,70,-62,23,37,53,0,48,125,7, 
  /* [50][0][][] */ -26,40,28,-15,12,112,-13,-95,67,24,127,23,123,-33,5,-89, 
  /* [51][0][][] */ 25,43,17,10,23,22,-52,21,39,-5,4,127,13,27,30,-52, 
  /* [52][0][][] */ -6,45,120,-2,5,-54,1,-50,-25,-4,-1,21,10,92,-127,-2, 
  /* [53][0][][] */ -12,-28,-37,-127,-49,2,11,-37,-40,34,19,8,27,-14,38,4, 
  /* [54][0][][] */ 4,40,-39,-117,13,8,-24,12,36,-41,7,-14,-35,127,-17,65, 
  /* [55][0][][] */ -8,-20,-42,6,21,-57,-17,-127,32,-97,-22,-3,-18,-47,-43,-31, 
  /* [56][0][][] */ 35,43,31,49,11,-15,14,127,31,-35,3,-32,72,-13,-52,50, 
  /* [57][0][][] */ 72,1,127,-30,-86,-48,-22,-36,-2,-24,-70,-2,22,-21,22,1, 
  /* [58][0][][] */ 104,123,-1,99,-127,-55,-8,11,-47,38,95,-48,-93,-86,-16,-73, 
  /* [59][0][][] */ 127,-15,-5,21,-14,-1,-9,4,-15,19,-81,-4,-9,-9,9,0, 
  /* [60][0][][] */ -127,61,-31,17,4,51,40,31,-15,29,84,7,-54,-12,16,-46, 
  /* [61][0][][] */ -100,74,14,57,25,-59,-86,-103,127,-93,57,-8,54,-82,-71,-69, 
  /* [62][0][][] */ -30,-27,-127,45,66,98,-31,74,10,-86,47,1,-99,-21,-99,3, 
  /* [63][0][][] */ -40,11,127,-33,-52,-47,27,-23,17,25,2,22,-20,-51,69,20, 
  /* [64][0][][] */ -10,68,11,73,50,6,90,-127,23,126,-31,-4,-39,-90,23,1, 
  /* [65][0][][] */ 6,13,-4,-17,77,11,10,-127,-34,-52,-32,-33,-1,-44,52,25, 
  /* [66][0][][] */ -127,-12,-13,4,-28,21,25,-31,-74,-31,-73,53,53,21,42,77, 
  /* [67][0][][] */ 2,-55,20,127,18,8,-30,48,46,26,15,-7,-16,-23,-98,-23, 
  /* [68][0][][] */ 11,-18,-1,127,-40,-17,18,-20,-45,37,-10,-14,14,-52,-12,-10, 
  /* [69][0][][] */ 88,84,11,98,34,9,25,-127,22,95,40,45,-8,-41,26,-2, 
  /* [70][0][][] */ -6,-20,-22,-95,99,-7,46,26,95,-23,73,-39,8,93,58,127, 
  /* [71][0][][] */ -6,71,-5,92,57,-127,-50,105,49,-112,28,7,20,-58,-63,30, 
  /* [72][0][][] */ -127,-103,8,39,42,44,-78,41,-61,-65,-94,14,61,47,-6,114, 
  /* [73][0][][] */ -6,37,-1,101,16,0,4,-25,74,29,-30,8,40,127,-71,-67, 
  /* [74][0][][] */ 66,-69,-9,-22,-41,-24,23,-15,-52,-27,-127,30,-98,-8,21,58, 
  /* [75][0][][] */ -13,-22,-19,127,-24,16,-13,-34,-70,5,-4,-27,1,-48,-16,-39, 
  /* [76][0][][] */ -1,-16,-4,29,37,8,-28,-127,-5,-115,4,20,-41,-25,18,-35, 
  /* [77][0][][] */ 127,-14,53,44,-26,-24,-37,-11,58,-14,-25,33,29,14,-64,41, 
  /* [78][0][][] */ -36,-9,44,3,28,12,-73,23,57,-44,-26,-33,6,127,27,-39, 
  /* [79][0][][] */ -3,22,41,2,45,53,-56,-62,0,-43,60,-19,127,-37,-22,-40, 
  /* [80][0][][] */ -66,-65,-58,127,-6,22,36,21,-57,67,-92,10,64,-42,-16,29, 
  /* [81][0][][] */ 70,-32,-37,63,127,66,-38,-51,10,-103,-26,-56,-24,-6,-69,14, 
  /* [82][0][][] */ 106,89,25,28,-97,-9,-98,3,-28,-29,127,-56,-44,127,-12,-32, 
  /* [83][0][][] */ 127,49,7,-21,10,-13,-12,20,26,30,77,-47,-51,-40,-24,-80, 
  /* [84][0][][] */ 70,-71,-72,-73,53,0,-24,-127,-58,-82,60,6,-18,21,9,-25, 
  /* [85][0][][] */ -29,14,-33,-40,5,2,83,98,-12,127,6,-50,26,66,61,-40, 
  /* [86][0][][] */ 79,-21,-6,23,-24,-12,-7,-21,6,6,-127,19,33,11,-2,35, 
  /* [87][0][][] */ -13,32,0,-17,-19,88,-29,56,-2,-23,30,15,19,-127,4,9, 
  /* [88][0][][] */ -48,-71,-127,-59,59,13,-40,-90,43,-84,-47,4,20,55,9,-1, 
  /* [89][0][][] */ 40,-1,28,-127,17,-1,-35,113,64,-83,10,40,-11,28,26,67, 
  /* [90][0][][] */ -33,6,-66,66,88,-2,103,-127,49,127,-57,38,59,-17,14,-1, 
  /* [91][0][][] */ 62,-14,-13,11,18,-127,-7,4,13,5,-43,-10,44,6,2,17, 
  /* [92][0][][] */ 15,16,127,75,30,3,32,40,-46,49,-108,37,43,72,11,6, 
  /* [93][0][][] */ 127,-53,-27,-27,-28,-41,0,52,-33,19,-96,3,-14,28,-14,68, 
  /* [94][0][][] */ 31,-29,29,101,86,-25,1,54,2,16,-15,46,0,127,-20,-51, 
  /* [95][0][][] */ -114,72,20,58,16,63,32,16,23,17,127,12,-16,44,-33,-48, 
};
const TfArray<4, int> tensor_dimension26 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant26_scale = { 96, { 0.00052432046504691243, 0.0010760833974927664, 0.0005434867343865335, 0.0024145357310771942, 0.0010533686727285385, 0.00054837664356455207, 0.0006825230666436255, 0.002040887949988246, 0.00098239723592996597, 0.00037196461926214397, 0.0007053935551084578, 0.0015524736372753978, 0.0011795138707384467, 0.00041836942546069622, 0.00078066147398203611, 0.00096529786242172122, 0.00072645529871806502, 0.00059523613890632987, 0.00070222554495558143, 0.0021084998734295368, 0.0009327232837677002, 0.00064831116469576955, 0.0012059559812769294, 0.00074384961044415832, 0.00068806216586381197, 0.0013706866884604096, 0.0010330339428037405, 0.00057106983149424195, 0.0020237525459378958, 0.0012618169421330094, 0.00078990089241415262, 0.00057809654390439391, 0.00038354331627488136, 0.0023402147926390171, 0.00062741979490965605, 0.0016300100833177567, 0.00038633239455521107, 0.0012515445705503225, 0.0018456104444339871, 0.00052418390987440944, 0.0020973465871065855, 0.00048669948591850698, 0.00054094323422759771, 0.00047050119610503316, 0.0009323399281129241, 0.0011287840316072106, 0.00065247196471318603, 0.00075174233643338084, 0.0011096772504970431, 0.00075568875763565302, 0.0014284764183685184, 0.0035895656328648329, 0.00052268285071477294, 0.00086770334746688604, 0.00069067993899807334, 0.00042754126479849219, 0.0013268780894577503, 0.00083654647460207343, 0.00067192583810538054, 0.0015934677794575691, 0.00035488081630319357, 0.00059960392536595464, 0.0011659556766971946, 0.0014945876318961382, 0.00051324808737263083, 0.00085776112973690033, 0.001080293906852603, 0.0013654725626111031, 0.0004811551480088383, 0.00052138289902359247, 0.00063323881477117538, 0.0011760323541238904, 0.00065935862949118018, 0.0011191340163350105, 0.00070679333293810487, 0.0012265201658010483, 0.00035244817263446748, 0.0012005965691059828, 0.00041859742486849427, 0.0016673740465193987, 0.00059098616475239396, 0.0015799837419763207, 0.00052311993204057217, 0.0013913528528064489, 0.00055248377611860633, 0.00083800643915310502, 0.00077173730824142694, 0.00097566354088485241, 0.00056556233903393149, 0.001132592442445457, 0.00047880594502203166, 0.0013757814886048436, 0.00049858033889904618, 0.00045481580309569836, 0.0010556135093793273, 0.00056865857914090157, } };
const TfArray<96, int> quant26_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant26 = { (TfLiteFloatArray*)&quant26_scale, (TfLiteIntArray*)&quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data27[96] = { 17628, 1004, 8769, -844, 5336, 5963, 16128, 6121, -1541, 17524, 7109, 1977, 8147, 40658, -704, -2732, 10805, 13609, 2187, -198, -930, 13335, 4262, 3758, 9072, 5379, 4888, 5819, 23, -25, 6612, 11506, 18195, 1604, 9310, -585, 20606, 7380, 899, 6700, 822, 13731, 14173, 5777, 4358, 10123, 15476, 6699, 5091, 4114, 311, -629, 18173, 6571, 12139, 15301, -292, 7391, 4061, 3600, 16642, 8225, 3345, 6555, 7246, 4657, 6383, -894, 19676, 7753, 11256, -1481, -2109, 4158, 2128, 3664, 23701, 13130, 13993, -2698, 6274, -4567, -2912, 623, 10236, 6546, 7300, 4922, 10230, 4960, 10167, 4216, 14789, 21280, -9730, 20553, };
const TfArray<1, int> tensor_dimension27 = { 1, { 96 } };
const TfArray<96, float> quant27_scale = { 96, { 0.00014840540825389326, 0.00030457822140306234, 0.00015383028949145228, 0.00068341824226081371, 0.00029814898152835667, 0.0001552143512526527, 0.00019318360136821866, 0.00057765969540923834, 0.00027806099387817085, 0.00010528210259508342, 0.00019965693354606628, 0.00043941728654317558, 0.00033385353162884712, 0.00011841667583212256, 0.00022096102475188673, 0.0002732211141847074, 0.00020561832934617996, 0.00016847762162797153, 0.00019876025908160955, 0.00059679680271074176, 0.00026400110800750554, 0.00018350014579482377, 0.00034133778535760939, 0.00021054166427347809, 0.00019475141016300768, 0.0003879637224599719, 0.0002923933498095721, 0.00016163750842679292, 0.00057280965847894549, 0.00035714884870685637, 0.00022357617854140699, 0.0001636263623367995, 0.00010855937580345199, 0.00066238216822966933, 0.00017758698959369212, 0.00046136346645653248, 0.00010934880265267566, 0.00035424134694039822, 0.00052238773787394166, 0.00014836675836704671, 0.00059363996842876077, 0.00013775704428553581, 0.00015311037714127451, 0.00013317221601027995, 0.00026389257982373238, 0.00031949477852322161, 0.0001846778322942555, 0.00021277564519550651, 0.00031408673385158181, 0.00021389266476035118, 0.00040432071546092629, 0.0010160026140511036, 0.00014794188609812409, 0.00024559765006415546, 0.00019549235003069043, 0.00012101270112907514, 0.0003755639772862196, 0.00023677889839746058, 0.000190184116945602, 0.00045102043077349663, 0.00010044664668384939, 0.00016971389413811266, 0.00033001595875248313, 0.00042303305235691369, 0.00014527144958265126, 0.00024278355704154819, 0.00030576996505260468, 0.0003864878963213414, 0.0001361877511953935, 0.00014757395547349006, 0.00017923401901498437, 0.00033286810503341258, 0.00018662706133909523, 0.00031676341313868761, 0.00020005313854198903, 0.00034715834772214293, 9.9758100986946374e-05, 0.00033982083550654352, 0.00011848120630020276, 0.00047193909995257854, 0.00016727468755561858, 0.00044720384175889194, 0.00014806560648139566, 0.00039381312672048807, 0.00015637684555258602, 0.00023719212913420051, 0.00021843508875463158, 0.00027615504222922027, 0.00016007864905986935, 0.00032057272619567811, 0.00013552283053286374, 0.00038940575905144215, 0.00014111983182374388, 0.00012873257219325751, 0.00029878434725105762, 0.00016095500905066729, } };
const TfLiteAffineQuantization quant27 = { (TfLiteFloatArray*)&quant27_scale, (TfLiteIntArray*)&g0::quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data28[1*3*3*96] = { 
  /* [0][0][][] */ -17,6,-20,107,-15,21,-60,-53,17,-6,97,-7,3,-9,-2,54,4,17,-33,5,75,1,31,-33,2,18,43,50,20,13,23,51,-9,28,6,-15,4,48,-57,-27,21,8,27,16,-84,-55,25,-4,-10,-19,-6,-6,50,6,-8,2,-2,-34,28,-31,28,-5,127,27,-14,-11,10,-51,68,36,0,-6,78,-33,67,3,17,-127,30,63,2,16,127,-14,39,28,-26,-19,36,-7,-15,82,0,21,-2,12, -49,11,-8,11,52,-8,-9,-127,39,13,-127,-5,-16,-13,6,96,16,-31,-10,-15,77,-99,127,25,-61,-32,-106,-15,27,36,-49,19,118,12,-11,-2,-25,127,-63,-127,10,-18,-28,15,48,-127,127,-43,-76,52,50,7,40,-62,32,55,38,42,-102,83,127,34,2,-20,43,-38,-98,1,38,-30,-17,49,-44,-47,105,-5,-30,-56,-32,59,-64,63,-19,9,-11,47,57,-41,-27,52,-13,72,-127,-29,25,-127, 0,-4,-23,-74,6,22,39,19,-4,-2,5,63,0,-13,-10,5,-15,16,-12,17,9,24,25,-32,1,-32,10,12,-5,4,46,-78,41,17,10,-22,11,5,-32,-22,8,2,-15,9,25,-30,20,2,8,-6,7,-6,4,6,-6,8,-7,45,7,-1,11,-20,2,-17,-26,-18,30,-49,-106,-7,42,-16,-127,-24,-13,16,11,-11,6,12,-14,22,-36,-1,-40,20,26,36,-28,-17,24,-10,18,7,-3,-48, 
  /* [0][1][][] */ -39,59,-18,41,-85,-16,-10,-42,28,95,-45,-21,-29,-26,-5,65,127,-23,-93,-13,59,-127,-28,16,-36,-47,-127,-6,39,37,-50,28,-127,-74,-57,3,64,-3,-46,46,-19,87,2,-3,35,-56,-12,-31,127,46,-4,20,45,10,-37,-17,33,11,-125,127,-37,-90,21,127,-60,-35,-84,127,-35,127,-22,56,-36,-57,35,7,-35,-70,127,46,127,38,6,0,127,27,-96,47,-36,-35,-104,39,94,100,29,-60, 127,127,127,127,-45,-127,127,23,127,-127,15,-127,-104,127,127,127,-16,-127,-60,-127,127,24,-66,127,127,127,-56,-127,127,127,-127,127,-10,-127,-118,127,-127,-46,93,109,-127,-127,127,127,127,-123,-107,127,-13,127,-127,-127,-127,127,127,-127,127,-127,-41,40,-109,-28,-72,-69,127,127,-65,127,127,-106,-127,127,-44,127,-127,-127,-127,126,-76,127,-41,127,80,127,-38,-127,-25,-107,-127,-127,-23,-127,-21,-127,-127,119, -23,66,-38,3,127,72,-18,46,5,24,-14,-4,-26,-30,-11,-9,-106,-21,-127,37,34,77,-12,-115,-34,-41,125,70,13,38,71,8,123,-46,127,-3,55,5,-93,13,35,23,-23,1,-23,-54,-14,-42,81,18,-12,38,-6,-4,-76,-14,24,20,127,-88,1,127,0,-35,-110,-28,-73,100,16,-17,112,26,-24,-57,10,45,-28,-8,-45,-2,-46,6,49,27,-89,34,127,-48,31,-22,127,-10,-110,33,32,18, 
  /* [0][2][][] */ -4,-36,-20,-58,-5,14,39,30,1,11,-20,54,25,-34,-5,8,41,4,4,21,-10,31,-16,-24,1,-24,9,3,-8,-7,49,-76,-40,70,-29,-26,30,-35,-61,17,10,11,-33,17,12,-81,-11,0,-8,7,15,-9,7,2,-22,6,-1,44,-49,35,-6,-15,4,17,-8,-10,24,-54,-55,13,-24,-10,-114,-33,-3,17,14,-11,59,17,23,21,-40,19,13,25,-22,9,4,25,22,-5,19,40,-7,-32, -28,-7,-26,26,-45,74,-24,62,6,-5,51,-11,127,-6,-15,-15,-2,-40,-61,23,-24,77,-43,-109,-47,-47,101,69,13,43,53,-2,-123,68,-10,-24,-28,-27,-127,-2,46,-12,-13,34,-28,-47,-18,-47,-60,26,67,24,-11,-79,31,52,18,26,76,-55,18,-58,-9,0,17,-26,-127,-55,-11,-26,-63,23,35,-46,-31,-7,-46,26,-56,4,49,38,17,12,6,62,-95,127,15,125,-33,-17,113,-21,48,84, -8,-31,-25,28,13,63,-41,11,4,-4,-1,16,13,-49,-8,-10,-46,-6,12,18,-22,5,-21,4,-4,19,-3,48,0,-6,33,30,19,46,22,-22,-7,-26,-30,6,13,-12,20,8,-74,-33,-13,5,-1,-13,0,-6,-9,9,-17,-4,0,-49,10,-27,-23,48,7,-29,-12,-2,35,-54,48,7,52,-19,26,-58,-19,21,10,12,-6,23,-29,32,87,-13,-18,55,40,-10,110,13,2,-18,13,-21,-7,-50, 
};
const TfArray<4, int> tensor_dimension28 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant28_scale = { 96, { 0.0072629856877028942, 0.0058743502013385296, 0.0096882721409201622, 0.0014672349207103252, 0.00644292077049613, 0.0073751728050410748, 0.013094784691929817, 0.0033909396734088659, 0.0059770713560283184, 0.017929378896951675, 0.0066029992885887623, 0.01466793566942215, 0.0045704692602157593, 0.015716403722763062, 0.0081180911511182785, 0.0069557437673211098, 0.0043089189566671848, 0.013002257794141769, 0.0028751003555953503, 0.0094529017806053162, 0.001941632479429245, 0.007223071064800024, 0.0057922676205635071, 0.015386654995381832, 0.0093547990545630455, 0.0089837647974491119, 0.0057850410230457783, 0.0082646980881690979, 0.0058693769387900829, 0.0049878377467393875, 0.0053669423796236515, 0.0074834502302110195, 0.00511572090908885, 0.0068201185204088688, 0.0077616446651518345, 0.0064180749468505383, 0.017762774601578712, 0.0047533139586448669, 0.0021698982454836369, 0.0069896862842142582, 0.0082155922427773476, 0.011512784287333488, 0.013716218061745167, 0.0066559384576976299, 0.0077749923802912235, 0.00219911546446383, 0.0090220803394913673, 0.0082881627604365349, 0.0029320486355572939, 0.0074121449142694473, 0.0073788412846624851, 0.0058548543602228165, 0.0091167287901043892, 0.0099384067580103874, 0.0084682079032063484, 0.01911122165620327, 0.011929236352443695, 0.0090440642088651657, 0.0039275349117815495, 0.003121640533208847, 0.012674121186137199, 0.0055416487157344818, 0.011034146882593632, 0.0054085901938378811, 0.0067579429596662521, 0.0072737289592623711, 0.0036253593862056732, 0.0026893510948866606, 0.013575566932559013, 0.0083578722551465034, 0.007760239765048027, 0.004254891537129879, 0.0052701923996210098, 0.0057225152850151062, 0.0068562310189008713, 0.0085698086768388748, 0.02129974402487278, 0.0022328633349388838, 0.010594505816698074, 0.012889187783002853, 0.0060704834759235382, 0.011239505372941494, 0.0060405978001654148, 0.0068240906111896038, 0.0051265144720673561, 0.0035229620989412069, 0.0050938078202307224, 0.0073764212429523468, 0.008050660602748394, 0.0046253721229732037, 0.0067311068996787071, 0.0046871206723153591, 0.0058796177618205547, 0.018407255411148071, 0.057786751538515091, 0.0033689609263092279, } };
const TfLiteAffineQuantization quant28 = { (TfLiteFloatArray*)&quant28_scale, (TfLiteIntArray*)&g0::quant26_zero, 3 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data29[96] = { 10358, -9144, 2748, 62435, -1625, -4447, -12011, 3542, -3133, 862, 3733, -1668, 863, -7487, 4732, -5290, -373, 16441, 24709, 2568, 2609, -2234, 988, 66, 16346, -1587, -895, -3151, -5912, -7512, 7048, -9122, 938, -1115, -1664, 15343, 1812, -3591, 20544, -92, -698, 1672, -10652, -8052, -7684, 67087, 577, 16892, 38149, -13047, 234, 9430, 7705, -470, -6624, 2176, -13390, 1283, 1557, -7030, -696, -608, -13264, -199, 1917, 16392, 29226, 28033, -13055, 1, -9601, -1028, 46726, 10308, 123, 292, 18505, 30752, -405, -6246, -2351, -8246, 863, -3669, 1173, 3573, 840, -273, 1709, -2993, 102, -646, 145, -389, 932, 48593, };
const TfArray<96, float> quant29_scale = { 96, { 0.00017089377797674388, 0.0001382200134685263, 0.00022795934637542814, 3.4523174690548331e-05, 0.00015159814211074263, 0.0001735334808472544, 0.00030811259057372808, 7.9786819696892053e-05, 0.00014063697017263621, 0.00042186773498542607, 0.00015536468708887696, 0.00034512791899032891, 0.00010754045797511935, 0.00036979775177314878, 0.00019101391080766916, 0.00016366456111427397, 0.00010138632933376357, 0.00030593547853641212, 6.7649423726834357e-05, 0.00022242122213356197, 4.5685472287004814e-05, 0.00016995461191982031, 0.000136288654175587, 0.00036203896161168814, 0.00022011292458046228, 0.00021138270676601678, 0.00013611861504614353, 0.00019446348596829921, 0.00013810298696625978, 0.00011736089072655886, 0.00012628099648281932, 0.00017608118650969118, 0.0001203699066536501, 0.00016047338431235403, 0.00018262694356963038, 0.00015101353346835822, 0.00041794765274971724, 0.00011184268078068271, 5.1056431402685121e-05, 0.00016446321387775242, 0.00019330804934725165, 0.00027088905335403979, 0.00032273455872200429, 0.00015661031648050994, 0.000182941003004089, 5.1743892981903628e-05, 0.00021228424157015979, 0.00019501560018397868, 6.8989378632977605e-05, 0.00017440340889152139, 0.00017361980280838907, 0.00013776127889286727, 0.00021451126667670906, 0.00023384486848954111, 0.00019925195374526083, 0.00044967580470256507, 0.00028068790561519563, 0.00021280151850078255, 9.2412585217971355e-05, 7.3450370109640062e-05, 0.00029821461066603661, 0.00013039173791185021, 0.0002596269769128412, 0.000127260951558128, 0.0001590104220667854, 0.00017114657384809107, 8.5302577645052224e-05, 6.3278850575443357e-05, 0.00031942510395310819, 0.00019665581930894405, 0.00018259388161823153, 0.00010011509584728628, 0.00012400452396832407, 0.00013464741641655564, 0.0001613230851944536, 0.00020164255693089217, 0.00050117046339437366, 5.253796189208515e-05, 0.00024928248603828251, 0.00030327501008287072, 0.00014283490600064397, 0.00026445896946825087, 0.0001421317138010636, 0.0001605668367119506, 0.00012062387395417318, 8.2893224316649139e-05, 0.00011985430319327861, 0.00017356286116410047, 0.00018942731549032032, 0.00010883228969760239, 0.0001583789853611961, 0.00011028519656974822, 0.0001383439521305263, 0.00043311191257089376, 0.00135968835093081, 7.9269673733506352e-05, } };
const TfLiteAffineQuantization quant29 = { (TfLiteFloatArray*)&quant29_scale, (TfLiteIntArray*)&g0::quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data30[16*1*1*96] = { 
  /* [0][0][][] */ -12,19,-8,33,47,77,-23,-20,45,12,7,-1,-10,5,21,74,10,-4,-12,7,96,-51,2,-11,-20,-38,-40,-89,0,-2,44,45,118,-9,3,-5,8,-10,-27,-11,-27,-4,28,-27,6,-30,-5,35,-23,19,0,-7,-37,0,3,-7,42,29,-14,-39,-60,27,-20,-9,2,12,54,3,20,3,-1,-30,-63,-17,-20,0,-13,-95,9,-5,49,-10,-50,-51,15,-13,2,15,-9,-6,12,-29,32,30,-11,127, 
  /* [1][0][][] */ 57,-107,48,81,-6,-86,2,-58,-33,-86,-11,9,17,-82,-34,-64,-108,10,23,32,-34,-118,-31,35,127,-47,-59,31,-23,95,-4,66,26,-4,-55,14,-19,-25,70,-27,-17,-78,81,-24,-62,-3,46,-6,33,11,19,-59,79,-86,41,-31,1,6,-36,-92,36,-51,9,-51,-26,-95,50,58,42,48,-41,18,-127,25,-16,54,19,80,19,10,30,11,-72,44,-94,60,-12,67,-47,30,12,14,-10,-51,30,-20, 
  /* [2][0][][] */ 23,-3,13,-15,13,-2,-9,55,60,-9,5,65,-5,-1,45,6,-17,-15,24,6,-21,-47,-3,-65,-3,-16,-22,25,-29,14,118,-56,24,-71,-25,50,19,127,-59,-32,7,-24,-1,25,-37,-43,-69,14,18,19,-34,-25,4,-9,-2,-38,-21,3,-2,23,3,15,71,96,-6,-72,9,-60,-12,-14,-9,13,-25,1,-21,15,1,63,8,29,13,93,31,-22,-25,9,8,9,13,12,-9,-44,-43,12,-2,62, 
  /* [3][0][][] */ -25,-23,-42,27,20,-20,-15,-43,-26,8,11,-5,6,-17,62,-32,40,-47,8,7,-26,-21,1,-3,0,15,-5,-8,23,-52,66,-27,5,-3,-26,58,-19,-11,10,21,-9,-73,31,-23,-17,1,-8,0,-127,56,-13,27,-114,-51,-34,-44,24,23,-31,63,-1,16,8,11,-18,-99,-45,17,36,15,-3,26,-32,4,2,-44,-51,-73,29,-41,-1,-28,12,88,43,74,36,27,25,-16,-1,4,-43,-5,-25,-38, 
  /* [4][0][][] */ 1,-36,4,-93,10,-15,-51,10,-27,-44,-8,0,-4,81,-6,13,60,-15,17,-9,-6,17,62,1,-18,10,22,9,1,-12,3,-17,-46,17,1,1,37,-17,9,13,26,16,-112,-39,38,-19,-3,-22,21,75,-10,-4,-16,-20,8,-4,-3,-30,12,42,18,5,5,-20,60,-127,13,-25,-48,12,-15,-12,9,37,-16,39,-15,66,73,-28,-17,-8,126,-47,47,-26,-1,1,83,-3,-4,28,-47,41,2,-44, 
  /* [5][0][][] */ -6,3,9,4,1,-16,10,92,56,1,-14,-46,-22,32,39,24,-4,-9,4,-33,-41,1,1,-44,14,12,21,73,76,4,53,47,-52,28,7,-5,-39,-50,-18,-11,-49,-22,3,-11,65,9,6,15,8,13,-8,9,-25,-15,-7,-11,-16,-14,-11,46,-49,12,-10,-36,10,16,-20,16,-1,36,2,6,8,4,17,-10,-3,23,6,127,12,-34,36,43,3,3,27,-22,-10,-5,23,-111,-20,-26,-9,-114, 
  /* [6][0][][] */ -27,11,1,-51,0,-27,-4,4,-1,18,-23,-8,38,-60,25,-21,-12,-64,30,6,-4,13,-19,35,89,-7,-3,7,31,-12,4,-16,-14,-14,-25,6,19,-1,27,38,-11,-42,-40,-22,1,-19,26,-127,16,36,28,3,9,5,0,-51,43,-9,-5,11,24,26,17,11,34,74,34,-18,-26,3,8,-15,1,-3,46,-7,-33,35,-4,18,-16,1,61,-21,1,45,24,-23,13,25,-26,-4,-18,9,-12,13, 
  /* [7][0][][] */ 22,15,32,-15,-5,-4,5,-37,3,-16,-24,-21,-15,-94,44,13,-9,-32,-12,-12,11,-14,-36,-1,-19,-16,-1,-8,14,5,1,3,-11,-13,-2,-25,12,-18,-47,15,11,-23,-14,26,-3,16,5,76,-8,22,-17,-30,-26,10,0,-61,46,-5,4,13,-10,5,-8,0,-28,44,19,-23,-9,2,5,57,-23,-16,-9,18,47,3,-12,-7,18,-28,51,-3,-43,127,2,0,-50,-16,6,30,-16,-3,-8,7, 
  /* [8][0][][] */ -63,46,-37,6,47,-13,8,33,25,96,-41,-7,12,46,84,-12,15,25,-81,30,34,53,-52,9,-47,-18,14,14,61,-76,-6,7,25,15,22,-5,6,36,-35,46,-2,-3,7,-127,-31,-16,32,-12,-57,19,9,66,-103,61,-3,0,9,-29,-6,-14,18,-45,44,29,-19,32,32,-5,4,15,32,83,-40,34,26,21,-4,-74,1,-20,25,-1,38,24,-62,7,32,-57,18,50,-15,-7,63,-35,-25,-23, 
  /* [9][0][][] */ 18,-61,-34,-45,7,29,-28,31,23,-34,8,25,-43,-29,-8,12,-25,7,31,-20,-29,-4,-25,-51,40,13,32,-27,-44,-36,-13,-17,-11,-1,-7,41,-16,40,-24,33,7,27,-28,-76,-2,-8,15,-127,-30,0,3,24,-26,1,-6,5,-49,14,-29,-1,17,22,-6,17,18,106,32,33,5,-18,2,-40,0,-2,-24,12,60,-3,14,-4,-42,-7,-2,-43,0,30,-23,5,-57,23,-48,-4,-13,9,8,-13, 
  /* [10][0][][] */ 35,70,-19,38,80,-127,-9,-35,14,55,34,-3,-14,35,32,-93,11,39,-18,31,-82,-9,-3,-27,-71,-15,-53,50,14,3,-7,49,-15,-11,43,-9,88,-25,-15,-3,-10,62,47,-26,-50,-19,-32,15,-18,-20,-43,-12,-9,-7,-10,-22,8,36,-36,-3,-11,-2,-27,24,21,61,64,31,48,13,29,60,-72,-25,-37,-19,-3,13,-22,11,47,-5,-64,-40,62,-51,104,-20,-34,26,38,-5,98,49,-26,-127, 
  /* [11][0][][] */ 43,39,-23,21,0,11,57,-2,5,-4,-18,-26,-3,9,43,4,6,-10,-99,-7,3,27,4,-3,-39,-13,-13,-1,11,23,-7,-9,-11,16,11,25,16,12,2,18,-5,17,48,-95,32,-39,0,2,-127,19,11,-46,26,15,-29,12,-8,-6,16,11,10,-24,5,8,-46,56,-12,24,13,-1,20,14,-60,-31,13,15,-3,-32,-48,15,31,9,94,56,5,-10,-1,-13,10,29,-9,-4,18,-3,-28,16, 
  /* [12][0][][] */ -47,-12,16,7,-24,53,15,5,127,11,-22,-8,11,-8,-49,-26,38,16,11,83,49,36,-16,-11,4,-4,34,-38,-113,7,35,-52,1,-6,-6,-17,7,7,45,-26,-46,-24,-8,14,1,36,10,-5,16,10,-46,10,-1,-1,8,-5,67,-21,24,7,18,-10,13,-13,-15,21,-45,4,-9,-7,-11,-36,25,1,-95,0,21,-2,16,-63,-10,11,36,34,-18,-29,-33,-13,17,9,-17,39,-17,-14,24,7, 
  /* [13][0][][] */ 33,-14,-22,28,28,1,7,5,-5,12,15,-4,9,-6,13,-9,24,-77,-32,11,-8,-19,6,9,-1,10,-5,-8,-10,-26,-10,25,6,10,14,47,23,4,-2,21,-2,3,20,38,20,18,-5,-127,22,-9,5,7,-12,-11,20,10,-11,17,18,12,16,17,-9,2,4,-16,-15,-52,13,11,-2,-37,-12,35,-11,14,-24,10,27,-8,34,-16,-14,22,12,30,17,17,-6,0,29,-10,2,11,-22,-11, 
  /* [14][0][][] */ -107,-54,15,36,23,-18,-40,16,-8,13,-1,24,58,4,-127,0,77,-16,-15,27,-7,-21,38,10,-110,7,29,-24,-50,-66,-21,2,-9,3,14,-54,28,37,-13,26,24,40,-14,-27,13,108,64,47,-95,50,6,37,-43,-18,32,1,3,11,48,48,39,40,10,33,11,-18,-49,38,4,66,-47,-82,-58,5,1,46,-10,29,89,-15,34,5,19,7,47,14,35,31,33,33,54,-11,-13,19,20,-26, 
  /* [15][0][][] */ 89,-12,37,8,-7,84,41,-6,-12,52,8,17,-90,-4,-11,41,19,36,48,-20,12,11,-95,74,6,0,37,-14,2,41,-72,-81,14,-46,57,2,35,-20,-86,-119,11,6,-9,39,26,59,-10,-36,96,-62,-56,23,42,-118,58,-104,9,-41,21,16,-127,-13,0,9,93,-7,-60,35,-18,85,-17,28,43,24,10,2,18,-66,56,-24,-15,-3,29,72,-35,-10,21,-51,-7,-24,62,7,-64,64,9,13, 
};
const TfArray<4, int> tensor_dimension30 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant30_scale = { 16, { 0.018783561885356903, 0.010694075375795364, 0.01121942512691021, 0.0088258031755685806, 0.013303675688803196, 0.016458924859762192, 0.014182843267917633, 0.014481093734502792, 0.0083485692739486694, 0.011832708492875099, 0.015131172724068165, 0.030681585893034935, 0.016262374818325043, 0.01975245401263237, 0.020924154669046402, 0.013786830008029938, } };
const TfLiteAffineQuantization quant30 = { (TfLiteFloatArray*)&quant30_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data31[16] = { -5037, 8985, -7423, 32702, 25258, 4189, -6868, -3194, 21689, 6826, 27216, 19890, -8927, 10649, 33327, -26142, };
const TfArray<16, float> quant31_scale = { 16, { 0.00044196617091074586, 0.00025162531528621912, 0.0002639864687807858, 0.00020766595844179392, 0.00031302767456509173, 0.00038726883940398693, 0.00033371397876180708, 0.00034073161077685654, 0.00019643692940007895, 0.00027841667179018259, 0.00035602759453468025, 0.00072191969957202673, 0.00038264412432909012, 0.00046476363786496222, 0.00049233308527618647, 0.00032439600909128785, } };
const TfLiteAffineQuantization quant31 = { (TfLiteFloatArray*)&quant31_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data32[96*1*1*16] = { 
  /* [0][0][][] */ -12,62,-31,123,-8,86,0,-13,51,34,-80,99,26,-127,33,-121, 
  /* [1][0][][] */ 9,36,8,-14,31,-20,127,-101,1,72,-7,-32,4,-51,27,15, 
  /* [2][0][][] */ -110,40,-37,22,11,-11,50,127,5,69,110,15,-60,36,12,-54, 
  /* [3][0][][] */ -66,73,42,43,-52,15,49,127,18,46,-99,46,32,-56,-67,-57, 
  /* [4][0][][] */ 10,-3,41,58,-44,103,-2,71,25,-37,18,28,14,8,-127,-50, 
  /* [5][0][][] */ -20,-25,71,3,25,-56,-18,22,-77,104,-32,-127,-19,38,-63,-41, 
  /* [6][0][][] */ 4,-4,34,2,38,71,-72,-65,-2,1,49,-5,127,-19,-2,-51, 
  /* [7][0][][] */ 34,22,127,-30,-32,-54,-5,2,-100,18,-73,-48,20,-15,35,-9, 
  /* [8][0][][] */ 8,21,60,21,-24,68,10,63,20,-3,14,-88,-28,-14,-127,-57, 
  /* [9][0][][] */ 18,-127,82,47,13,4,-10,21,94,-9,88,-12,-44,24,-103,-41, 
  /* [10][0][][] */ -28,-96,-3,-30,-127,15,-14,85,76,123,32,-45,-47,96,94,-16, 
  /* [11][0][][] */ 42,-14,6,-90,2,-30,-110,-127,-43,34,14,-13,21,-11,54,-64, 
  /* [12][0][][] */ -2,15,-3,-41,-18,3,-127,-1,-67,-100,1,27,57,122,108,32, 
  /* [13][0][][] */ -24,-66,-60,36,-4,-55,8,-29,58,44,18,13,10,26,127,42, 
  /* [14][0][][] */ -16,-69,37,38,12,54,-1,127,19,46,26,-21,26,39,-65,109, 
  /* [15][0][][] */ 3,-20,-13,51,16,3,91,1,2,-127,21,-32,5,-24,-3,-38, 
  /* [16][0][][] */ 23,-83,-78,28,-9,-57,30,-127,107,79,113,9,14,118,112,122, 
  /* [17][0][][] */ -71,-34,57,87,127,56,-30,0,93,-73,7,-55,33,43,-125,41, 
  /* [18][0][][] */ -22,6,20,36,-72,19,-18,20,-63,-9,-11,-63,-16,-127,64,21, 
  /* [19][0][][] */ 92,-43,59,-109,111,-12,-78,127,71,-39,39,35,-12,34,44,106, 
  /* [20][0][][] */ 42,-12,48,-47,-24,-12,-41,49,-3,-48,86,6,28,28,-26,127, 
  /* [21][0][][] */ -77,-68,18,-40,34,31,-115,-74,-68,97,-31,-65,-127,-52,44,-28, 
  /* [22][0][][] */ 18,-34,30,-20,20,-69,22,-31,-127,29,-24,-63,-33,-7,80,-21, 
  /* [23][0][][] */ 10,10,14,-7,10,6,-22,-11,-7,-10,47,-6,127,-9,14,-34, 
  /* [24][0][][] */ -36,18,-6,-82,-25,14,74,39,-14,-20,32,-124,-10,-127,20,47, 
  /* [25][0][][] */ -81,14,-32,46,87,-127,-69,-96,29,76,-105,-111,-25,-65,32,-38, 
  /* [26][0][][] */ 17,-21,38,-108,93,-45,-1,-24,92,-41,54,-48,9,82,8,127, 
  /* [27][0][][] */ 94,-25,20,-37,-37,-49,-4,-12,-24,13,-127,23,19,-18,-3,35, 
  /* [28][0][][] */ -127,-55,-79,-100,83,-6,101,-53,-20,57,-99,-32,5,6,-69,37, 
  /* [29][0][][] */ -63,-53,2,127,6,-7,23,-48,16,6,-104,27,26,-43,33,-62, 
  /* [30][0][][] */ 70,-16,127,-10,27,74,-28,88,-47,-80,64,-47,2,23,-83,56, 
  /* [31][0][][] */ 33,-81,-3,-55,-11,-69,16,-40,-11,60,75,13,-12,78,62,127, 
  /* [32][0][][] */ -8,71,-32,35,-127,15,-70,-44,-58,-27,-6,42,16,46,30,68, 
  /* [33][0][][] */ 23,-6,4,127,11,10,-10,-50,-88,28,73,-7,1,-13,27,110, 
  /* [34][0][][] */ 57,-27,56,15,113,-44,-105,-12,-46,127,-70,-27,-9,30,-30,42, 
  /* [35][0][][] */ 71,24,-26,-1,-5,-127,-31,14,-18,-27,-69,9,39,18,-2,17, 
  /* [36][0][][] */ 11,-3,-127,8,30,11,-10,13,-32,-4,-5,-17,-3,-1,-9,19, 
  /* [37][0][][] */ -3,-6,127,-10,-77,53,35,-80,-47,50,-85,17,51,-25,11,-32, 
  /* [38][0][][] */ -127,61,10,65,13,47,14,-9,76,-3,114,2,-43,35,-17,-37, 
  /* [39][0][][] */ -15,-15,16,31,31,-17,-127,45,7,42,-12,-44,9,-18,5,-4, 
  /* [40][0][][] */ 0,70,-34,127,-5,47,56,6,-68,-20,-67,55,28,20,-44,-19, 
  /* [41][0][][] */ 21,19,-39,-42,-38,-6,127,95,-41,109,-30,-29,-10,47,19,13, 
  /* [42][0][][] */ 25,-70,-29,3,57,16,-43,49,98,-85,127,43,11,14,-69,11, 
  /* [43][0][][] */ -59,-20,51,-53,42,24,-46,-71,-44,52,-14,-48,-127,-11,20,3, 
  /* [44][0][][] */ 14,21,-35,-21,-16,-33,0,-55,127,-1,10,62,30,80,10,51, 
  /* [45][0][][] */ -53,-90,5,-85,32,-4,-9,41,14,-74,-34,-36,36,109,-34,127, 
  /* [46][0][][] */ -4,13,-23,110,-90,-18,13,-75,-127,62,-55,-35,2,41,9,-32, 
  /* [47][0][][] */ -15,-15,-110,127,-10,74,0,-29,11,59,81,70,-15,-46,24,-23, 
  /* [48][0][][] */ 0,7,20,-127,36,-30,-35,0,-51,-13,49,30,-26,35,90,32, 
  /* [49][0][][] */ -17,30,21,111,-46,96,-72,2,31,-68,-114,-14,16,-65,-61,-127, 
  /* [50][0][][] */ 19,45,40,-94,77,19,-10,67,127,-16,-40,10,13,-22,24,-18, 
  /* [51][0][][] */ 27,-46,9,-1,75,-20,-86,-127,-17,-68,7,-35,13,-15,3,-6, 
  /* [52][0][][] */ 24,15,-4,36,47,-18,-56,108,-84,127,-37,-41,87,107,-13,-43, 
  /* [53][0][][] */ -22,99,1,-103,-63,9,30,-21,-62,-64,-30,72,2,-127,-99,-34, 
  /* [54][0][][] */ -16,12,7,23,41,-27,4,-42,6,31,-7,-34,-19,127,-37,-5, 
  /* [55][0][][] */ -119,127,123,2,62,-7,-29,-17,-55,40,101,-47,-23,-32,126,8, 
  /* [56][0][][] */ 90,-1,26,-115,100,-4,-19,52,92,-26,2,127,-28,23,99,71, 
  /* [57][0][][] */ -21,-3,33,81,-15,10,48,127,-4,0,17,-36,1,59,5,33, 
  /* [58][0][][] */ 30,127,-5,-101,11,49,-24,32,87,-19,-2,102,22,-87,47,46, 
  /* [59][0][][] */ 30,63,45,-109,-44,3,16,-8,15,13,29,-51,-5,-127,-78,15, 
  /* [60][0][][] */ 36,-10,99,-37,-25,127,19,-41,-12,35,-55,-7,29,14,16,-19, 
  /* [61][0][][] */ -50,13,-14,-42,-28,51,104,127,2,60,-17,15,-1,54,9,-30, 
  /* [62][0][][] */ 5,-29,6,-8,-49,-33,-22,22,-44,-9,-49,-75,44,-127,55,-1, 
  /* [63][0][][] */ 3,-18,6,-83,52,-1,-98,-127,-43,95,-14,-7,43,2,27,-41, 
  /* [64][0][][] */ -34,-10,30,62,69,5,-20,-127,40,-100,-9,-69,-38,-14,1,13, 
  /* [65][0][][] */ -127,7,34,-56,12,82,56,-60,-83,43,40,-31,-6,27,-8,-21, 
  /* [66][0][][] */ 85,22,82,4,-82,26,-13,67,-78,17,69,-112,6,37,-127,25, 
  /* [67][0][][] */ 36,-17,-42,73,53,-44,-99,-127,37,-107,-74,-22,-98,-10,-66,-10, 
  /* [68][0][][] */ 22,-36,-76,31,-64,-94,3,-55,-18,-3,57,-57,-38,48,127,-26, 
  /* [69][0][][] */ -36,50,-80,66,4,-127,31,115,79,-8,36,-9,122,51,-2,33, 
  /* [70][0][][] */ 24,19,-27,-36,-46,11,127,105,-14,71,-28,1,10,45,14,-25, 
  /* [71][0][][] */ 20,-11,-26,-56,19,0,13,58,-36,-46,-13,-1,18,-127,67,9, 
  /* [72][0][][] */ 20,45,-18,63,40,-28,-40,-127,32,65,-43,-1,37,62,41,46, 
  /* [73][0][][] */ -30,-127,-54,-76,-102,-16,32,-27,-36,11,-21,-14,31,-60,80,-33, 
  /* [74][0][][] */ -24,33,52,70,-5,5,-127,68,9,-55,-28,-27,-2,-15,-12,10, 
  /* [75][0][][] */ -84,-5,-31,49,2,77,64,120,-1,99,-20,-86,-127,116,8,14, 
  /* [76][0][][] */ 37,-64,-60,-3,79,-98,-127,-114,-54,-14,-7,-40,64,24,48,-15, 
  /* [77][0][][] */ -39,13,-31,-28,-42,-23,-24,-49,127,-7,-54,24,-4,52,49,-62, 
  /* [78][0][][] */ -88,-127,5,84,91,43,-38,35,-28,-62,-120,49,61,-8,81,66, 
  /* [79][0][][] */ 20,2,12,-72,127,18,45,13,80,19,-8,46,-20,-61,29,-68, 
  /* [80][0][][] */ 5,-14,57,-127,-19,-7,14,24,-94,-50,-6,-48,-7,119,-38,27, 
  /* [81][0][][] */ 57,13,37,43,-5,75,-35,-25,-22,-16,-19,-31,-8,33,-127,20, 
  /* [82][0][][] */ -66,-29,52,-96,6,-30,13,-44,-15,-18,-3,-127,-50,-110,-103,28, 
  /* [83][0][][] */ 16,40,1,-77,-21,-44,17,64,-108,0,-34,-127,49,-120,4,32, 
  /* [84][0][][] */ 127,18,17,39,-50,-19,-58,16,-32,-24,82,-6,-26,12,72,-52, 
  /* [85][0][][] */ -25,-22,9,-34,53,-32,-65,119,-81,-127,-48,-5,-4,73,115,-125, 
  /* [86][0][][] */ 35,-6,-12,10,-80,83,-37,37,-104,-54,5,-17,-13,-127,-13,36, 
  /* [87][0][][] */ 77,-34,2,13,-50,-21,6,-9,-13,50,-127,21,46,-10,18,-4, 
  /* [88][0][][] */ 9,8,14,-11,-7,-36,-26,-21,64,9,1,20,3,-23,127,-100, 
  /* [89][0][][] */ 67,89,-64,-14,-47,0,32,-33,29,49,0,-53,-18,5,-21,-127, 
  /* [90][0][][] */ -9,-16,5,-79,-65,-4,127,-56,75,-67,15,-107,55,-12,-27,-1, 
  /* [91][0][][] */ 4,21,-2,-72,-38,-3,28,-37,-41,22,64,73,2,-7,55,127, 
  /* [92][0][][] */ 17,25,6,11,64,-15,-75,-127,32,-65,-2,-21,-42,-10,4,-28, 
  /* [93][0][][] */ 75,-4,61,-127,-32,-3,-28,56,30,-75,63,-31,-23,106,-21,36, 
  /* [94][0][][] */ -127,57,-118,12,75,-108,-25,-18,-16,-47,98,-47,8,-22,-41,-14, 
  /* [95][0][][] */ 12,69,39,-127,25,6,-37,34,42,-12,-60,-69,0,39,-81,-14, 
};
const TfArray<96, float> quant32_scale = { 96, { 0.00060165754985064268, 0.00078975764336064458, 0.00036805751733481884, 0.00031270456383936107, 0.00055086042266339064, 0.00076194218127056956, 0.0015366297448053956, 0.00093938846839591861, 0.0002904578868765384, 0.00095242128008976579, 0.00076210737461224198, 0.00061275064945220947, 0.00040622486267238855, 0.00067792495246976614, 0.00021740331430919468, 0.0014463216066360474, 0.00052864715689793229, 0.00047359193558804691, 0.00059496122412383556, 0.00059299339773133397, 0.0010038187028840184, 0.0011462967377156019, 0.00051909539615735412, 0.0020728942472487688, 0.0018776623765006661, 0.00075458106584846973, 0.0005426815478131175, 0.00056819489691406488, 0.00076461979188024998, 0.00025878360611386597, 0.00016059679910540581, 0.00049285305431112647, 0.00054008094593882561, 0.00096854061121121049, 0.00044263558811508119, 0.00077666644938290119, 0.0011721161426976323, 0.00095309794414788485, 0.0003950770478695631, 0.0020272971596568823, 0.00048456454533152282, 0.00054944911971688271, 0.00023323544883169234, 0.00091773748863488436, 0.0004165754362475127, 0.00058783771237358451, 0.00073541339952498674, 0.00047011257265694439, 0.00023346567468252033, 0.00071651424514129758, 0.0006868962082080543, 0.00058377580717206001, 0.00078707927605137229, 0.00064707244746387005, 0.0013579655205830932, 0.00050311203813180327, 0.00056386174401268363, 0.00032585876761004329, 0.0011107058962807059, 0.00056780199520289898, 0.0010644553694874048, 0.00028130313148722053, 0.00078137480886653066, 0.00059427169617265463, 0.00088169606169685721, 0.00065111380536109209, 0.00076629180693998933, 0.00080774497473612428, 0.00066478061489760876, 0.00062252639327198267, 0.00063004199182614684, 0.00050886243116110563, 0.00032150076003745198, 0.00050573906628414989, 0.0015848258044570684, 0.00068038847530260682, 0.00068612914765253663, 0.0010701091960072517, 0.0010152056347578764, 0.0010900130728259683, 0.00035277404822409153, 0.00048360635992139578, 0.00055500882444903255, 0.00044909876305609941, 0.0012239778880029917, 0.00080059567699208856, 0.00061062502209097147, 0.00020515963842626661, 0.00064455147366970778, 0.00065852276748046279, 0.00070151296677067876, 0.001293337089009583, 0.00078775768633931875, 0.00050886080134660006, 0.00070932856760919094, 0.00040897633880376816, } };
const TfLiteAffineQuantization quant32 = { (TfLiteFloatArray*)&quant32_scale, (TfLiteIntArray*)&g0::quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data33[96] = { 1952, 5936, 16884, 23591, 17571, -4156, -1710, 5571, 26200, -4644, 11400, 4651, 10012, 10946, 36171, 1268, 2657, 8592, 12165, 6457, -248, 739, 12656, -949, 4570, 259, 13338, 8266, 7194, 44195, 57756, 16313, 10116, -831, 14734, 2312, 1329, 5286, 21559, -924, 12568, 9430, 37573, -3733, 25292, 8486, 7659, 18783, 57120, 9777, -549, 9585, -4398, -157, -2562, 7321, -611, 18887, 6076, 8454, 4916, 16335, 6105, 5378, 9174, 9623, 5505, -5357, 8223, -3334, 5813, 10229, 20977, 6714, -3140, -6215, 7930, 188, 2465, -1109, 19117, 11338, 5206, 13852, 3056, 266, 12551, 60544, 7121, 11007, 6053, -179, 6037, 10276, 5258, 13439, };
const TfArray<96, float> quant33_scale = { 96, { 0.00018467751215212047, 0.00024241443315986544, 0.00011297447781544179, 9.5984003564808518e-05, 0.00016908544057514518, 0.00023387654800899327, 0.00047166526201181114, 0.00028834331897087395, 8.9155437308363616e-05, 0.00029234369867481291, 0.0002339272468816489, 0.00018808251479640603, 0.00012468986096791923, 0.0002080876292893663, 6.6731488914228976e-05, 0.00044394534779712558, 0.00016226712614297867, 0.00014536804519593716, 0.00018262209778185934, 0.00018201807688456029, 0.00030812004115432501, 0.00035185334854759276, 0.00015933523536659777, 0.00063627050258219242, 0.00057634449331089854, 0.00023161705757956952, 0.00016657495871186256, 0.00017440621741116047, 0.0002346984256291762, 7.9433084465563297e-05, 4.9294849304715171e-05, 0.00015128019731491804, 0.00016577669885009527, 0.00029729149537160993, 0.00013586605200544, 0.00023839612549636513, 0.00035977858351543546, 0.00029255141271278262, 0.00012126806541346014, 0.00062227458693087101, 0.00014873605687171221, 0.00016865224461071193, 7.1591130108572543e-05, 0.00028169757570140064, 0.00012786695151589811, 0.00018043554155156016, 0.00022573358728550375, 0.00014430006558541209, 7.1661794208921492e-05, 0.00021993253903929144, 0.00021084134641569108, 0.00017918874800670892, 0.00024159232270903885, 0.0001986175193451345, 0.00041682465234771371, 0.00015442917356267571, 0.00017307617235928774, 0.00010002165799960494, 0.00034092881833203137, 0.00017428562568966299, 0.00032673231908120215, 8.6345404270105064e-05, 0.00023984134895727038, 0.00018241044017486274, 0.00027063474408350885, 0.00019985801191069186, 0.00023521165712736547, 0.00024793561897240579, 0.000204053008928895, 0.00019108316337224096, 0.00019339006394147873, 0.00015619424812030047, 9.8683980468194932e-05, 0.00015523553884122521, 0.00048645894275978208, 0.00020884380501229316, 0.0002106058964272961, 0.00032846775138750672, 0.00031161523656919599, 0.00033457719837315381, 0.00010828324593603611, 0.00014844194811303169, 0.0001703587913652882, 0.00013784991460852325, 0.00037569741834886372, 0.00024574116105213761, 0.00018743006512522697, 6.2973318563308567e-05, 0.00019784370670095086, 0.0002021321706706658, 0.000215327920159325, 0.00039698707405477762, 0.00024180056061595678, 0.00015619375335518271, 0.00021772690524812788, 0.00012553442502394319, } };
const TfLiteAffineQuantization quant33 = { (TfLiteFloatArray*)&quant33_scale, (TfLiteIntArray*)&g0::quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data34[1*3*3*96] = { 
  /* [0][0][][] */ -50,-71,-11,127,22,75,81,-57,-16,-18,-15,-5,-30,3,37,1,-7,-43,27,21,18,-127,127,8,-83,12,51,-29,-123,-127,38,24,11,31,60,-18,-28,-12,31,-6,-15,27,-109,73,24,-69,38,46,-18,50,-24,19,3,-6,14,48,-88,-49,-65,-18,-12,0,10,38,68,-26,72,12,-8,19,19,127,25,22,26,-3,-10,18,127,-4,-16,13,-27,19,126,22,-74,-16,-1,-32,-16,-42,1,-27,-16,24, 127,-127,77,104,-42,127,38,-115,66,3,-17,127,127,-99,-14,14,10,127,127,-113,127,-76,80,67,-127,-117,-64,-34,-54,47,-61,-21,-91,51,-127,-84,-42,-17,-54,64,-1,127,127,83,-52,-115,-113,-51,-15,-127,42,82,67,-32,42,82,-45,43,-85,-112,-45,-39,-62,67,72,-63,27,30,-81,32,-18,92,118,127,13,23,3,59,-33,52,64,127,127,-22,-7,74,-108,127,-116,-98,4,-127,-90,-127,-39,103, -76,-13,32,-81,14,-24,67,-7,77,-33,-27,18,-20,-6,-8,-12,-7,-15,8,-6,-20,-102,31,0,-121,106,7,-54,118,50,-16,8,0,13,13,-29,-7,32,20,15,26,12,-120,66,18,-18,36,13,-15,10,-17,4,-11,1,-4,20,-68,6,-39,52,1,42,35,0,-7,-40,-30,22,10,3,-4,37,11,-27,-5,4,-10,-5,-85,3,-23,-23,-15,3,-108,13,-33,-22,-49,25,-26,-34,29,-25,-15,0, 
  /* [0][1][][] */ -68,-74,78,-33,-48,95,27,127,-53,-22,-1,-118,27,-112,78,31,-1,-59,-17,88,54,-83,49,50,-103,-9,127,-22,-24,63,124,-103,-127,91,-85,-56,-34,32,-29,101,-49,-27,-5,45,-49,127,-24,66,15,95,19,-1,17,-54,26,31,127,124,-76,-84,127,-32,-35,127,71,-38,-16,0,127,39,127,96,-40,101,-4,8,15,16,-34,12,-45,120,-79,113,4,38,-56,31,78,-127,-33,-7,127,-69,-23,-1, 67,126,61,-110,127,81,95,39,-127,127,127,-38,-66,-127,-127,127,127,-63,-124,-51,107,93,-120,127,-112,-96,-43,127,-127,110,-127,-127,-91,127,106,127,127,-127,-108,127,-66,-97,110,-127,-127,-37,-127,-127,127,-110,85,43,127,127,127,-127,101,-127,-127,127,20,-78,-127,-98,-127,127,-127,127,-124,-127,-109,-83,-127,-81,127,127,-127,127,-80,127,127,31,-44,-127,61,127,94,48,127,11,127,0,-68,34,127,-127, -56,-13,-47,39,-56,-97,44,-25,17,-34,-27,93,2,96,14,13,-2,63,-7,126,5,-97,-38,7,-80,106,-73,-19,-66,-16,16,-62,-70,38,3,-17,-27,44,-67,48,127,-6,-40,29,-39,-58,17,46,8,117,-11,6,-34,-72,2,18,92,3,-6,22,-36,127,94,-51,-44,14,38,-11,-78,122,-20,-85,1,-54,-16,-24,29,19,74,-36,-71,-40,58,15,-44,-10,71,24,17,61,-44,15,-44,97,-26,-7, 
  /* [0][2][][] */ -72,3,-4,-18,13,-46,63,25,53,-31,-36,-1,17,23,-27,1,-8,66,7,2,-53,-85,3,-12,-21,-58,36,-68,87,38,25,25,16,-11,-11,-47,-8,37,-3,3,-15,-8,-69,101,3,30,11,38,-15,-26,9,-20,26,-1,7,13,-69,26,-17,14,16,1,-24,-3,0,-47,-48,16,-31,14,25,29,14,-22,27,6,18,9,-80,-10,-8,-10,15,17,-127,6,12,-43,-56,-48,-28,-43,8,56,-18,-9, 119,34,-127,-33,-71,-23,38,30,-66,-29,-20,-108,-78,115,-14,37,2,-52,-9,-127,95,-54,-37,-2,-120,127,-52,21,-35,-21,-9,-6,-64,9,26,7,-25,-29,127,58,12,-15,67,-36,-38,75,-69,-42,-32,-5,-127,-127,-45,-25,1,38,-64,-7,10,40,-5,-16,8,-46,-52,33,62,-22,116,108,-25,-71,13,-59,4,5,100,7,51,23,12,-98,-49,2,4,11,127,39,-59,37,-20,-109,40,77,-11,23, -59,13,-16,28,15,-67,-127,3,-12,-9,-16,4,14,-22,19,0,-7,-17,5,17,-44,-77,17,0,23,-97,18,4,-49,-38,-8,15,42,-25,-7,-25,-35,3,43,-41,24,-3,-49,-30,3,67,23,17,-9,-1,9,-10,22,6,-5,-6,-63,-13,-6,-36,-11,12,88,-9,35,-2,-1,29,1,6,-4,20,-17,14,-2,17,38,5,76,-12,5,-7,-6,-18,75,3,40,-38,58,40,-18,-51,-8,2,-15,-14, 
};
const TfArray<96, float> quant34_scale = { 96, { 0.0048876404762268066, 0.0038243515882641077, 0.0045815114863216877, 0.0090203005820512772, 0.0091366712003946304, 0.0074884607456624508, 0.0031026836950331926, 0.0037246420979499817, 0.010355355218052864, 0.0066334716975688934, 0.010470420122146606, 0.0051013026386499405, 0.011205930262804031, 0.0086651928722858429, 0.016735946759581566, 0.0066806841641664505, 0.0094535546377301216, 0.0061882180161774158, 0.0078218840062618256, 0.0026475705672055483, 0.0026537957601249218, 0.0021526054479181767, 0.0059655881486833096, 0.0035932553000748158, 0.003898912575095892, 0.0036705469246953726, 0.0070235300809144974, 0.0073964116163551807, 0.0035793452989310026, 0.02062041312456131, 0.015259061008691788, 0.010480139404535294, 0.0047406461089849472, 0.006642115768045187, 0.0097334254533052444, 0.019179686903953552, 0.015481462702155113, 0.0096170250326395035, 0.0097271539270877838, 0.0045775454491376877, 0.0087934741750359535, 0.0091107292100787163, 0.013551407493650913, 0.0045182188041508198, 0.014956069178879261, 0.0042784255929291248, 0.0041733304969966412, 0.012873013503849506, 0.028577413409948349, 0.0047017517499625683, 0.019579142332077026, 0.0080384146422147751, 0.0077378111891448498, 0.0062108058482408524, 0.0093487342819571495, 0.0052420175634324551, 0.0072601460851728916, 0.016372526064515114, 0.0020110260229557753, 0.0067694731988012791, 0.013083228841423988, 0.01486075296998024, 0.0049493638798594475, 0.0067954109981656075, 0.005644617136567831, 0.0053599588572978973, 0.011525045149028301, 0.013406251557171345, 0.0084307203069329262, 0.0045675495639443398, 0.0083355884999036789, 0.0041406773962080479, 0.012592848390340805, 0.0060904235579073429, 0.011050742119550705, 0.01237091887742281, 0.0060804993845522404, 0.0037087602540850639, 0.0020524668507277966, 0.0070783710107207298, 0.0080187413841485977, 0.0098350020125508308, 0.0068321092985570431, 0.010952077805995941, 0.00196649762801826, 0.0048598647117614746, 0.0032824412919580936, 0.020689468830823898, 0.013779044151306152, 0.0049616540782153606, 0.014527955092489719, 0.0016261738492175937, 0.0069617214612662792, 0.0048627033829689026, 0.013685001991689205, 0.011341504752635956, } };
const TfLiteAffineQuantization quant34 = { (TfLiteFloatArray*)&quant34_scale, (TfLiteIntArray*)&g0::quant26_zero, 3 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data35[96] = { 21453, 62942, -2357, -1417, 15616, -4652, -260, -155, 7030, 15174, -4814, -885, 1032, 3365, 5315, -8932, -4167, -789, -723, 17324, -12675, 20035, -3063, 8562, 34642, -142, -5384, 17576, 15597, -19745, 1992, 22291, 24387, -10202, 2597, 65, -759, 485, 3932, -7970, -5472, 558, -9106, -13, 29937, -1257, 12216, -1951, -14735, 1133, -39, 16, -2974, 19142, -3854, 14218, 16371, -568, 38456, -381, -8723, -950, 1429, -312, -1763, 14236, -841, -7018, -3250, 2770, 119, -3819, 361, 758, -2703, -6540, -986, -2499, 53812, -7867, -5966, -11466, -411, -85, 76009, -13463, -10932, -28035, -5588, 9192, -2455, 30374, 810, -1972, -3032, 1829, };
const TfArray<96, float> quant35_scale = { 96, { 0.00011500330583658069, 8.9984743681270629e-05, 0.00010780027514556423, 0.00021224237571004778, 0.00021498050773516297, 0.00017619908612687141, 7.3004324804060161e-05, 8.763864025240764e-05, 0.00024365542049054056, 0.00015608168905600905, 0.00024636281887069345, 0.00012003065057797357, 0.00026366894599050283, 0.00020388689881656319, 0.00039378699148073792, 0.00015719256771262735, 0.00022243658895604312, 0.00014560513955075294, 0.00018404432921670377, 6.2295781390275806e-05, 6.2442253693006933e-05, 5.0649541663005948e-05, 0.00014036678476259112, 8.4547187725547701e-05, 9.1739122581202537e-05, 8.6365813331212848e-05, 0.00016525953833479434, 0.00017403322272002697, 8.4219893324188888e-05, 0.00048518620315007865, 0.00035903672687709332, 0.00024659151677042246, 0.00011154461390106007, 0.00015628508117515594, 0.0002290217817062512, 0.0004512867599260062, 0.00036426971200853586, 0.00022628295118920505, 0.00022887421073392034, 0.00010770695371320471, 0.00020690527162514627, 0.00021437009854707867, 0.00031885664793662727, 0.00010631103214109316, 0.00035190751077607274, 0.00010066883987747133, 9.8196011094842106e-05, 0.00030289444839581847, 0.00067240971839055419, 0.00011062945850426331, 0.00046068569645285606, 0.00018913917301688343, 0.00018206615641247481, 0.00014613660459872335, 0.00021997022849973291, 0.00012334159691818058, 0.00017082697013393044, 0.00038523590774275362, 4.7318259021267295e-05, 0.00015928172797430307, 0.00030784067348577082, 0.00034966476960107684, 0.00011645562335615978, 0.00015989202074706554, 0.0001328145299339667, 0.0001261166762560606, 0.00027117753052152693, 0.0003154412261210382, 0.00019836988940369338, 0.00010747175838332623, 0.00019613149925135076, 9.7427706350572407e-05, 0.00029630231438204646, 0.00014330408885143697, 0.0002600174630060792, 0.00029108044691383839, 0.00014307057426776737, 8.7264947069343179e-05, 4.8293339204974473e-05, 0.00016654991486575454, 0.00018867627659346908, 0.00023141181736718863, 0.0001607555168448016, 0.00025769596686586738, 4.6270532038761303e-05, 0.0001143497574958019, 7.7233911724761128e-05, 0.00048681104090064764, 0.00032421280047856271, 0.0001167448062915355, 0.00034183423849754035, 3.8262915040832013e-05, 0.00016380521992687136, 0.0001144165507867001, 0.00032200006535276771, 0.00026685892953537405, } };
const TfLiteAffineQuantization quant35 = { (TfLiteFloatArray*)&quant35_scale, (TfLiteIntArray*)&g0::quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data36[16*1*1*96] = { 
  /* [0][0][][] */ -21,-12,-1,-26,18,-10,-39,-5,22,7,-10,5,-9,-6,-17,7,0,9,0,-5,13,-33,4,-2,7,11,1,127,37,-36,44,-12,-5,5,3,-2,-15,16,-45,2,-9,11,2,35,1,10,17,3,26,5,-8,10,7,-23,-11,81,-7,6,-29,-40,-4,27,-2,-28,-44,-65,-18,45,7,4,19,-17,-9,-34,0,-21,-29,21,-1,9,-6,-24,28,22,0,-9,-13,-94,6,-15,6,-5,48,-37,-32,-10, 
  /* [1][0][][] */ 35,-66,-73,-54,127,-6,75,21,-23,-86,-55,-18,12,-4,-55,46,-62,12,50,52,11,34,-14,-43,10,-10,-20,-56,42,-12,-70,36,-25,52,-13,-10,12,-12,30,32,-27,31,-34,-30,-38,89,-6,-4,20,-85,4,-36,-18,43,52,21,-69,-26,-30,-34,11,-6,-11,-31,-67,92,-20,-30,-8,-14,-16,17,50,-111,-31,-2,31,-52,29,2,6,-17,28,-6,-48,23,-16,34,42,-38,2,5,50,14,27,116, 
  /* [2][0][][] */ -5,56,-91,-25,66,82,19,68,2,-127,-30,-11,11,-10,25,21,16,-19,-27,67,30,-22,102,34,38,47,-4,-73,33,-15,63,-76,21,38,-24,40,-121,-80,31,59,-4,-64,-3,-18,-4,-25,14,87,-46,35,-37,-10,108,-19,-10,61,25,30,35,-8,3,35,43,-25,29,-16,-31,3,-69,19,-14,-6,-54,-64,-1,43,72,44,26,-2,14,-70,22,-6,-28,18,-3,25,-22,11,6,-36,-1,-35,-62,5, 
  /* [3][0][][] */ 71,12,102,-17,53,-30,9,-10,-37,-56,6,-43,3,30,25,102,14,-20,35,13,116,0,43,26,54,-11,-18,11,24,37,-7,88,-86,21,25,-11,-32,-24,-21,26,-83,-45,60,13,27,57,-49,-80,-60,-42,-60,36,6,-127,18,26,-87,56,73,45,11,88,-3,-51,23,66,-17,-58,6,-7,-4,-66,55,-42,46,-32,20,-7,57,40,-49,-76,6,-6,-32,10,29,34,12,2,25,62,22,108,28,-51, 
  /* [4][0][][] */ 35,-18,26,-17,127,45,-16,-29,-37,-53,-38,-35,-57,19,-5,38,18,-74,-45,85,-6,-13,33,-24,-10,-2,6,-49,-4,-20,51,-49,83,-8,-31,16,31,0,6,10,-38,-23,-28,-12,-12,-60,-19,8,22,3,-31,-12,-18,-34,0,-21,31,-17,-33,27,-8,51,60,13,51,39,-21,-13,-56,-18,41,62,25,-76,-55,-21,37,25,88,-36,5,-42,2,-14,-81,-1,45,45,-56,27,1,-54,6,1,26,-38, 
  /* [5][0][][] */ -6,-8,-16,27,29,-17,51,-20,-13,-39,-8,17,6,27,7,26,-2,-9,19,-7,33,28,-42,81,29,-17,20,-93,7,33,16,32,-10,17,13,-52,29,36,10,-2,11,10,20,-24,8,-7,7,-9,-7,-9,6,2,-1,-26,-14,-46,-26,21,-39,13,75,25,-13,42,-6,54,8,75,5,102,19,35,3,19,11,73,-37,3,14,7,-17,-8,3,11,-4,28,-18,127,4,32,6,-25,8,18,-61,27, 
  /* [6][0][][] */ 15,-70,15,-18,-23,7,45,23,14,1,-10,-64,-28,2,-22,40,27,-8,3,-8,-42,46,7,13,-11,-8,-12,2,-8,16,38,3,63,26,66,0,-1,0,35,-93,-9,99,5,-38,17,-18,-16,18,-5,43,-22,80,-21,-60,-5,-8,-9,-63,-14,-2,-5,64,29,-72,29,-27,13,-17,-3,13,127,-1,-47,9,-23,31,-87,7,12,9,28,47,18,-7,-19,6,33,27,16,15,49,-29,-14,5,-36,-2, 
  /* [7][0][][] */ -9,127,37,27,111,41,52,-30,-18,-29,44,-8,-12,29,41,39,24,-31,7,25,34,-16,30,14,7,7,12,12,30,-14,18,22,38,10,-40,-6,25,24,8,82,-32,44,18,13,-14,-25,32,-11,-17,-16,32,25,19,-42,-27,42,27,18,-24,-4,-1,-33,-7,1,-56,73,-21,-76,-7,-18,4,57,-19,-24,24,18,45,73,33,-8,-52,-29,-10,-8,-8,58,-13,0,-24,31,-32,-27,-46,-7,17,11, 
  /* [8][0][][] */ -16,8,61,41,-119,-26,64,-7,41,97,76,15,-14,14,35,18,-34,2,11,4,-45,9,-127,81,30,-48,79,8,18,18,-7,59,76,-8,6,-4,-15,-5,36,33,41,-15,35,10,-21,6,38,13,-105,20,14,43,-62,-17,-36,61,-16,-52,-108,-8,25,-33,-45,1,14,80,-7,-58,25,-21,-51,-25,38,58,63,-1,-14,-17,-10,8,-97,16,-31,-17,17,32,73,47,36,-23,62,41,11,10,48,18, 
  /* [9][0][][] */ 32,-127,-26,1,91,94,-53,-62,24,-48,85,90,-29,14,83,-109,-1,-24,-13,16,-51,-80,43,-16,-60,34,-19,23,-41,4,-7,-15,27,-2,-113,50,-3,-9,-40,59,-1,-92,-17,81,-9,-30,-86,-56,14,15,-15,-119,57,34,-15,-52,19,75,6,2,6,-81,-18,115,-85,-25,-7,-28,-5,17,-77,-81,48,-15,-24,18,78,-94,28,3,17,-34,8,31,-9,-84,30,-14,1,-42,-64,34,-57,-28,-4,-54, 
  /* [10][0][][] */ -61,-13,-35,-34,-20,-10,73,-12,38,28,37,35,35,-7,0,7,7,16,-24,-20,-9,47,12,21,4,-22,14,-127,34,-41,60,-28,2,29,1,-15,-2,46,14,-4,27,-24,24,-57,18,-1,32,21,5,49,-24,-2,-35,-24,-2,-57,6,16,-12,-40,33,19,-7,15,-38,97,-12,-23,19,-17,6,-20,-33,-3,30,65,-13,58,-23,17,-31,4,5,20,12,-10,-11,121,4,2,12,21,23,-29,36,-31, 
  /* [11][0][][] */ -110,34,-4,24,26,-72,-3,14,-50,14,3,22,34,31,-16,13,55,-8,-67,-45,0,12,-17,10,100,-10,83,17,-23,30,-47,32,-6,40,-2,-14,-2,20,52,4,9,13,-6,1,108,21,68,20,69,41,-19,65,13,-59,29,1,-91,-8,-48,-41,1,-3,-16,29,-17,-21,25,6,29,11,-2,33,-35,16,44,14,-26,103,-127,66,-56,1,-79,-87,124,34,43,-9,11,63,-25,-55,-26,60,-26,3, 
  /* [12][0][][] */ 13,-17,-35,-14,47,26,-16,-22,-17,7,8,-13,-6,-27,22,-31,-41,-5,7,-11,-9,-42,-29,36,-44,57,-27,82,-32,26,-35,-11,-12,13,-3,29,-24,-37,-7,16,-26,-30,-8,13,-29,2,14,10,-20,-15,0,-51,-14,8,-12,-13,18,-18,33,21,-25,-33,12,30,40,-83,9,48,-36,-127,-12,49,11,-5,-9,62,14,-30,-1,-4,4,14,-41,6,4,-30,2,-54,-16,2,4,-2,-41,25,-11,17, 
  /* [13][0][][] */ -73,64,-4,-4,-52,11,-16,10,-31,-22,42,20,75,14,-32,0,-7,27,-48,-6,20,-8,47,-44,67,29,10,12,12,-31,-37,-95,-79,-19,-4,18,-5,27,35,-31,-28,72,0,15,49,-8,-10,-1,54,-21,29,67,67,-49,81,-6,-37,36,35,8,11,23,-16,18,7,-25,2,-11,5,21,11,-127,10,-35,-73,8,50,37,-37,-39,81,-12,-1,-31,31,-24,88,5,-29,-2,-17,14,36,-41,-20,12, 
  /* [14][0][][] */ -19,11,-19,-69,20,3,-24,21,-97,-3,7,7,-37,-70,-90,-40,-100,-10,71,13,34,-20,25,-115,-60,34,-60,-32,4,-26,-7,-38,-66,-41,16,20,-23,-18,-10,6,-15,67,-79,-6,-67,22,6,4,127,-35,28,-29,36,56,-105,22,-1,25,-95,12,-1,21,57,22,7,25,-5,0,-57,18,55,35,43,-19,-43,7,62,-92,-28,-105,21,-42,15,52,32,-85,-41,2,-47,11,28,56,13,28,20,-23, 
  /* [15][0][][] */ -48,-74,-17,-31,13,6,0,-63,-27,28,-1,-41,42,-6,43,-10,-90,-18,-13,7,-10,15,-76,-47,-4,-10,5,26,-17,-16,72,-94,-2,32,30,10,-5,31,-104,7,42,-68,9,23,-22,-51,66,33,62,20,-8,-127,-15,53,3,36,28,-14,-22,46,12,1,39,-5,-7,1,-20,-4,-16,21,14,35,-47,7,5,-41,-39,-15,4,17,0,47,-6,72,-15,-37,-38,-29,-60,71,32,89,-42,0,6,-18, 
};
const TfArray<16, float> quant36_scale = { 16, { 0.035623945295810699, 0.019144745543599129, 0.0085261892527341843, 0.0090232538059353828, 0.018747176975011826, 0.015478956513106823, 0.016771852970123291, 0.013986407779157162, 0.012983343563973904, 0.0096224993467330933, 0.028194976970553398, 0.023702198639512062, 0.016941135749220848, 0.010522728785872459, 0.020756825804710388, 0.017341857776045799, } };
const TfLiteAffineQuantization quant36 = { (TfLiteFloatArray*)&quant36_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data37[16] = { -7413, 13627, -10110, -4842, -1114, 5751, 20859, -55358, -11856, 27506, 19291, 5902, -1305, 9814, 666, 8694, };
const TfArray<16, float> quant37_scale = { 16, { 0.00083821051521226764, 0.00045046460581943393, 0.00020061622490175068, 0.00021231186110526323, 0.00044111005263403058, 0.00036421074764803052, 0.00039463184657506645, 0.00032909194123931229, 0.0003054904518648982, 0.00022641175019089133, 0.00066341122146695852, 0.00055769877508282661, 0.00039861496770754457, 0.00024759361986070871, 0.00048839591909199953, 0.00040804370655678213, } };
const TfLiteAffineQuantization quant37 = { (TfLiteFloatArray*)&quant37_scale, (TfLiteIntArray*)&g0::quant2_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data38[96*1*1*16] = { 
  /* [0][0][][] */ -41,82,-11,-127,-58,-29,-43,-88,-14,9,11,99,24,-61,-2,57, 
  /* [1][0][][] */ -29,33,-51,-13,-25,-42,41,-92,53,68,-72,9,7,-1,36,-127, 
  /* [2][0][][] */ -8,15,-56,43,23,34,-48,-48,127,-66,13,42,-3,85,-55,14, 
  /* [3][0][][] */ 57,-78,20,-118,6,-29,-21,-20,112,-15,90,64,-16,41,28,127, 
  /* [4][0][][] */ -76,52,26,42,20,-18,6,44,8,19,22,-27,-127,-12,-20,26, 
  /* [5][0][][] */ 27,57,127,-1,21,72,-77,77,-62,83,-31,-40,52,-42,-124,38, 
  /* [6][0][][] */ 25,-79,115,-127,31,12,-53,107,-71,-121,70,-25,-5,107,-13,80, 
  /* [7][0][][] */ 45,124,-16,-84,108,4,4,-61,127,111,-39,9,30,-37,58,54, 
  /* [8][0][][] */ 15,-75,18,-89,30,-58,13,-67,15,68,66,-23,18,127,82,64, 
  /* [9][0][][] */ 6,-33,-9,127,40,0,49,-57,-50,97,33,-11,-7,-50,-16,-15, 
  /* [10][0][][] */ -9,19,-52,-127,8,8,-12,37,44,-44,26,-21,-22,-37,-2,33, 
  /* [11][0][][] */ 6,16,39,-30,85,-37,92,-62,-97,43,-4,25,0,127,-68,-25, 
  /* [12][0][][] */ 108,-9,-116,-28,51,-59,30,22,9,67,-85,-60,-40,127,-12,59, 
  /* [13][0][][] */ -13,9,-22,5,7,-127,-3,13,2,-6,4,-6,13,-13,6,14, 
  /* [14][0][][] */ 38,-47,108,-42,71,5,-127,-101,-12,-64,41,36,10,-63,-27,-33, 
  /* [15][0][][] */ -68,22,-21,-33,-2,5,127,61,-30,25,69,-10,24,63,50,1, 
  /* [16][0][][] */ 8,55,127,103,-23,32,89,78,-78,0,-59,7,4,21,11,-92, 
  /* [17][0][][] */ -34,-100,-9,23,-65,-27,-58,15,-127,-25,10,-51,-1,35,55,-31, 
  /* [18][0][][] */ 1,51,14,65,56,3,20,0,70,50,-35,-38,24,127,62,29, 
  /* [19][0][][] */ 28,-40,50,4,81,-2,-84,-62,-106,-64,-47,-127,-25,-45,11,-26, 
  /* [20][0][][] */ 94,-23,-45,-46,25,-127,8,25,-79,55,-126,-36,17,-7,14,14, 
  /* [21][0][][] */ 102,3,87,-20,7,-7,4,127,-6,-99,67,31,16,123,15,92, 
  /* [22][0][][] */ -33,22,-51,127,-77,18,83,52,8,22,2,62,-15,20,40,1, 
  /* [23][0][][] */ 36,44,72,-89,47,30,-30,75,19,-16,34,2,-25,-40,-127,-6, 
  /* [24][0][][] */ -127,37,20,-24,2,117,32,-11,-6,0,118,1,-87,25,63,-27, 
  /* [25][0][][] */ 21,25,11,29,9,11,59,-55,-1,-127,-10,-14,-10,-26,18,16, 
  /* [26][0][][] */ -32,5,8,3,-39,-15,-34,-30,-116,-28,-3,-44,10,127,-44,63, 
  /* [27][0][][] */ -11,25,3,68,34,-28,-19,-35,59,4,-23,4,6,127,-1,11, 
  /* [28][0][][] */ 25,57,71,53,127,-11,37,37,-92,-19,-51,-38,17,90,36,-29, 
  /* [29][0][][] */ 9,-11,12,12,25,-7,10,29,-27,-6,-21,-127,3,-18,-11,9, 
  /* [30][0][][] */ -13,87,-42,64,-35,-23,45,-127,-49,60,-22,-8,58,32,72,88, 
  /* [31][0][][] */ -56,-31,-21,-66,-4,31,-53,-116,36,75,2,-127,-47,-69,4,23, 
  /* [32][0][][] */ -127,-92,-6,63,45,31,-9,3,-3,-55,-109,58,71,4,62,75, 
  /* [33][0][][] */ -8,-24,-37,-17,-75,-8,-74,15,60,24,10,-56,32,-127,117,36, 
  /* [34][0][][] */ 43,-12,59,27,39,25,-54,83,-81,-55,77,28,6,-5,-12,127, 
  /* [35][0][][] */ -47,36,-85,11,-41,0,31,-108,95,54,-46,27,-10,2,58,-127, 
  /* [36][0][][] */ -39,22,1,127,12,33,120,21,-1,26,-15,4,-17,36,-52,-58, 
  /* [37][0][][] */ -7,-21,1,-68,-9,7,-43,-59,-71,-22,11,2,-5,-127,73,-45, 
  /* [38][0][][] */ 56,83,-1,-46,127,-9,33,-37,104,82,-30,-10,27,-31,57,19, 
  /* [39][0][][] */ -39,49,-20,-127,-29,12,-51,26,51,-82,-20,-13,8,80,52,24, 
  /* [40][0][][] */ -17,-46,9,-112,-17,0,-16,-51,-127,-15,4,-16,-25,-126,113,-89, 
  /* [41][0][][] */ -8,-16,-43,-25,-4,-12,19,-4,-19,2,-27,4,-127,14,18,23, 
  /* [42][0][][] */ 127,102,-30,-12,-72,-43,-24,-52,6,28,84,-57,-65,53,91,-123, 
  /* [43][0][][] */ -30,127,-104,14,46,-17,116,-47,65,79,-39,11,34,-124,-78,-70, 
  /* [44][0][][] */ -12,-12,22,-50,64,-4,-81,-127,-25,1,5,-5,-3,-39,59,-49, 
  /* [45][0][][] */ 6,66,-127,-58,45,-84,15,-71,-5,50,-7,-109,27,-31,50,-7, 
  /* [46][0][][] */ 4,-8,-24,-89,-19,16,17,-34,-119,-29,15,21,-13,-127,78,-37, 
  /* [47][0][][] */ 18,51,23,-10,127,-9,-25,19,-55,41,-1,18,10,0,106,-25, 
  /* [48][0][][] */ -127,-68,-18,28,76,10,12,-19,-8,-9,-119,33,71,3,77,60, 
  /* [49][0][][] */ 8,16,97,72,116,-8,46,31,-127,-41,-39,-84,18,112,23,-45, 
  /* [50][0][][] */ 9,-14,-121,26,62,-127,-48,-7,-9,8,-13,-80,50,-7,-3,0, 
  /* [51][0][][] */ -2,48,45,23,36,15,6,38,-127,54,15,-109,7,-119,-34,94, 
  /* [52][0][][] */ 3,45,-9,59,34,1,23,33,71,75,-22,-43,34,127,63,12, 
  /* [53][0][][] */ -4,-51,-18,-16,-87,-15,-89,2,43,24,14,-59,27,-114,127,16, 
  /* [54][0][][] */ 68,-21,-36,-10,123,77,-127,-47,-101,5,-45,-101,4,-55,-6,-31, 
  /* [55][0][][] */ 39,-3,-1,11,40,-31,-78,-127,-32,-70,-53,11,-9,-32,29,-7, 
  /* [56][0][][] */ -13,10,26,-26,-6,-28,-89,59,-14,127,-6,-18,26,2,-4,8, 
  /* [57][0][][] */ 10,41,-42,-26,-50,-56,127,92,-40,40,-23,-16,39,18,122,-1, 
  /* [58][0][][] */ 44,11,-127,34,65,95,-31,27,-91,-39,-2,11,-19,23,0,-18, 
  /* [59][0][][] */ -108,66,101,30,-85,-63,125,127,26,2,36,-11,16,17,77,-3, 
  /* [60][0][][] */ -5,-8,-55,1,15,-127,-29,-11,-7,-20,2,-19,20,-17,4,5, 
  /* [61][0][][] */ 28,-11,35,127,87,24,33,15,-106,2,16,35,-17,25,28,-55, 
  /* [62][0][][] */ -44,127,19,-61,-32,-13,-68,53,-28,-60,-90,-62,-9,-108,-55,-35, 
  /* [63][0][][] */ -43,33,-26,127,-76,12,-65,-32,-65,-19,-24,-44,24,64,34,35, 
  /* [64][0][][] */ 13,3,7,42,7,8,-17,78,32,7,-17,-52,-8,-127,55,-4, 
  /* [65][0][][] */ -20,-44,2,-127,28,-42,42,-42,-2,40,15,-100,-20,8,28,-49, 
  /* [66][0][][] */ 20,-37,49,-6,-8,7,-9,87,13,-72,44,41,5,127,34,63, 
  /* [67][0][][] */ 7,56,-4,-127,-4,-7,-54,37,72,-84,-34,-14,30,71,61,40, 
  /* [68][0][][] */ -26,29,127,13,13,-6,-3,-2,-49,-14,-27,-46,19,-19,90,-26, 
  /* [69][0][][] */ 127,87,-10,6,-68,-48,-22,-32,-1,30,76,-64,-51,63,56,-92, 
  /* [70][0][][] */ 33,1,-58,-4,-32,31,59,127,-28,83,-31,14,7,66,-29,12, 
  /* [71][0][][] */ 10,5,-3,6,9,-76,2,25,-45,24,-85,-3,-127,-7,38,48, 
  /* [72][0][][] */ 5,12,-127,20,2,14,23,80,-33,-32,12,-1,17,20,0,4, 
  /* [73][0][][] */ -49,28,41,-1,54,-41,-66,-127,15,-64,30,-27,11,-52,28,-19, 
  /* [74][0][][] */ 3,38,42,127,25,-15,-83,86,-75,25,-55,37,27,-125,34,-94, 
  /* [75][0][][] */ 0,59,-49,1,30,-12,32,-9,127,36,-24,-15,26,122,-62,11, 
  /* [76][0][][] */ -7,-10,-5,23,1,-12,-19,63,18,-31,-17,-127,-2,-5,11,12, 
  /* [77][0][][] */ -13,27,-23,127,-45,26,73,95,22,29,1,45,-16,-8,-14,-12, 
  /* [78][0][][] */ 0,-21,14,-118,23,-16,-29,32,36,-69,23,-15,20,127,31,40, 
  /* [79][0][][] */ -18,-104,-66,-65,-85,-4,30,-71,127,17,25,63,7,52,43,-56, 
  /* [80][0][][] */ -24,7,127,-87,21,-38,13,-80,-72,48,-45,-108,31,80,71,-34, 
  /* [81][0][][] */ -59,59,-125,26,73,-127,-20,62,-12,-42,65,-13,28,-2,7,-7, 
  /* [82][0][][] */ 127,-13,8,0,17,-111,-23,15,-24,-11,-100,-10,87,3,-10,35, 
  /* [83][0][][] */ -27,80,-105,-68,-26,-26,42,-114,54,60,-56,-127,30,52,46,94, 
  /* [84][0][][] */ -25,48,88,-44,17,-20,63,-127,-54,61,-21,-80,34,45,60,6, 
  /* [85][0][][] */ -90,127,16,-110,-80,-27,-28,-8,-51,-9,-64,30,8,-11,-87,-33, 
  /* [86][0][][] */ -3,9,-28,6,-26,-20,127,26,20,-35,6,24,8,38,61,-25, 
  /* [87][0][][] */ -16,-33,7,-109,11,-36,40,-15,-11,23,-16,-127,-10,-2,6,-31, 
  /* [88][0][][] */ 100,-30,53,-29,25,-124,-9,16,-43,45,-127,-69,37,43,76,7, 
  /* [89][0][][] */ 25,-26,-47,-66,33,-18,-39,-16,-59,19,39,-97,127,-8,29,-44, 
  /* [90][0][][] */ -12,-63,27,-52,58,2,-69,77,63,-77,-26,-13,-15,116,24,-127, 
  /* [91][0][][] */ -54,-14,-32,-46,13,-17,-37,-107,16,59,-2,-127,-41,-13,9,6, 
  /* [92][0][][] */ -24,11,37,24,0,-127,15,-2,3,-23,0,-12,5,-16,23,5, 
  /* [93][0][][] */ 46,-26,127,-9,-54,39,17,-43,-45,34,-91,-36,-11,-3,36,19, 
  /* [94][0][][] */ 29,0,-13,-23,21,-6,-21,-7,-33,-20,16,-60,127,-9,36,-31, 
  /* [95][0][][] */ 127,112,2,44,-106,-9,-84,2,-26,-29,122,-29,-59,35,93,-83, 
};
const TfArray<96, float> quant38_scale = { 96, { 0.0006072729011066258, 0.0010622465051710606, 0.00095222837990149856, 0.00072494236519560218, 0.00081202870933339, 0.0010777470888569951, 0.00035996086080558598, 0.0009166908566839993, 0.00053233344806358218, 0.00095661188242956996, 0.00046471942914649844, 0.00068920571357011795, 0.00062610505847260356, 0.0038004675880074501, 0.00044010192505083978, 0.00057942664716392756, 0.00035281694727018476, 0.00079010485205799341, 0.0010380398016422987, 0.00080028577940538526, 0.00033713135053403676, 0.00019419041927903891, 0.0003709289594553411, 0.0002899152459576726, 0.00045809120638296008, 0.0014917142689228058, 0.002110206987708807, 0.001009236671961844, 0.00056488753762096167, 0.0010937547776848078, 0.00055603659711778164, 0.00067117484286427498, 0.0005580453434959054, 0.00071319355629384518, 0.00081757240695878863, 0.00067959760781377554, 0.00043207843555137515, 0.00048266586964018643, 0.0010024418588727713, 0.00088804017286747694, 0.00031064511858858168, 0.0014332762220874429, 0.00074118300108239055, 0.00043972959974780679, 0.0011023705592378974, 0.00053845444926992059, 0.00062185514252632856, 0.00072082184487953782, 0.00072544073918834329, 0.00060780503554269671, 0.0006220567156560719, 0.00050913490122184157, 0.0012470127549022436, 0.0006160615012049675, 0.0008544627926312387, 0.00085473235230892897, 0.001315132831223309, 0.00084354431601241231, 0.0011362902587279677, 0.00049856543773785233, 0.0023741328623145819, 0.0011034972267225385, 0.00061763689154759049, 0.001118093729019165, 0.0015491835074499249, 0.00071689003380015492, 0.00025541862123645842, 0.00055055145639926195, 0.0012105543864890933, 0.0010226198937743902, 0.00062917411560192704, 0.00069172802614048123, 0.0020496645011007786, 0.00087325094500556588, 0.00072070368332788348, 0.00045226200018078089, 0.00072866282425820827, 0.00029003771487623453, 0.00026555720251053572, 0.00056141865206882358, 0.000412584631703794, 0.00045704719377681613, 0.00047824301873333752, 0.00052961386973038316, 0.00031202315585687757, 0.00079853105125948787, 0.0016500953352078795, 0.00055410916684195399, 0.00026058437651954591, 0.0011920048855245113, 0.0007205166039057076, 0.00060422683600336313, 0.00085767556447535753, 0.0011632890673354268, 0.00096095207845792174, 0.00040606790571473539, } };
const TfLiteAffineQuantization quant38 = { (TfLiteFloatArray*)&quant38_scale, (TfLiteIntArray*)&g0::quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data39[96] = { -3123, 4523, 7652, 3806, -3978, -4155, 28056, 2407, 3473, -2116, 12968, -277, -12427, 2282, 21268, 6147, 16062, 5613, -5691, -6383, 5681, 42451, 25168, 17521, 1332, 1002, 4312, 3243, 2865, -5456, 8101, -3568, -345, 4964, 29, 902, 13372, 6707, -1843, 6084, 12460, 5480, 6181, 16053, 5322, 5755, 2439, 9177, 5707, -6535, -7678, 501, -378, -1574, 2833, -90, 257, -920, -4086, 11245, -968, 1766, -1283, -2108, -3670, 8102, 25863, 2277, -2891, 1016, 1891, 2308, 2008, -1474, 744, 14650, -583, 19515, 20920, -1065, 11011, 2242, -474, 1534, 17852, 9102, 4323, 1722, 8118, 5224, -426, -10039, 764, -2646, -2022, -2903, };
const TfArray<96, float> quant39_scale = { 96, { 0.00019927443645428866, 0.0003485723864287138, 0.00031247033621184528, 0.00023788724502082914, 0.00026646431069821119, 0.00035365886287763715, 0.00011811986769316718, 0.00030080883880145848, 0.00017468331498093903, 0.00031390876392833889, 0.00015249602438416332, 0.00022616039495915174, 0.0002054541400866583, 0.0012471098452806473, 0.00014441787789110094, 0.00019013677956536412, 0.00011577561963349581, 0.00025927007663995028, 0.00034062904887832701, 0.00026261090533807874, 0.00011062844714615494, 6.3722894992679358e-05, 0.000121719014714472, 9.513465192867443e-05, 0.00015032099327072501, 0.00048950070049613714, 0.00069245690247043967, 0.00033117740531452, 0.00018536583229433745, 0.00035891172592528164, 0.00018246143008582294, 0.00022024362988304347, 0.00018312058818992227, 0.00023403191880788654, 0.00026828347472473979, 0.0002230075333500281, 0.00014178499986883253, 0.00015838508261367679, 0.00032894770265556872, 0.00029140722472220659, 0.00010193708294536918, 0.00047032447764649987, 0.00024321654927916825, 0.00014429570001084358, 0.00036173895932734013, 0.00017669190128799528, 0.00020405954273883253, 0.00023653511016163975, 0.00023805079399608076, 0.00019944904488511384, 0.00020412569574546069, 0.00016707080067135394, 0.00040920276660472155, 0.00020215837866999209, 0.00028038892196491361, 0.00028047736850567162, 0.00043155613820999861, 0.00027680606581270695, 0.0003728696028701961, 0.00016360246809199452, 0.00077906320802867413, 0.00036210866528563201, 0.00020267533545847982, 0.00036689845728687942, 0.00050835905130952597, 0.00023524490825366229, 8.3814709796570241e-05, 0.00018066148913931102, 0.00039723908412270248, 0.00033556905691511929, 0.00020646123448386788, 0.00022698807879351079, 0.00067259010393172503, 0.0002865541900973767, 0.00023649634385947138, 0.00014840815856587142, 0.00023910810705274343, 9.5174837042577565e-05, 8.7141648691613227e-05, 0.00018422752327751368, 0.00013538816710934043, 0.00014997839753050357, 0.00015693373279646039, 0.00017379090422764421, 0.00010238928371109068, 0.00026203511515632272, 0.00054147286573424935, 0.0001818289456423372, 8.5509833297692239e-05, 0.00039115213439799845, 0.0002364349493291229, 0.00019827487994916737, 0.00028144317911937833, 0.00038172915810719132, 0.00031533298897556961, 0.00013324973406270146, } };
const TfLiteAffineQuantization quant39 = { (TfLiteFloatArray*)&quant39_scale, (TfLiteIntArray*)&g0::quant26_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data40[32*1*1*96] = { 
  /* [0][0][][] */ 8,48,23,-89,-77,10,-8,57,-27,-45,-116,-85,-111,101,-59,58,32,79,6,-4,-44,-102,-43,20,81,-109,-5,97,51,-86,59,-7,-84,74,28,-69,-30,3,-102,-24,-103,-50,93,-73,56,-25,-90,93,-106,87,-88,16,-29,67,-4,41,-72,-91,-15,28,-22,79,30,-127,61,-115,-103,39,40,-89,-13,104,-60,22,-51,100,-53,-61,-35,-28,-111,44,55,20,-49,-70,-59,-55,20,31,27,51,-96,-97,-58,37, 
  /* [1][0][][] */ 58,-6,63,30,12,-74,-6,105,21,50,-84,60,-127,-110,17,-82,-60,-41,6,-32,93,76,-91,-77,21,-19,-38,-71,84,40,-30,-71,-104,-94,-98,-87,31,-73,-56,6,-2,100,-17,24,28,-6,-47,31,9,-110,-15,-45,-13,-122,-57,-110,39,33,78,3,48,-85,-43,-47,114,-20,-9,79,70,77,44,107,-10,11,46,27,64,-77,111,-30,-85,94,-74,71,25,13,-116,26,-59,-69,54,-39,-45,15,29,2, 
  /* [2][0][][] */ -1,-70,-88,-127,-40,5,66,-4,18,-53,-69,-56,49,71,-75,-118,-101,31,-47,27,-97,-57,24,19,-77,61,-48,-51,-30,-38,-87,28,54,-72,45,0,-83,16,-81,63,53,-38,107,71,-67,-23,45,21,-20,-69,18,84,-93,-79,-3,-84,-52,18,84,107,94,78,-68,102,106,85,-79,-84,-5,16,59,-27,31,18,-22,-74,89,109,-107,-63,-92,116,72,28,-77,32,38,26,66,73,81,114,-56,-39,74,86, 
  /* [3][0][][] */ -55,83,54,-66,97,86,67,63,92,21,37,-47,127,40,92,99,-99,65,-44,84,-58,67,-63,5,99,65,-82,19,48,31,-35,91,-76,26,25,-75,-75,-32,-67,-44,-72,-32,-51,21,-59,-84,-22,-25,-43,91,-13,-83,11,43,84,-57,-72,-81,61,-73,-66,31,-76,-20,8,77,-43,-25,-29,-32,74,6,76,74,-42,-59,-100,-41,71,-40,50,94,-63,-73,66,-94,87,-72,-27,-88,85,81,-70,-38,31,-23, 
  /* [4][0][][] */ -93,22,90,-13,60,11,-25,-42,16,62,-104,-53,-80,95,30,-101,85,37,-37,-88,-95,79,-117,-26,-30,-116,90,43,13,-122,115,28,-123,42,-53,-56,99,-20,-117,-100,106,96,-104,-105,-19,90,-42,-43,114,-32,110,112,90,-127,-4,36,-111,-34,108,-58,80,-34,-19,62,-60,30,-115,-81,14,93,34,-12,-61,-11,18,-69,-29,87,-39,23,31,-110,51,1,52,121,10,-66,-31,-13,102,46,95,-17,-113,-127, 
  /* [5][0][][] */ -101,114,-51,-65,21,-24,-45,67,-18,-88,59,43,-99,37,113,111,-115,124,100,-6,118,10,-53,115,-127,51,-34,-64,-24,37,69,5,-87,73,69,60,111,-59,-61,-41,85,-2,-13,-56,109,124,10,-6,25,115,78,58,-84,-46,55,-37,117,-48,-90,74,62,66,-3,64,78,-54,49,52,103,-68,43,10,-109,85,20,-90,-51,65,36,-30,84,107,-91,-41,55,-28,-99,-7,89,117,-42,114,-16,110,7,89, 
  /* [6][0][][] */ 124,-12,54,-71,-92,29,72,-68,11,57,46,127,51,-66,6,109,-41,77,75,37,-99,123,102,59,-46,73,-99,-56,-31,-115,1,8,-75,15,95,77,-72,-35,34,66,-75,41,70,27,-90,70,-71,-14,61,68,33,-23,-49,-110,-48,-59,-81,-21,39,89,43,-14,101,-28,96,78,3,54,-55,-84,-24,-33,77,-38,106,124,-50,71,-27,-56,17,-1,-25,-109,76,18,3,93,-14,-89,-51,-88,-79,-41,81,-64, 
  /* [7][0][][] */ 73,46,-55,-127,121,-22,-38,-60,25,-78,-17,-27,-31,108,92,58,74,-5,-3,55,71,-103,-16,-65,100,-83,57,113,-95,-22,-14,14,-110,-49,56,-34,114,-11,3,-110,-115,32,-67,78,6,-64,-98,-62,62,-43,-28,103,-40,34,56,24,57,-111,9,-112,15,-75,-51,-34,-7,-62,-116,-111,54,-113,-124,6,-105,66,-37,67,-74,-52,-81,31,-110,40,-1,75,-66,-86,-23,-83,44,112,112,-74,27,-91,87,-123, 
  /* [8][0][][] */ -61,-54,-108,-6,67,0,-19,-95,93,-108,127,-99,-44,-95,-115,-1,26,83,84,-84,104,66,102,-52,-72,-109,19,-97,-75,-88,-99,2,-56,0,-91,116,-112,-97,-47,-68,-17,28,48,-17,-7,-53,-20,100,67,90,-83,-19,121,22,-7,-100,4,-7,-37,23,-102,-18,-106,96,-15,-34,12,-63,-81,38,-104,58,43,80,120,94,99,-3,-9,-40,43,106,-2,70,78,-48,-22,79,65,65,-63,78,-106,117,122,-54, 
  /* [9][0][][] */ -37,-41,19,77,29,51,77,26,10,40,62,50,97,47,-36,-29,-16,-65,-70,-86,-96,75,16,-29,-73,-69,-51,45,56,-120,-37,45,-89,-68,109,-33,-36,-8,-76,-68,97,84,-3,-1,34,49,22,-27,-32,-50,-96,-69,-112,28,16,65,-12,-83,10,1,-8,-70,25,76,-127,69,65,60,92,-67,-113,9,43,22,59,-112,101,-72,8,-21,-119,-43,74,-87,51,-76,-92,12,-77,82,34,9,-89,14,19,65, 
  /* [10][0][][] */ -98,45,-81,-94,-40,87,-127,-108,81,-107,83,65,5,29,70,-9,108,12,-84,37,-14,-65,-45,81,39,106,-35,-29,-115,-78,-16,-115,76,34,109,-117,115,-88,41,113,82,26,30,55,-18,24,-7,-9,-88,116,111,107,98,-102,91,56,14,-11,92,-14,74,67,95,66,-42,102,-3,53,6,-13,71,24,-101,-107,25,55,67,97,76,31,-6,42,4,22,11,70,-86,22,-17,31,-56,95,48,66,17,-4, 
  /* [11][0][][] */ 59,61,-72,-97,84,-7,-41,-90,-90,54,39,-1,-12,-67,48,-70,-104,72,-25,-54,-38,-39,65,-74,-96,86,67,81,9,38,3,43,44,77,-120,-67,17,111,-65,-80,49,-102,100,-99,79,28,-100,-19,50,87,-127,93,62,-74,-39,-95,-14,73,-109,74,-44,5,106,-50,59,-24,88,-22,88,88,-39,24,-87,-53,20,-92,-6,73,-73,-26,-84,-28,-111,96,5,-73,-46,-21,-74,47,-62,-52,79,32,109,-2, 
  /* [12][0][][] */ -19,-14,-27,127,61,-15,-22,-55,-3,2,-9,42,-59,-74,-15,91,52,-23,18,73,-86,-1,83,64,39,91,-61,10,86,-65,68,54,47,-14,28,-45,36,-48,61,76,88,90,55,-38,39,-16,-19,84,-58,79,-56,45,-43,-70,68,36,-15,-58,-25,-42,22,1,121,-10,-59,5,30,-33,-91,-66,54,-21,-42,-44,15,5,-110,20,87,38,21,84,58,-31,63,-25,30,-66,-66,-70,25,6,-92,-88,-112,122, 
  /* [13][0][][] */ 33,38,42,-84,57,17,27,-58,25,-81,26,17,-51,88,28,64,66,59,-23,100,113,-22,-17,-76,54,-95,8,-83,29,-81,-38,11,-26,-87,0,-6,50,-95,56,29,-11,-57,66,73,51,1,53,61,-81,80,-94,16,-32,-74,12,88,51,-49,30,-68,-86,-30,68,-27,-63,41,-44,-113,-64,-59,-97,95,-68,-29,88,-36,-16,71,-16,-87,82,15,3,125,95,-43,-114,86,-36,-39,-5,-12,68,127,-8,-96, 
  /* [14][0][][] */ -43,-68,95,58,48,-87,21,-8,-7,69,-29,-67,-11,116,-26,40,-93,-31,-22,-110,-5,42,-52,-36,-47,-19,72,25,79,-92,80,-44,-56,99,123,25,32,78,-89,-92,112,124,120,27,83,-71,-2,-47,-113,9,-39,-66,-12,-124,95,-111,31,-97,-49,-101,-96,-108,24,-2,-12,68,9,-8,-119,-14,38,-63,-107,-79,51,-11,-90,-11,75,-16,127,-35,121,42,-77,-60,-66,82,59,-6,-70,-46,-17,-104,-74,-73, 
  /* [15][0][][] */ 16,51,-8,-80,-104,93,9,60,-126,-40,109,-42,-25,-60,-51,-44,-35,94,-126,20,-28,-95,-65,-29,-11,-15,105,110,-15,-81,-127,32,46,107,-56,-30,-32,107,-34,-104,-68,121,113,-66,86,58,-88,-98,24,-35,-52,-91,-86,-9,39,9,63,-28,75,-55,-124,-106,-106,-74,-45,33,-22,-90,-22,-83,-94,15,60,44,-3,87,-27,103,-114,-44,-26,-81,-54,-56,-54,-43,102,-36,66,-108,-97,113,-9,-50,112,-92, 
  /* [16][0][][] */ -13,20,-107,116,86,-73,97,104,-45,39,82,-76,-56,83,-127,-35,29,77,-62,-35,-125,-28,-111,10,108,-73,-85,19,-58,94,108,30,-87,-53,13,7,-19,88,-124,60,42,28,76,-62,-104,-19,-108,-67,-31,39,93,65,-47,-127,52,1,37,90,-47,-70,34,-30,-7,60,-17,27,66,-51,-5,-64,72,13,74,-6,44,-89,77,-61,-103,-53,-36,22,-17,-113,90,-71,-5,-119,106,-104,94,-115,42,19,69,-103, 
  /* [17][0][][] */ -21,86,-119,-43,-51,31,-44,102,26,-33,99,-21,-62,101,31,-63,25,78,-62,67,20,-17,-61,-15,-118,8,-36,-89,-42,39,64,-97,46,-40,-35,41,34,-54,-30,42,-40,116,-28,-81,106,24,-80,-94,28,-110,-34,-108,-80,10,48,29,-61,77,-82,-66,101,84,69,67,-58,37,-95,71,-74,-70,11,-20,-43,-40,-12,43,-112,-61,109,-127,-57,-15,94,-45,77,38,-51,104,16,121,-45,57,-97,-56,76,-47, 
  /* [18][0][][] */ 74,-107,-116,-22,49,18,-110,-90,-55,49,-79,-74,-31,96,25,37,23,89,-88,-45,-77,52,25,40,18,-19,39,-105,-17,-124,35,-107,-41,86,105,-56,32,-36,-57,-78,-97,27,116,-57,-22,47,98,-54,86,10,-69,-86,-43,1,-29,36,78,23,-127,62,-95,-29,68,104,-13,29,-94,-103,98,-36,-70,91,-101,102,-2,115,30,90,-9,-42,-55,-51,-92,103,11,-59,96,21,76,32,-55,106,-91,-2,7,-121, 
  /* [19][0][][] */ 68,64,-109,74,102,80,-59,12,96,-36,8,-40,53,84,120,-45,39,-97,-37,119,-86,-82,29,126,62,-10,34,-29,86,42,116,-110,58,-21,-92,86,-107,-21,-66,21,72,42,52,52,-35,54,-106,108,124,34,64,-20,70,-84,92,111,65,9,-120,-45,-37,60,115,-50,102,-5,-75,92,115,-10,-95,13,14,83,16,98,14,89,-80,92,-103,-60,113,-91,47,19,85,-75,-73,-2,-25,12,-20,-38,92,-127, 
  /* [20][0][][] */ 9,-82,-16,71,92,19,75,41,-48,-69,19,-4,-11,-83,0,-87,-18,-52,97,31,49,-106,88,-25,-72,101,-79,15,0,-75,-48,4,51,95,75,-56,94,16,-104,24,91,-104,-82,-25,44,14,-36,-44,74,-14,127,-77,-1,92,21,-84,-59,-119,75,14,-35,84,63,73,24,89,29,-58,29,73,-72,17,-90,-73,-37,105,-12,-85,38,23,10,103,74,-51,48,14,-70,-107,101,10,-96,-79,54,-62,20,67, 
  /* [21][0][][] */ 66,94,96,-86,-38,-52,-90,-52,-33,93,17,-95,-56,-79,-101,-104,-37,-28,-83,-101,-40,48,99,-58,84,21,71,-26,-63,-101,92,5,-110,20,92,91,-118,-87,-117,16,-2,43,-47,4,-82,87,-127,63,55,-119,-13,-71,53,-55,-113,-65,-36,-71,74,80,7,-50,-10,50,-49,42,-75,-7,-8,-62,-18,4,-44,-106,-65,-3,-90,98,103,73,-48,94,-6,-23,-125,-74,11,28,-48,41,-76,90,-38,-81,99,-37, 
  /* [22][0][][] */ -25,-68,83,-32,-92,-120,100,54,43,-35,-36,6,-50,23,-38,-123,-121,-19,-81,73,34,110,-28,79,-82,36,-95,66,-65,-94,-87,-91,-91,115,28,40,18,-112,-83,-82,-37,-15,-92,-9,65,-60,117,-93,-96,-17,-101,74,-98,115,-27,43,104,75,-94,86,-86,-24,-18,10,83,-124,-109,-41,60,106,-112,-57,-3,113,-96,-39,-123,-112,51,2,93,-56,-127,-71,36,80,-48,106,14,91,121,14,-125,80,83,124, 
  /* [23][0][][] */ -53,-6,-2,-58,-111,12,54,8,6,-103,50,-107,-127,80,59,-57,28,34,48,30,49,91,52,-10,29,-65,-77,-75,-99,81,-13,115,59,-74,98,-29,-9,104,73,-93,111,39,91,-103,-107,-6,-104,100,17,101,-63,-13,-88,102,71,4,38,-15,32,-33,-54,47,82,-126,106,-100,2,-29,93,99,-78,108,90,25,18,-53,-111,11,-103,-39,-113,1,-96,-86,-58,-123,104,-115,-40,-80,-51,-82,2,-51,-74,99, 
  /* [24][0][][] */ -3,93,111,94,52,-19,-100,112,-1,-94,-77,96,6,7,-1,-57,-17,48,-91,92,127,-19,-20,42,-30,71,-62,-63,95,119,106,-19,105,-41,-5,-21,21,-37,-87,-82,13,118,-73,52,-41,83,59,-60,-94,-54,8,-13,-60,84,125,-37,73,-44,-31,-22,116,38,62,-25,-114,1,-60,118,71,-77,-10,40,-5,-103,-11,-36,33,-52,-24,45,77,-53,64,-41,-75,-61,-18,-54,-78,90,-67,-27,-63,-63,82,106, 
  /* [25][0][][] */ 17,12,53,94,35,53,-36,51,-14,26,79,65,-33,52,94,-43,-7,-18,-35,-31,36,110,15,107,69,-8,-51,-6,57,33,-73,13,-28,-52,113,96,-38,51,-46,109,-66,87,51,41,1,-77,-57,-70,-20,-3,-12,-64,6,-14,-103,-68,-8,-26,127,48,-59,114,-56,-7,-82,-73,-30,88,-34,5,64,28,55,66,6,36,-12,36,49,-10,-81,30,-58,-4,67,33,21,2,-91,61,1,-42,-22,18,37,72, 
  /* [26][0][][] */ 78,-85,-6,-2,85,-107,95,-48,43,-40,-93,-2,-33,-74,31,-27,95,5,-84,-82,38,-57,63,84,6,-40,39,40,15,-11,-57,-46,-25,44,43,109,-7,86,-127,101,89,2,-34,-105,-12,44,111,5,12,47,91,-28,92,99,54,25,78,-2,-54,-21,10,112,-91,-118,47,-36,-112,-37,-7,-53,24,34,-115,-62,-90,-82,-26,16,-28,85,98,14,-59,-31,-20,-49,-14,-97,17,8,90,106,-56,47,36,-29, 
  /* [27][0][][] */ 54,38,-113,122,-38,-37,-1,-11,-91,82,-36,-14,-108,68,73,-54,35,-119,-17,-120,-32,50,78,-96,-119,66,-47,49,82,-70,57,-126,114,-92,29,100,102,50,-82,-46,26,48,-31,54,59,-99,97,-77,-24,-72,63,83,103,51,-127,-94,81,-33,-34,5,30,-81,-122,-97,20,102,20,-98,31,-10,26,-112,17,-83,-5,-87,-93,-10,65,45,-68,-86,82,-5,-113,-99,55,-41,103,10,46,98,84,23,56,-97, 
  /* [28][0][][] */ -107,107,-49,61,3,88,-93,-2,52,-55,-88,75,41,-63,21,-90,-61,72,31,91,96,70,10,-75,52,-61,75,102,-43,21,-16,43,-35,19,-34,-50,36,93,-33,109,-81,-21,-3,62,100,104,-12,8,103,8,-127,13,58,-37,29,61,96,39,14,78,44,-29,7,-105,-66,1,83,-42,-72,54,65,107,-104,47,108,29,63,-37,-7,45,-58,52,60,-15,54,17,-73,-49,-80,22,67,-77,50,61,-5,79, 
  /* [29][0][][] */ 18,-25,34,30,-36,2,19,-118,-59,-39,-55,-90,73,-24,-86,-31,88,89,-79,96,28,-72,-92,-94,84,-64,-105,-55,-48,83,-69,20,-105,113,114,-2,-31,-100,21,-33,108,-56,-25,31,-89,57,-120,-2,-38,69,23,40,-91,-20,83,91,38,-19,-60,1,117,99,-77,32,73,-91,-122,44,66,-21,-36,-52,-32,-127,-29,-99,-66,28,-2,61,-10,-47,28,-36,19,-119,-71,85,-17,30,-71,-66,-105,-14,-71,-74, 
  /* [30][0][][] */ -80,-95,-92,-57,60,98,59,9,-77,43,33,67,79,63,-105,-116,101,120,78,9,-8,-77,127,-73,12,63,-24,14,88,-47,12,52,-7,-29,25,31,-88,-32,85,-19,-7,-95,-69,-86,88,126,-37,-31,-67,116,-122,-39,-114,-19,103,-100,110,53,-23,-2,-50,-113,51,81,121,105,32,73,96,85,118,-78,28,-118,-91,26,65,-27,-3,-66,57,44,111,49,88,-57,65,47,118,43,50,-124,16,89,-70,-84, 
  /* [31][0][][] */ 46,123,81,-28,-58,-6,101,-89,-80,-57,62,-66,-69,-91,96,23,-10,50,-26,25,-28,-42,100,5,81,94,-44,-59,-23,82,57,63,92,34,64,107,50,112,-18,-85,-6,106,-97,35,27,101,48,-10,-111,-28,-40,60,23,-89,-21,-10,1,39,55,119,-7,-122,116,-105,21,-99,82,-66,-118,37,114,-37,82,-66,-39,60,-12,87,57,-52,-8,-8,-119,-92,-34,79,127,-113,-76,85,48,-24,-57,-47,-121,91, 
};
const TfArray<4, int> tensor_dimension40 = { 4, { 32,1,1,96 } };
const TfArray<32, float> quant40_scale = { 32, { 0.0019166087731719017, 0.0018747317371889949, 0.0018135744612663984, 0.0021906935144215822, 0.0017649566289037466, 0.001790233887732029, 0.0020112630445510149, 0.0017848399002104998, 0.0017780073685571551, 0.0018027995247393847, 0.0017449661390855908, 0.0018831989727914333, 0.0023567683529108763, 0.0020744160283356905, 0.0017322550993412733, 0.001738673890940845, 0.0017617444973438978, 0.001824225066229701, 0.0018386709270998836, 0.0017127863829955459, 0.0019793158862739801, 0.0018463196465745568, 0.0018161663319915533, 0.0017987772589549422, 0.0017937378725036979, 0.0025150773581117392, 0.0018374917563050985, 0.0018329152371734381, 0.0020199234131723642, 0.0017923919949680567, 0.001739261788316071, 0.0017062348779290915, } };
const TfArray<32, int> quant40_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant40 = { (TfLiteFloatArray*)&quant40_scale, (TfLiteIntArray*)&quant40_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int32_t tensor_data41[32] = { -322, -190, -314, -28, 140, 153, 1111, -346, 200, -340, -199, 55, 1071, -176, 171, -117, -327, 95, 72, 162, -127, -538, -165, -256, 207, 1280, -325, -262, 114, -189, 245, -167, };
const TfArray<1, int> tensor_dimension41 = { 1, { 32 } };
const TfArray<32, float> quant41_scale = { 32, { 4.5096676331013441e-05, 4.4111337047070265e-05, 4.2672341805882752e-05, 5.1545732276281342e-05, 4.1528390283929184e-05, 4.2123152525164187e-05, 4.7323836042778566e-05, 4.1996234358521178e-05, 4.1835468437056988e-05, 4.2418814700795338e-05, 4.1058028728002682e-05, 4.4310563680483028e-05, 5.5453372624469921e-05, 4.8809790314408019e-05, 4.0758943214314058e-05, 4.0909973904490471e-05, 4.1452811274211854e-05, 4.2922943976009265e-05, 4.3262847611913458e-05, 4.0300856198882684e-05, 4.6572138671763241e-05, 4.3442814785521477e-05, 4.273332524462603e-05, 4.2324172682128847e-05, 4.2205596400890499e-05, 5.9178291849093512e-05, 4.3235100747551769e-05, 4.3127416574861854e-05, 4.7527610149700195e-05, 4.2173931433353573e-05, 4.0923809137893841e-05, 4.0146704122889787e-05, } };
const TfLiteAffineQuantization quant41 = { (TfLiteFloatArray*)&quant41_scale, (TfLiteIntArray*)&g0::quant40_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) int8_t tensor_data42[2*1*1*32] = { 
  /* [0][0][][] */ -39,2,-40,-40,68,-7,127,-8,15,-70,-83,-67,122,-32,78,-9,-78,-3,45,10,73,-28,85,-38,-46,109,9,-82,-67,-73,5,20, 
  /* [1][0][][] */ 95,127,-93,-83,19,110,-15,-53,76,-105,-94,57,-100,6,38,87,-93,106,109,79,-73,-2,-16,47,109,-24,-85,-95,67,87,125,-119, 
};
const TfArray<4, int> tensor_dimension42 = { 4, { 2,1,1,32 } };
const TfArray<2, float> quant42_scale = { 2, { 0.0043618269264698029, 0.0031924715731292963, } };
const TfArray<2, int> quant42_zero = { 2, { 0,0 } };
const TfLiteAffineQuantization quant42 = { (TfLiteFloatArray*)&quant42_scale, (TfLiteIntArray*)&quant42_zero, 0 };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(8) int32_t tensor_data43[2] = { 21280, -28902, };
const TfArray<1, int> tensor_dimension43 = { 1, { 2 } };
const TfArray<2, float> quant43_scale = { 2, { 0.00021913298405706882, 0.000160385956405662, } };
const TfLiteAffineQuantization quant43 = { (TfLiteFloatArray*)&quant43_scale, (TfLiteIntArray*)&g0::quant42_zero, 0 };
const TfArray<4, int> tensor_dimension44 = { 4, { 1,48,48,16 } };
const TfArray<1, float> quant44_scale = { 1, { 0.023529412224888802, } };
const TfLiteAffineQuantization quant44 = { (TfLiteFloatArray*)&quant44_scale, (TfLiteIntArray*)&g0::quant0_zero, 0 };
const TfArray<4, int> tensor_dimension46 = { 4, { 1,48,48,8 } };
const TfArray<1, float> quant46_scale = { 1, { 0.52403396368026733, } };
const TfArray<1, int> quant46_zero = { 1, { 3 } };
const TfLiteAffineQuantization quant46 = { (TfLiteFloatArray*)&quant46_scale, (TfLiteIntArray*)&quant46_zero, 0 };
const TfArray<4, int> tensor_dimension47 = { 4, { 1,48,48,48 } };
const TfArray<4, int> tensor_dimension48 = { 4, { 1,49,49,48 } };
const TfArray<4, int> tensor_dimension49 = { 4, { 1,24,24,48 } };
const TfArray<4, int> tensor_dimension50 = { 4, { 1,24,24,8 } };
const TfArray<1, float> quant50_scale = { 1, { 0.41056805849075317, } };
const TfArray<1, int> quant50_zero = { 1, { 13 } };
const TfLiteAffineQuantization quant50 = { (TfLiteFloatArray*)&quant50_scale, (TfLiteIntArray*)&quant50_zero, 0 };
const TfArray<1, float> quant53_scale = { 1, { 0.47892078757286072, } };
const TfArray<1, int> quant53_zero = { 1, { -23 } };
const TfLiteAffineQuantization quant53 = { (TfLiteFloatArray*)&quant53_scale, (TfLiteIntArray*)&quant53_zero, 0 };
const TfArray<1, float> quant54_scale = { 1, { 0.5284353494644165, } };
const TfArray<1, int> quant54_zero = { 1, { -6 } };
const TfLiteAffineQuantization quant54 = { (TfLiteFloatArray*)&quant54_scale, (TfLiteIntArray*)&quant54_zero, 0 };
const TfArray<4, int> tensor_dimension56 = { 4, { 1,25,25,48 } };
const TfArray<4, int> tensor_dimension57 = { 4, { 1,12,12,48 } };
const TfArray<4, int> tensor_dimension58 = { 4, { 1,12,12,16 } };
const TfArray<1, float> quant58_scale = { 1, { 0.28304332494735718, } };
const TfArray<1, int> quant58_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant58 = { (TfLiteFloatArray*)&quant58_scale, (TfLiteIntArray*)&quant58_zero, 0 };
const TfArray<4, int> tensor_dimension59 = { 4, { 1,12,12,96 } };
const TfArray<1, float> quant61_scale = { 1, { 0.21897944808006287, } };
const TfArray<1, int> quant61_zero = { 1, { -16 } };
const TfLiteAffineQuantization quant61 = { (TfLiteFloatArray*)&quant61_scale, (TfLiteIntArray*)&quant61_zero, 0 };
const TfArray<1, float> quant62_scale = { 1, { 0.30694788694381714, } };
const TfArray<1, int> quant62_zero = { 1, { 1 } };
const TfLiteAffineQuantization quant62 = { (TfLiteFloatArray*)&quant62_scale, (TfLiteIntArray*)&quant62_zero, 0 };
const TfArray<1, float> quant65_scale = { 1, { 0.2389644980430603, } };
const TfArray<1, int> quant65_zero = { 1, { 8 } };
const TfLiteAffineQuantization quant65 = { (TfLiteFloatArray*)&quant65_scale, (TfLiteIntArray*)&quant65_zero, 0 };
const TfArray<1, float> quant66_scale = { 1, { 0.32814642786979675, } };
const TfLiteAffineQuantization quant66 = { (TfLiteFloatArray*)&quant66_scale, (TfLiteIntArray*)&g0::quant46_zero, 0 };
const TfArray<4, int> tensor_dimension68 = { 4, { 1,12,12,32 } };
const TfArray<1, float> quant68_scale = { 1, { 0.050238806754350662, } };
const TfLiteAffineQuantization quant68 = { (TfLiteFloatArray*)&quant68_scale, (TfLiteIntArray*)&g0::quant0_zero, 0 };
const TfArray<4, int> tensor_dimension69 = { 4, { 1,12,12,2 } };
const TfArray<1, float> quant69_scale = { 1, { 0.12066017836332321, } };
const TfArray<1, int> quant69_zero = { 1, { -21 } };
const TfLiteAffineQuantization quant69 = { (TfLiteFloatArray*)&quant69_scale, (TfLiteIntArray*)&quant69_zero, 0 };
const TfArray<1, float> quant70_scale = { 1, { 0.00390625, } };
const TfLiteAffineQuantization quant70 = { (TfLiteFloatArray*)&quant70_scale, (TfLiteIntArray*)&g0::quant0_zero, 0 };
const TfLiteConvParams opdata0 = { kTfLitePaddingSame, 2,2, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs0 = { 3, { 0,2,3 } };
const TfArray<1, int> outputs0 = { 1, { 44 } };
const TfLiteDepthwiseConvParams opdata1 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs1 = { 3, { 44,4,5 } };
const TfArray<1, int> outputs1 = { 1, { 45 } };
const TfLiteConvParams opdata2 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs2 = { 3, { 45,6,7 } };
const TfArray<1, int> outputs2 = { 1, { 46 } };
const TfLiteConvParams opdata3 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs3 = { 3, { 46,8,9 } };
const TfArray<1, int> outputs3 = { 1, { 47 } };
const TfArray<2, int> inputs4 = { 2, { 47,1 } };
const TfArray<1, int> outputs4 = { 1, { 48 } };
const TfLiteDepthwiseConvParams opdata5 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs5 = { 3, { 48,10,11 } };
const TfArray<1, int> outputs5 = { 1, { 49 } };
const TfLiteConvParams opdata6 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs6 = { 3, { 49,12,13 } };
const TfArray<1, int> outputs6 = { 1, { 50 } };
const TfLiteConvParams opdata7 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs7 = { 3, { 50,14,15 } };
const TfArray<1, int> outputs7 = { 1, { 51 } };
const TfLiteDepthwiseConvParams opdata8 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs8 = { 3, { 51,16,17 } };
const TfArray<1, int> outputs8 = { 1, { 52 } };
const TfLiteConvParams opdata9 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs9 = { 3, { 52,18,19 } };
const TfArray<1, int> outputs9 = { 1, { 53 } };
const TfLiteAddParams opdata10 = { kTfLiteActNone };
const TfArray<2, int> inputs10 = { 2, { 50,53 } };
const TfArray<1, int> outputs10 = { 1, { 54 } };
const TfLiteConvParams opdata11 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs11 = { 3, { 54,20,21 } };
const TfArray<1, int> outputs11 = { 1, { 55 } };
const TfArray<2, int> inputs12 = { 2, { 55,1 } };
const TfArray<1, int> outputs12 = { 1, { 56 } };
const TfLiteDepthwiseConvParams opdata13 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs13 = { 3, { 56,22,23 } };
const TfArray<1, int> outputs13 = { 1, { 57 } };
const TfLiteConvParams opdata14 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs14 = { 3, { 57,24,25 } };
const TfArray<1, int> outputs14 = { 1, { 58 } };
const TfLiteConvParams opdata15 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs15 = { 3, { 58,26,27 } };
const TfArray<1, int> outputs15 = { 1, { 59 } };
const TfLiteDepthwiseConvParams opdata16 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs16 = { 3, { 59,28,29 } };
const TfArray<1, int> outputs16 = { 1, { 60 } };
const TfLiteConvParams opdata17 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs17 = { 3, { 60,30,31 } };
const TfArray<1, int> outputs17 = { 1, { 61 } };
const TfLiteAddParams opdata18 = { kTfLiteActNone };
const TfArray<2, int> inputs18 = { 2, { 58,61 } };
const TfArray<1, int> outputs18 = { 1, { 62 } };
const TfLiteConvParams opdata19 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs19 = { 3, { 62,32,33 } };
const TfArray<1, int> outputs19 = { 1, { 63 } };
const TfLiteDepthwiseConvParams opdata20 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs20 = { 3, { 63,34,35 } };
const TfArray<1, int> outputs20 = { 1, { 64 } };
const TfLiteConvParams opdata21 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs21 = { 3, { 64,36,37 } };
const TfArray<1, int> outputs21 = { 1, { 65 } };
const TfLiteAddParams opdata22 = { kTfLiteActNone };
const TfArray<2, int> inputs22 = { 2, { 62,65 } };
const TfArray<1, int> outputs22 = { 1, { 66 } };
const TfLiteConvParams opdata23 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs23 = { 3, { 66,38,39 } };
const TfArray<1, int> outputs23 = { 1, { 67 } };
const TfLiteConvParams opdata24 = { kTfLitePaddingValid, 1,1, kTfLiteActRelu, 1,1 };
const TfArray<3, int> inputs24 = { 3, { 67,40,41 } };
const TfArray<1, int> outputs24 = { 1, { 68 } };
const TfLiteConvParams opdata25 = { kTfLitePaddingValid, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs25 = { 3, { 68,42,43 } };
const TfArray<1, int> outputs25 = { 1, { 69 } };
const TfLiteSoftmaxParams opdata26 = { 1 };
const TfArray<1, int> inputs26 = { 1, { 69 } };
const TfArray<1, int> outputs26 = { 1, { 70 } };
};

TensorInfo_t tensorData[] = {
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension0, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant0))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data1, (TfLiteIntArray*)&g0::tensor_dimension1, 32, {kTfLiteNoQuantization, nullptr}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data2, (TfLiteIntArray*)&g0::tensor_dimension2, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant2))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data3, (TfLiteIntArray*)&g0::tensor_dimension3, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant3))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data4, (TfLiteIntArray*)&g0::tensor_dimension4, 144, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant4))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data5, (TfLiteIntArray*)&g0::tensor_dimension3, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant5))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data6, (TfLiteIntArray*)&g0::tensor_dimension6, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant6))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data7, (TfLiteIntArray*)&g0::tensor_dimension7, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant7))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data8, (TfLiteIntArray*)&g0::tensor_dimension8, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant8))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data9, (TfLiteIntArray*)&g0::tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant9))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data10, (TfLiteIntArray*)&g0::tensor_dimension10, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant10))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data11, (TfLiteIntArray*)&g0::tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant11))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data12, (TfLiteIntArray*)&g0::tensor_dimension12, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant12))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data13, (TfLiteIntArray*)&g0::tensor_dimension7, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant13))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data14, (TfLiteIntArray*)&g0::tensor_dimension8, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant14))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data15, (TfLiteIntArray*)&g0::tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant15))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data16, (TfLiteIntArray*)&g0::tensor_dimension10, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant16))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data17, (TfLiteIntArray*)&g0::tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant17))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data18, (TfLiteIntArray*)&g0::tensor_dimension12, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant18))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data19, (TfLiteIntArray*)&g0::tensor_dimension7, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant19))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data20, (TfLiteIntArray*)&g0::tensor_dimension8, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant20))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data21, (TfLiteIntArray*)&g0::tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant21))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data22, (TfLiteIntArray*)&g0::tensor_dimension10, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant22))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data23, (TfLiteIntArray*)&g0::tensor_dimension9, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant23))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data24, (TfLiteIntArray*)&g0::tensor_dimension24, 768, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant24))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data25, (TfLiteIntArray*)&g0::tensor_dimension3, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant25))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data26, (TfLiteIntArray*)&g0::tensor_dimension26, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant26))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data27, (TfLiteIntArray*)&g0::tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant27))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data28, (TfLiteIntArray*)&g0::tensor_dimension28, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant28))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data29, (TfLiteIntArray*)&g0::tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant29))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data30, (TfLiteIntArray*)&g0::tensor_dimension30, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant30))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data31, (TfLiteIntArray*)&g0::tensor_dimension3, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant31))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data32, (TfLiteIntArray*)&g0::tensor_dimension26, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant32))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data33, (TfLiteIntArray*)&g0::tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant33))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data34, (TfLiteIntArray*)&g0::tensor_dimension28, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant34))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data35, (TfLiteIntArray*)&g0::tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant35))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data36, (TfLiteIntArray*)&g0::tensor_dimension30, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant36))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data37, (TfLiteIntArray*)&g0::tensor_dimension3, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant37))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data38, (TfLiteIntArray*)&g0::tensor_dimension26, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant38))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data39, (TfLiteIntArray*)&g0::tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant39))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data40, (TfLiteIntArray*)&g0::tensor_dimension40, 3072, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant40))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data41, (TfLiteIntArray*)&g0::tensor_dimension41, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant41))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data42, (TfLiteIntArray*)&g0::tensor_dimension42, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant42))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data43, (TfLiteIntArray*)&g0::tensor_dimension43, 8, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant43))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 36864), (TfLiteIntArray*)&g0::tensor_dimension44, 36864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension44, 36864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 36864), (TfLiteIntArray*)&g0::tensor_dimension46, 18432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant46))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 115248), (TfLiteIntArray*)&g0::tensor_dimension47, 110592, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension48, 115248, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 115248), (TfLiteIntArray*)&g0::tensor_dimension49, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 55296), (TfLiteIntArray*)&g0::tensor_dimension50, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant50))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 27648), (TfLiteIntArray*)&g0::tensor_dimension49, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension49, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 27648), (TfLiteIntArray*)&g0::tensor_dimension50, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant53))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension50, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant54))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 30000), (TfLiteIntArray*)&g0::tensor_dimension49, 27648, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension56, 30000, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 30000), (TfLiteIntArray*)&g0::tensor_dimension57, 6912, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 36912), (TfLiteIntArray*)&g0::tensor_dimension58, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant58))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 13824), (TfLiteIntArray*)&g0::tensor_dimension59, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension59, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 13824), (TfLiteIntArray*)&g0::tensor_dimension58, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant61))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 27648), (TfLiteIntArray*)&g0::tensor_dimension58, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant62))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 13824), (TfLiteIntArray*)&g0::tensor_dimension59, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension59, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 16128), (TfLiteIntArray*)&g0::tensor_dimension58, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant65))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 13824), (TfLiteIntArray*)&g0::tensor_dimension58, 2304, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant66))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension59, 13824, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant44))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 13824), (TfLiteIntArray*)&g0::tensor_dimension68, 4608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant68))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 288), (TfLiteIntArray*)&g0::tensor_dimension69, 288, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant69))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension69, 288, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant70))}, },
};

#ifndef TF_LITE_STATIC_MEMORY
TfLiteNode tflNodes[27] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs3, (TfLiteIntArray*)&g0::outputs3, (TfLiteIntArray*)&g0::inputs3, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata3)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs4, (TfLiteIntArray*)&g0::outputs4, (TfLiteIntArray*)&g0::inputs4, nullptr, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs5, (TfLiteIntArray*)&g0::outputs5, (TfLiteIntArray*)&g0::inputs5, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata5)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs6, (TfLiteIntArray*)&g0::outputs6, (TfLiteIntArray*)&g0::inputs6, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata6)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs7, (TfLiteIntArray*)&g0::outputs7, (TfLiteIntArray*)&g0::inputs7, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata7)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs8, (TfLiteIntArray*)&g0::outputs8, (TfLiteIntArray*)&g0::inputs8, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata8)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs9, (TfLiteIntArray*)&g0::outputs9, (TfLiteIntArray*)&g0::inputs9, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata9)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs10, (TfLiteIntArray*)&g0::outputs10, (TfLiteIntArray*)&g0::inputs10, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata10)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs11, (TfLiteIntArray*)&g0::outputs11, (TfLiteIntArray*)&g0::inputs11, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata11)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs12, (TfLiteIntArray*)&g0::outputs12, (TfLiteIntArray*)&g0::inputs12, nullptr, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs13, (TfLiteIntArray*)&g0::outputs13, (TfLiteIntArray*)&g0::inputs13, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata13)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs14, (TfLiteIntArray*)&g0::outputs14, (TfLiteIntArray*)&g0::inputs14, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata14)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs15, (TfLiteIntArray*)&g0::outputs15, (TfLiteIntArray*)&g0::inputs15, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata15)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs16, (TfLiteIntArray*)&g0::outputs16, (TfLiteIntArray*)&g0::inputs16, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata16)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs17, (TfLiteIntArray*)&g0::outputs17, (TfLiteIntArray*)&g0::inputs17, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata17)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs18, (TfLiteIntArray*)&g0::outputs18, (TfLiteIntArray*)&g0::inputs18, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata18)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs19, (TfLiteIntArray*)&g0::outputs19, (TfLiteIntArray*)&g0::inputs19, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata19)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs20, (TfLiteIntArray*)&g0::outputs20, (TfLiteIntArray*)&g0::inputs20, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata20)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs21, (TfLiteIntArray*)&g0::outputs21, (TfLiteIntArray*)&g0::inputs21, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata21)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs22, (TfLiteIntArray*)&g0::outputs22, (TfLiteIntArray*)&g0::inputs22, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata22)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs23, (TfLiteIntArray*)&g0::outputs23, (TfLiteIntArray*)&g0::inputs23, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata23)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs24, (TfLiteIntArray*)&g0::outputs24, (TfLiteIntArray*)&g0::inputs24, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata24)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs25, (TfLiteIntArray*)&g0::outputs25, (TfLiteIntArray*)&g0::inputs25, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata25)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs26, (TfLiteIntArray*)&g0::outputs26, (TfLiteIntArray*)&g0::inputs26, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata26)), nullptr, 0, },
};
#else
TfLiteNode tflNodes[27] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs3, (TfLiteIntArray*)&g0::outputs3, (TfLiteIntArray*)&g0::inputs3, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata3)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs4, (TfLiteIntArray*)&g0::outputs4, (TfLiteIntArray*)&g0::inputs4, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs5, (TfLiteIntArray*)&g0::outputs5, (TfLiteIntArray*)&g0::inputs5, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata5)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs6, (TfLiteIntArray*)&g0::outputs6, (TfLiteIntArray*)&g0::inputs6, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata6)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs7, (TfLiteIntArray*)&g0::outputs7, (TfLiteIntArray*)&g0::inputs7, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata7)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs8, (TfLiteIntArray*)&g0::outputs8, (TfLiteIntArray*)&g0::inputs8, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata8)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs9, (TfLiteIntArray*)&g0::outputs9, (TfLiteIntArray*)&g0::inputs9, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata9)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs10, (TfLiteIntArray*)&g0::outputs10, (TfLiteIntArray*)&g0::inputs10, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata10)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs11, (TfLiteIntArray*)&g0::outputs11, (TfLiteIntArray*)&g0::inputs11, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata11)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs12, (TfLiteIntArray*)&g0::outputs12, (TfLiteIntArray*)&g0::inputs12, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs13, (TfLiteIntArray*)&g0::outputs13, (TfLiteIntArray*)&g0::inputs13, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata13)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs14, (TfLiteIntArray*)&g0::outputs14, (TfLiteIntArray*)&g0::inputs14, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata14)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs15, (TfLiteIntArray*)&g0::outputs15, (TfLiteIntArray*)&g0::inputs15, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata15)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs16, (TfLiteIntArray*)&g0::outputs16, (TfLiteIntArray*)&g0::inputs16, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata16)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs17, (TfLiteIntArray*)&g0::outputs17, (TfLiteIntArray*)&g0::inputs17, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata17)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs18, (TfLiteIntArray*)&g0::outputs18, (TfLiteIntArray*)&g0::inputs18, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata18)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs19, (TfLiteIntArray*)&g0::outputs19, (TfLiteIntArray*)&g0::inputs19, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata19)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs20, (TfLiteIntArray*)&g0::outputs20, (TfLiteIntArray*)&g0::inputs20, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata20)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs21, (TfLiteIntArray*)&g0::outputs21, (TfLiteIntArray*)&g0::inputs21, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata21)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs22, (TfLiteIntArray*)&g0::outputs22, (TfLiteIntArray*)&g0::inputs22, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata22)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs23, (TfLiteIntArray*)&g0::outputs23, (TfLiteIntArray*)&g0::inputs23, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata23)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs24, (TfLiteIntArray*)&g0::outputs24, (TfLiteIntArray*)&g0::inputs24, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata24)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs25, (TfLiteIntArray*)&g0::outputs25, (TfLiteIntArray*)&g0::inputs25, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata25)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs26, (TfLiteIntArray*)&g0::outputs26, (TfLiteIntArray*)&g0::inputs26, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata26)), nullptr, 0, },
};
#endif

used_operators_e used_ops[] =
{OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_PAD, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_ADD, OP_CONV_2D, OP_PAD, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_ADD, OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_ADD, OP_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_SOFTMAX, };


// Indices into tflTensors and tflNodes for subgraphs
const size_t tflTensors_subgraph_index[] = {0, 71, };
const size_t tflNodes_subgraph_index[] = {0, 27, };

// Input/output tensors
static const int in_tensor_indices[] = {
  0, 
};

static const int out_tensor_indices[] = {
  70, 
};


size_t current_subgraph_index = 0;

static void init_tflite_tensor(size_t i, TfLiteTensor *tensor) {
  tensor->type = tensorData[i].type;
  tensor->is_variable = false;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  tensor->allocation_type = tensorData[i].allocation_type;
#else
  tensor->allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
  tensor->bytes = tensorData[i].bytes;
  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  if(tensor->allocation_type == kTfLiteArenaRw){
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
      tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
  tensor->quantization = tensorData[i].quantization;
  if (tensor->quantization.type == kTfLiteAffineQuantization) {
    TfLiteAffineQuantization const* quant = ((TfLiteAffineQuantization const*)(tensorData[i].quantization.params));
    tensor->params.scale = quant->scale->data[0];
    tensor->params.zero_point = quant->zero_point->data[0];
  }

}

static void init_tflite_eval_tensor(int i, TfLiteEvalTensor *tensor) {

  tensor->type = tensorData[i].type;

  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  auto allocation_type = tensorData[i].allocation_type;
  if(allocation_type == kTfLiteArenaRw) {
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
    tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
}

static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBufferImpl(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  uint32_t align_bytes = (bytes % 16) ? 16 - (bytes % 16) : 0;

  if (current_location - (bytes + align_bytes) < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  // align to the left aligned boundary of 16 bytes
  current_location -= 15; // for alignment
  current_location += 16 - ((uintptr_t)(current_location) & 15);

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}

typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;

static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArenaImpl(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBufferImpl(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBufferImpl(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static const uint16_t TENSOR_IX_UNUSED = 0x7FFF;

static void ResetTensors() {
  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    tflTensors[ix].index = TENSOR_IX_UNUSED;
  }
  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    tflEvalTensors[ix].index = TENSOR_IX_UNUSED;
  }
}

static TfLiteTensor* GetTensorImpl(const struct TfLiteContext* context,
                               int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    // already used? OK!
    if (tflTensors[ix].index == tensor_idx) {
      return &tflTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_tensor(tensor_idx, &tflTensors[ix].tensor);
      tflTensors[ix].index = tensor_idx;
      return &tflTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_TENSOR_COUNT (%d)\n", MAX_TFL_TENSOR_COUNT);
  return nullptr;
}

static TfLiteEvalTensor* GetEvalTensorImpl(const struct TfLiteContext* context,
                                       int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    // already used? OK!
    if (tflEvalTensors[ix].index == tensor_idx) {
      return &tflEvalTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflEvalTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_eval_tensor(tensor_idx, &tflEvalTensors[ix].tensor);
      tflEvalTensors[ix].index = tensor_idx;
      return &tflEvalTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_EVAL_COUNT (%d)\n", (int)MAX_TFL_EVAL_COUNT);
  return nullptr;
}

class EonMicroContext : public MicroContext {
 public:
 
  EonMicroContext(): MicroContext(nullptr, nullptr, nullptr) { }

  void* AllocatePersistentBuffer(size_t bytes) {
    return AllocatePersistentBufferImpl(nullptr, bytes);
  }

  TfLiteStatus RequestScratchBufferInArena(size_t bytes,
                                           int* buffer_index) {
  return RequestScratchBufferInArenaImpl(nullptr, bytes, buffer_index);
  }

  void* GetScratchBuffer(int buffer_index) {
    return GetScratchBufferImpl(nullptr, buffer_index);
  }
 
  TfLiteTensor* AllocateTempTfLiteTensor(int tensor_index) {
    return GetTensorImpl(nullptr, tensor_index);
  }

  void DeallocateTempTfLiteTensor(TfLiteTensor* tensor) {
    return;
  }

  bool IsAllTempTfLiteTensorDeallocated() {
    return true;
  }

  TfLiteEvalTensor* GetEvalTensor(int tensor_index) {
    return GetEvalTensorImpl(nullptr, tensor_index);
  }

};


} // namespace

TfLiteStatus tflite_learn_828368_19_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;

  EonMicroContext micro_context_;
  
  // Set microcontext as the context ptr
  ctx.impl_ = static_cast<void*>(&micro_context_);
  // Setup tflitecontext functions
  ctx.AllocatePersistentBuffer = &AllocatePersistentBufferImpl;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArenaImpl;
  ctx.GetScratchBuffer = &GetScratchBufferImpl;
  ctx.GetTensor = &GetTensorImpl;
  ctx.GetEvalTensor = &GetEvalTensorImpl;
  ctx.ReportError = &MicroContextReportOpError;

  ctx.tensors_size = 71;
  for (size_t i = 0; i < 71; ++i) {
    TfLiteTensor tensor;
    init_tflite_tensor(i, &tensor);
    if (tensor.allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tensor.data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }

  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }

  registrations[OP_CONV_2D] = Register_CONV_2D();
  registrations[OP_DEPTHWISE_CONV_2D] = Register_DEPTHWISE_CONV_2D();
  registrations[OP_PAD] = Register_PAD();
  registrations[OP_ADD] = Register_ADD();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].init) {
        tflNodes[i].user_data = registrations[used_ops[i]].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
      }
    }
  }
  current_subgraph_index = 0;

  for(size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].prepare) {
        ResetTensors();
        TfLiteStatus status = registrations[used_ops[i]].prepare(&ctx, &tflNodes[i]);
        if (status != kTfLiteOk) {
          return status;
        }
      }
    }
  }
  current_subgraph_index = 0;

  return kTfLiteOk;
}

TfLiteStatus tflite_learn_828368_19_input(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(in_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_828368_19_output(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(out_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_828368_19_invoke() {
  for (size_t i = 0; i < 27; ++i) {
    ResetTensors();

    TfLiteStatus status = registrations[used_ops[i]].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_828368_19_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
