# ESP32-S3 CAM

Camera vision system on XIAO ESP32-S3 Sense.

## Features

- Camera capture (OV2640/OV3660)
- I2C slave: receives request, returns result (0-80)
- WiFi debug server with keystone slider
- Vision pipeline: rotate 90 CCW, keystone correction, L-mark detection

## Hardware

- Board: Seeed Studio XIAO ESP32-S3 Sense
- Camera: Built-in OV2640/OV3660
- I2C: GPIO5 (SDA), GPIO6 (SCL), address 0x42

## Structure

```
include/
  camera_config.h    - Camera init
  i2c_comm.h         - I2C slave protocol
  wifi_server.h      - Web debug interface
  credentials.h      - WiFi credentials (create from .example)
  vision/
    image.h          - GrayImage buffer type
    transforms.h     - Rotate, keystone correction
    detector.h       - L-mark detection (stub)
src/
  main.cpp           - Entry point
```

## Setup

1. Copy credentials:
   ```
   cp include/credentials.h.example include/credentials.h
   ```

2. Edit `include/credentials.h` with your WiFi info

3. Build and upload:
   ```
   pio run -t upload
   pio device monitor
   ```

## I2C Protocol

Master sends 1 byte (request number), slave returns 1 byte (result 0-80).

## Web Interface

When `WIFI_DEBUG_MODE=1` (default), access `http://<IP>/` for:
- Camera preview
- Processed image (rotated + keystone)
- Keystone slider (-1.0 to +1.0)

## Vision Pipeline

1. Capture JPEG, decode to grayscale
2. Rotate 90 degrees counter-clockwise (camera mounted sideways)
3. Horizontal keystone correction (configurable)
4. L-mark detection at 4 corners (TODO)
